/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.base;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.base.ConnectionMessageHandler;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.IllegalThreadPoolStateException;
import org.freedesktop.dbus.interfaces.FatalException;
import org.freedesktop.dbus.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingMessageThread
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean terminate;
    private final ConnectionMessageHandler connection;

    /*
     * WARNING - void declaration
     */
    public IncomingMessageThread(ConnectionMessageHandler _connection, BusAddress _busAddress) {
        void var2_2;
        void var1_1;
        this.connection = (ConnectionMessageHandler)Objects.requireNonNull(var1_1);
        this.setName("DBusConnection [listener=" + var2_2.isListeningSocket() + "]");
        this.setDaemon(true);
    }

    public void terminate() {
        this.terminate = true;
        this.interrupt();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        while (!this.terminate) {
            try {
                Message msg = this.connection.readIncoming();
                if (msg == null) continue;
                this.logger.trace("Read message from {}: {}", (Object)this.connection.getTransport(), (Object)msg);
                this.connection.handleMessage(msg);
            }
            catch (RejectedExecutionException | DBusException | IllegalThreadPoolStateException exception) {
                void var1_1;
                Throwable _ex = exception;
                if (exception instanceof FatalException) {
                    if (this.terminate) {
                        return;
                    }
                    this.logger.error("FatalException in connection thread", _ex);
                    if (this.connection.isConnected()) {
                        this.terminate = true;
                        if ((_ex = _ex.getCause()) instanceof IOException) {
                            IOException ioe = (IOException)_ex;
                            this.connection.internalDisconnect((IOException)var1_1);
                            return;
                        }
                        this.connection.internalDisconnect(null);
                    }
                    return;
                }
                if (this.terminate) continue;
                this.logger.error("Exception in connection thread", (Throwable)var1_1);
            }
        }
    }
}

