/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.base;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.annotations.DBusProperty;
import org.freedesktop.dbus.connections.base.AbstractConnectionBase;
import org.freedesktop.dbus.connections.base.ConnectionMethodInvocation;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.impl.ConnectionConfig;
import org.freedesktop.dbus.errors.InvalidMethodArgument;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.propertyref.PropRefRemoteHandler;
import org.freedesktop.dbus.propertyref.PropertyRef;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class DBusBoundPropertyHandler
extends ConnectionMethodInvocation {
    private static final Method PROP_GETALL_METHOD = PropRefRemoteHandler.getPropertiesMethod("GetAll", String.class);

    /*
     * WARNING - void declaration
     */
    protected DBusBoundPropertyHandler(ConnectionConfig _conCfg, TransportConfig _transportConfig, ReceivingServiceConfig _rsCfg) throws DBusException {
        super((ConnectionConfig)var1_1, (TransportConfig)var2_2, (ReceivingServiceConfig)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected PropHandled handleDBusBoundProperties(ExportedObject _exportObject, MethodCall _methodCall, Object[] _params) throws DBusException {
        void var3_3;
        if (_params.length == 2 && _params[0] instanceof String && _params[1] instanceof String && _methodCall.getName().equals("Get")) {
            return this.handleGet(_exportObject, _methodCall, _params);
        }
        if (_params.length == 3 && _params[0] instanceof String && _params[1] instanceof String && _methodCall.getName().equals("Set")) {
            return this.handleSet(_exportObject, _methodCall, _params);
        }
        if (_params.length == 1 && var3_3[0] instanceof String && _methodCall.getName().equals("GetAll")) {
            void var2_2;
            void var1_1;
            return this.handleGetAll((ExportedObject)var1_1, (MethodCall)var2_2);
        }
        return PropHandled.NOT_HANDLED;
    }

    /*
     * WARNING - void declaration
     */
    protected PropHandled handleGetAll(ExportedObject _exportObject, MethodCall _methodCall) throws DBusException {
        Set<Map.Entry<PropertyRef, Method>> allPropertyMethods = _exportObject.getPropertyMethods().entrySet();
        if (!allPropertyMethods.isEmpty()) {
            void var1_1;
            void var2_2;
            void var3_3;
            DBusInterface object = _exportObject.getObject().get();
            if (object instanceof Properties) {
                meth = _exportObject.getMethods().get(new MethodTuple(_methodCall.getName(), _methodCall.getSig()));
                if (meth == null) {
                    DBusBoundPropertyHandler dBusBoundPropertyHandler = this;
                    dBusBoundPropertyHandler.sendMessage(dBusBoundPropertyHandler.getMessageFactory().createError(_methodCall, new UnknownMethod(String.format("The method `%s.%s' does not exist on this object.", _methodCall.getInterface(), _methodCall.getName()))));
                    return PropHandled.HANDLED;
                }
            } else {
                meth = PROP_GETALL_METHOD;
            }
            this.getReceivingService().execMethodCallHandler(() -> this.lambda$handleGetAll$0((Set)var3_3, (MethodCall)var2_2, object, (Method)var1_1));
            return PropHandled.HANDLED;
        }
        return PropHandled.NOT_HANDLED;
    }

    /*
     * WARNING - void declaration
     */
    protected PropHandled handleGet(ExportedObject _exportObject, MethodCall _methodCall, Object[] _params) {
        void var1_1;
        PropertyRef propertyRef = new PropertyRef((String)_params[1], null, DBusProperty.Access.READ);
        Method propMeth = _exportObject.getPropertyMethods().get(propertyRef);
        if (propMeth != null) {
            void var3_3;
            void var2_2;
            DBusInterface object = _exportObject.getObject().get();
            this.getReceivingService().execMethodCallHandler(() -> this.lambda$handleGet$1((MethodCall)var2_2, (Method)var3_3, var1_1));
            return PropHandled.HANDLED;
        }
        if (var1_1.getImplementedInterfaces().contains(Properties.class)) {
            return PropHandled.NOT_HANDLED;
        }
        return PropHandled.NO_PROPERTY;
    }

    /*
     * WARNING - void declaration
     */
    protected PropHandled handleSet(ExportedObject _exportObject, MethodCall _methodCall, Object[] _params) {
        PropertyRef propertyRef = new PropertyRef((String)_params[1], null, DBusProperty.Access.WRITE);
        Method propMeth = _exportObject.getPropertyMethods().get(propertyRef);
        if (propMeth != null) {
            void var1_1;
            void var2_2;
            void var3_3;
            DBusInterface object = _exportObject.getObject().get();
            Class<?> type = PropertyRef.typeForMethod(propMeth);
            AtomicBoolean isVariant = new AtomicBoolean(false);
            Object val = Optional.ofNullable(_params[2]).map(v -> {
                void var1_1;
                if (v instanceof Variant) {
                    AtomicBoolean atomicBoolean;
                    Variant va = (Variant)v;
                    atomicBoolean.set(true);
                    return var1_1.getValue();
                }
                return var1_1;
            }).orElse(null);
            this.getReceivingService().execMethodCallHandler(() -> this.lambda$handleSet$3(var3_3, propMeth, isVariant, (MethodCall)var2_2, type, var1_1));
            return PropHandled.HANDLED;
        }
        return PropHandled.NOT_HANDLED;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleSet$3(Object val, Method propMeth, AtomicBoolean isVariant, MethodCall _methodCall, Class type, Object object) {
        try {
            void var2_3;
            void var3_4;
            AbstractCollection myVal = val;
            Parameter[] parameters = propMeth.getParameters();
            if (parameters.length != 1) {
                throw new InvalidMethodArgument("Expected method with one argument, but found " + parameters.length);
            }
            if (Collection.class.isAssignableFrom(parameters[0].getType()) && var3_4.get() && myVal != null && myVal.getClass().isArray()) {
                myVal = Set.class.isAssignableFrom(parameters[0].getType()) ? new LinkedHashSet<Object>(Arrays.asList(Util.toObjectArray(myVal))) : new ArrayList<Object>(Arrays.asList(Util.toObjectArray(myVal)));
            }
            _methodCall.setArgs(Marshalling.deSerializeParameters(new Object[]{myVal}, new Type[]{type}, (AbstractConnectionBase)this));
            this.invokeMethodAndReply(_methodCall, (Method)var2_3, object, 1 == (_methodCall.getFlags() & 1));
            return;
        }
        catch (Exception _ex) {
            void var1_2;
            this.getLogger().debug("Failed to invoke method call on Properties", (Throwable)_ex);
            this.handleException(_methodCall, new UnknownMethod("Failure in de-serializing message: " + String.valueOf(var1_2)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleGet$1(MethodCall _methodCall, Method propMeth, Object object) {
        void var1_1;
        void var3_3;
        void var2_2;
        _methodCall.setArgs(new Object[0]);
        this.invokeMethodAndReply(_methodCall, (Method)var2_2, var3_3, 1 == (var1_1.getFlags() & 1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleGetAll$0(Set allPropertyMethods, MethodCall _methodCall, Object object, Method originalMeth) {
        HashMap<String, Variant<Object>> resultMap = new HashMap<String, Variant<Object>>();
        allPropertyMethods = allPropertyMethods.iterator();
        while (allPropertyMethods.hasNext()) {
            Map.Entry propEn = (Map.Entry)allPropertyMethods.next();
            Method propMeth = (Method)propEn.getValue();
            if (((PropertyRef)propEn.getKey()).getAccess() != DBusProperty.Access.READ) continue;
            try {
                _methodCall.setArgs(new Object[0]);
                Variant<Object> val = this.invokeMethod(_methodCall, propMeth, object);
                if (val != null && val.getClass().isArray() || Collection.class.isInstance(val) || Map.class.isInstance(val)) {
                    String[] stringArray = Marshalling.getDBusType(((Method)propEn.getValue()).getGenericReturnType());
                    String dataTypeStr = Arrays.stream(stringArray).collect(Collectors.joining());
                    this.getLogger().trace("Creating embedded Array/Collection/Map of type {}", (Object)dataTypeStr);
                    val = new Variant<Object>(val, dataTypeStr);
                }
                resultMap.put(((PropertyRef)propEn.getKey()).getName(), val);
            }
            catch (Throwable _ex) {
                this.getLogger().debug("Error executing method {} on method call {}", new Object[]{propMeth, _methodCall, _ex});
                this.handleException(_methodCall, new UnknownMethod("Failure in de-serializing message: " + String.valueOf(_ex)));
            }
        }
        if (object instanceof Properties) {
            void var3_5;
            _methodCall.setArgs(new Object[]{_methodCall.getInterface()});
            resultMap.putAll((Map)this.setupAndInvoke(_methodCall, originalMeth, var3_5, true));
        }
        try {
            this.invokedMethodReply(_methodCall, originalMeth, resultMap);
            return;
        }
        catch (DBusExecutionException _ex) {
            this.getLogger().debug("Error invoking method call", (Throwable)_ex);
            this.handleException(_methodCall, _ex);
            return;
        }
        catch (Throwable _ex) {
            void var1_3;
            void var2_4;
            this.getLogger().debug("Failed to invoke method call", _ex);
            this.handleException(_methodCall, new DBusExecutionException(String.format("Error Executing Method %s.%s: %s", _methodCall.getInterface(), var2_4.getName(), _ex.getMessage()), (Throwable)var1_3));
            return;
        }
    }

    static final class PropHandled
    extends Enum<PropHandled> {
        public static final /* enum */ PropHandled HANDLED = new PropHandled();
        public static final /* enum */ PropHandled NOT_HANDLED = new PropHandled();
        public static final /* enum */ PropHandled NO_PROPERTY = new PropHandled();
        private static final /* synthetic */ PropHandled[] $VALUES;

        public static PropHandled[] values() {
            return (PropHandled[])$VALUES.clone();
        }

        private static /* synthetic */ PropHandled[] $values() {
            return new PropHandled[]{HANDLED, NOT_HANDLED, NO_PROPERTY};
        }

        static {
            $VALUES = PropHandled.$values();
        }
    }
}

