/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.base;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.connections.base.AbstractConnectionBase;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.impl.ConnectionConfig;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.utils.LoggingHelper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ConnectionMethodInvocation
extends AbstractConnectionBase {
    /*
     * WARNING - void declaration
     */
    protected ConnectionMethodInvocation(ConnectionConfig _conCfg, TransportConfig _transportConfig, ReceivingServiceConfig _rsCfg) throws DBusException {
        super((ConnectionConfig)var1_1, (TransportConfig)var2_2, (ReceivingServiceConfig)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    protected abstract void handleException(Message var1, DBusExecutionException var2);

    /*
     * WARNING - void declaration
     */
    protected void queueInvokeMethod(MethodCall _methodCall, Method _meth, Object _ob) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getLogger().trace("Adding Runnable for method {}", (Object)_meth);
        boolean noReply = 1 == (_methodCall.getFlags() & 1);
        this.getReceivingService().execMethodCallHandler(() -> this.lambda$queueInvokeMethod$0((MethodCall)var1_1, (Method)var2_2, var3_3, noReply));
    }

    /*
     * WARNING - void declaration
     */
    protected Object setupAndInvoke(MethodCall _methodCall, Method _meth, Object _ob, boolean _noReply) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getLogger().debug("Running method {} for remote call", (Object)_meth);
        try {
            Type[] ts = _meth.getGenericParameterTypes();
            Object[] params2 = _methodCall.getParameters();
            _methodCall.setArgs(Marshalling.deSerializeParameters(params2, ts, (AbstractConnectionBase)this));
            LoggingHelper.logIf(this.getLogger().isTraceEnabled(), () -> {
                try {
                    void var2_3;
                    Object[] params3 = _methodCall.getParameters();
                    this.getLogger().trace("Deserialised {} to types {}", (Object)Arrays.deepToString(params3), (Object)Arrays.deepToString((Object[])var2_3));
                    return;
                }
                catch (Exception _ex) {
                    void var1_2;
                    this.getLogger().trace("Error getting method call parameters", (Throwable)var1_2);
                    return;
                }
            });
        }
        catch (Exception _ex) {
            this.getLogger().debug("", (Throwable)_ex);
            this.handleException(_methodCall, new UnknownMethod("Failure in de-serializing message: " + String.valueOf(_ex)));
            return null;
        }
        return this.invokeMethodAndReply((MethodCall)var1_1, (Method)var2_2, var3_3, _noReply);
    }

    /*
     * WARNING - void declaration
     */
    protected Object invokeMethodAndReply(MethodCall _methodCall, Method _me, Object _ob, boolean _noreply) {
        try {
            Object result = this.invokeMethod(_methodCall, _me, _ob);
            if (_me.getDeclaringClass() == Properties.class && _me.getName().equals("Get") && result == null) {
                MethodCall methodCall = _methodCall;
                this.rejectUnknownProperty(methodCall, methodCall.getParameters());
                return null;
            }
            if (!_noreply) {
                void var2_2;
                this.invokedMethodReply(_methodCall, (Method)var2_2, result);
            }
            return result;
        }
        catch (DBusExecutionException _ex) {
            this.getLogger().debug("Failed to invoke method call", (Throwable)_ex);
            this.handleException(_methodCall, _ex);
        }
        catch (Throwable _ex) {
            void var3_5;
            void var1_1;
            this.getLogger().debug("Error invoking method call {}", (Object)_methodCall, (Object)_ex);
            this.handleException(_methodCall, new DBusExecutionException(String.format("Error Executing Method %s.%s: %s", _methodCall.getInterface(), var1_1.getName(), _ex.getMessage()), (Throwable)var3_5));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void invokedMethodReply(MethodCall _methodCall, Method _me, Object _result) throws DBusException {
        void var1_1;
        if (Void.TYPE.equals(_me.getReturnType())) {
            reply = this.getMessageFactory().createMethodReturn(_methodCall, null, new Object[0]);
        } else {
            void var2_2;
            void var3_3;
            StringBuilder sb = new StringBuilder();
            for (String s : Marshalling.getDBusType(_me.getGenericReturnType())) {
                sb.append(s);
            }
            Object[] nr = Marshalling.convertParameters(new Object[]{var3_3}, new Type[]{var2_2.getGenericReturnType()}, this);
            reply = this.getMessageFactory().createMethodReturn((MethodCall)((Object)reply), sb.toString(), nr);
        }
        this.sendMessage((Message)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected Object invokeMethod(MethodCall _methodCall, Method _me, Object _ob) throws Throwable {
        DBusCallInfo info = new DBusCallInfo(_methodCall);
        this.getInfoMap().put(Thread.currentThread(), info);
        try {
            void var3_4;
            Object object;
            LoggingHelper.logIf(this.getLogger().isTraceEnabled(), () -> {
                try {
                    void var3_4;
                    void var2_3;
                    Object[] params4 = _methodCall.getParameters();
                    this.getLogger().trace("Invoking Method: {} on {} with parameters {}", new Object[]{var2_3, var3_4, Arrays.deepToString(params4)});
                    return;
                }
                catch (DBusException _ex) {
                    void var1_2;
                    this.getLogger().trace("Error getting parameters from method call", (Throwable)var1_2);
                    return;
                }
            });
            Object[] params5 = _methodCall.getParameters();
            object = ((Method)object).invoke((Object)var3_4, params5);
            return object;
        }
        catch (InvocationTargetException _ex) {
            void var1_1;
            this.getLogger().debug("Unable to execute {}: {}", new Object[]{var1_1, _ex.getMessage(), _ex});
            throw _ex.getCause();
        }
        finally {
            this.getInfoMap().remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$queueInvokeMethod$0(MethodCall _methodCall, Method _meth, Object _ob, boolean noReply) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setupAndInvoke((MethodCall)var1_1, (Method)var2_2, var3_3, noReply);
    }
}

