/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.base;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.connections.base.DBusBoundPropertyHandler;
import org.freedesktop.dbus.connections.base.GlobalHandler;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.impl.ConnectionConfig;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.errors.UnknownObject;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Error;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ConnectionMessageHandler
extends DBusBoundPropertyHandler {
    /*
     * WARNING - void declaration
     */
    protected ConnectionMessageHandler(ConnectionConfig _conCfg, TransportConfig _transportConfig, ReceivingServiceConfig _rsCfg) throws DBusException {
        super((ConnectionConfig)var1_1, (TransportConfig)var2_2, (ReceivingServiceConfig)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleException(Message _methodOrSignal, DBusExecutionException _exception) {
        try {
            void var2_3;
            ConnectionMessageHandler connectionMessageHandler = this;
            connectionMessageHandler.sendMessage(connectionMessageHandler.getMessageFactory().createError(_methodOrSignal, (Throwable)var2_3));
            return;
        }
        catch (DBusException _ex) {
            void var1_2;
            this.getLogger().warn("Exception caught while processing previous error.", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleMessage(DBusSignal _signal, boolean _useThreadPool) {
        Runnable command;
        this.getLogger().debug("Handling incoming signal: {}", (Object)_signal);
        ArrayList handlers = new ArrayList();
        ArrayList genericHandlers = new ArrayList();
        for (Map.Entry<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>> entry : this.getHandledSignals().entrySet()) {
            if (!entry.getKey().matches(_signal, false)) continue;
            handlers.addAll(entry.getValue());
        }
        for (Map.Entry<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>> entry : this.getGenericHandledSignals().entrySet()) {
            if (!entry.getKey().matches(_signal, false)) continue;
            genericHandlers.addAll(entry.getValue());
        }
        if (handlers.isEmpty() && genericHandlers.isEmpty()) {
            return;
        }
        ConnectionMessageHandler conn = this;
        for (DBusSigHandler h : handlers) {
            this.getLogger().trace("Adding Runnable for signal {} with handler {}", (Object)_signal, (Object)h);
            command = () -> {
                try {
                    DBusSignal rs = _signal.getClass().equals(DBusSignal.class) ? _signal.createReal(conn) : _signal;
                    if (rs == null) {
                        if (this.getConnectionConfig().getUnknownSignalHandler() != null) {
                            this.getConnectionConfig().getUnknownSignalHandler().accept(_signal);
                        }
                        return;
                    }
                    h.handle(rs);
                    return;
                }
                catch (DBusException _ex) {
                    void var2_3;
                    void var1_1;
                    void var3_4;
                    this.getLogger().warn("Exception while running signal handler '{}' for signal '{}':", new Object[]{var3_4, _signal, _ex});
                    this.handleException(_signal, new DBusExecutionException("Error handling signal " + _signal.getInterface() + "." + var1_1.getName() + ": " + _ex.getMessage(), (Throwable)var2_3));
                    return;
                }
            };
            if (_useThreadPool) {
                this.getReceivingService().execSignalHandler(command);
                continue;
            }
            command.run();
        }
        for (DBusSigHandler h : genericHandlers) {
            void var3_3;
            this.getLogger().trace("Adding Runnable for signal {} with handler {}", (Object)_signal, (Object)h);
            command = () -> {
                void var1_1;
                h.handle(var1_1);
            };
            if (_useThreadPool) {
                this.getReceivingService().execSignalHandler(command);
                continue;
            }
            var3_3.run();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void handleMessage(Error _err) {
        void var1_1;
        this.getLogger().debug("Handling incoming error: {}", (Object)_err);
        MethodCall m = null;
        if (this.getPendingCalls() == null) {
            return;
        }
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            if (this.getPendingCalls().containsKey(_err.getReplySerial())) {
                m = this.getPendingCalls().remove(_err.getReplySerial());
            }
        }
        if (m != null) {
            m.setReply(_err);
            CallbackHandler<? extends Object> cbh = this.getCallbackManager().removeCallback(m);
            this.getLogger().trace("{} = pendingCallbacks.remove({})", cbh, (Object)m);
            if (cbh != null) {
                void var2_2;
                Map<Long, MethodCall> fcbh = map;
                this.getLogger().trace("Adding Error Runnable with callback handler {}", fcbh);
                Runnable command = new Runnable(){
                    final /* synthetic */ Error val$_err;
                    final /* synthetic */ CallbackHandler val$fcbh;
                    final /* synthetic */ ConnectionMessageHandler this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$_err = error;
                        this.val$fcbh = callbackHandler;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public synchronized void run() {
                        try {
                            this.this$0.getLogger().trace("Running Error Callback for {}", (Object)this.val$_err);
                            DBusCallInfo info = new DBusCallInfo(this.val$_err);
                            this.this$0.getInfoMap().put(Thread.currentThread(), info);
                            this.val$fcbh.handleError(this.val$_err.getException());
                            this.this$0.getInfoMap().remove(Thread.currentThread());
                            return;
                        }
                        catch (Exception _ex) {
                            void var1_2;
                            this.this$0.getLogger().debug("Exception while running error callback.", (Throwable)var1_2);
                            return;
                        }
                    }
                };
                this.getReceivingService().execErrorHandler((Runnable)var1_1);
            }
            return;
        }
        this.getPendingErrorQueue().add((Error)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void handleMessage(MethodReturn _mr) {
        void var1_1;
        this.getLogger().debug("Handling incoming method return: {}", (Object)_mr);
        MethodCall m = null;
        if (null == this.getPendingCalls()) {
            return;
        }
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            if (this.getPendingCalls().containsKey(_mr.getReplySerial())) {
                m = this.getPendingCalls().remove(_mr.getReplySerial());
            }
        }
        if (m != null) {
            m.setReply(_mr);
            _mr.setCall(m);
            CallbackHandler<? extends Object> cbh = this.getCallbackManager().getCallback(m);
            DBusAsyncReply<?> asr = this.getCallbackManager().getCallbackReply(m);
            this.getCallbackManager().removeCallback(m);
            if (cbh != null) {
                void var2_2;
                CallbackHandler<? extends Object> fcbh = cbh;
                DBusAsyncReply<?> fasr = asr;
                if (fasr == null) {
                    this.getLogger().debug("Cannot add runnable for method, given method callback was null");
                    return;
                }
                this.getLogger().trace("Adding Runnable for method {} with callback handler {}", fcbh, (Object)fasr.getMethod());
                Runnable r = new Runnable(){
                    final /* synthetic */ MethodReturn val$_mr;
                    final /* synthetic */ DBusAsyncReply val$fasr;
                    final /* synthetic */ CallbackHandler val$fcbh;
                    final /* synthetic */ ConnectionMessageHandler this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$_mr = methodReturn;
                        this.val$fasr = dBusAsyncReply;
                        this.val$fcbh = callbackHandler;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public synchronized void run() {
                        try {
                            this.this$0.getLogger().trace("Running Callback for {}", (Object)this.val$_mr);
                            DBusCallInfo info = new DBusCallInfo(this.val$_mr);
                            this.this$0.getInfoMap().put(Thread.currentThread(), info);
                            Object convertRV = RemoteInvocationHandler.convertRV(this.val$_mr.getParameters(), this.val$fasr.getMethod(), this.val$fasr.getConnection());
                            this.val$fcbh.handle(convertRV);
                            this.this$0.getInfoMap().remove(Thread.currentThread());
                            return;
                        }
                        catch (Exception _ex) {
                            void var1_2;
                            this.this$0.getLogger().debug("Exception while running callback.", (Throwable)var1_2);
                            return;
                        }
                    }
                };
                this.getReceivingService().execMethodReturnHandler((Runnable)var1_1);
            }
            return;
        }
        try {
            ConnectionMessageHandler connectionMessageHandler = this;
            connectionMessageHandler.sendMessage(connectionMessageHandler.getMessageFactory().createError((Message)var1_1, new DBusExecutionException("Spurious reply. No message with the given serial id was awaiting a reply.")));
            return;
        }
        catch (DBusException _exDe) {
            void var3_4;
            this.getLogger().trace("Could not send error message", (Throwable)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleMessage(Message _message) throws DBusException {
        MethodReturn mr;
        MethodCall mc;
        DBusSignal sig;
        if (_message instanceof DBusSignal) {
            sig = (DBusSignal)_message;
            this.handleMessage(sig, true);
            return;
        }
        if (sig instanceof MethodCall) {
            mc = (MethodCall)((Object)sig);
            this.handleMessage(mc);
            return;
        }
        if (mc instanceof MethodReturn) {
            mr = (MethodReturn)((Object)mc);
            this.handleMessage(mr);
            return;
        }
        if (mr instanceof Error) {
            void var1_1;
            Error err = (Error)((Object)mr);
            this.handleMessage((Error)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleMessage(MethodCall _methodCall) throws DBusException {
        void var3_2;
        void var1_1;
        DBusInterface dBusInterface;
        ExportedObject exportObject;
        this.getLogger().debug("Handling incoming method call: {}", (Object)_methodCall);
        Method meth = null;
        Object o = null;
        if (null == _methodCall.getInterface() || _methodCall.getInterface().equals("org.freedesktop.DBus.Peer") || _methodCall.getInterface().equals("org.freedesktop.DBus.Introspectable")) {
            exportObject = this.doWithExportedObjectsAndReturn(DBusException.class, eos -> (ExportedObject)eos.get(null));
            if (exportObject != null && null == exportObject.getObject().get()) {
                this.unExportObject(null);
                exportObject = null;
            }
            if (exportObject != null) {
                meth = exportObject.getMethods().get(new MethodTuple(_methodCall.getName(), _methodCall.getSig()));
            }
            if (meth != null) {
                o = new GlobalHandler(this, _methodCall.getPath());
            }
        }
        if (o == null) {
            void var2_4;
            exportObject = this.doWithExportedObjectsAndReturn(DBusException.class, eos -> {
                MethodCall methodCall;
                return (ExportedObject)eos.get(methodCall.getPath());
            });
            this.getLogger().debug("Found exported object: {}", exportObject == null ? "<no object found>" : exportObject);
            if (exportObject != null && exportObject.getObject().get() == null) {
                this.getLogger().info("Unexporting {} implicitly (object present: {}, reference present: {})", new Object[]{_methodCall.getPath(), exportObject != null, exportObject.getObject().get() == null});
                this.unExportObject(_methodCall.getPath());
                exportObject = null;
            }
            if (exportObject == null) {
                exportObject = this.getFallbackContainer().get(_methodCall.getPath());
                this.getLogger().debug("Found {} in fallback container", exportObject == null ? "no" : exportObject);
            }
            if (exportObject == null) {
                this.getLogger().debug("No object found for method {}", (Object)_methodCall.getPath());
                ConnectionMessageHandler connectionMessageHandler = this;
                connectionMessageHandler.sendMessage(connectionMessageHandler.getMessageFactory().createError(_methodCall, new UnknownObject(_methodCall.getPath() + " is not an object provided by this process.")));
                return;
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Searching for method {}  with signature {}", (Object)_methodCall.getName(), (Object)_methodCall.getSig());
                this.getLogger().trace("List of methods on {}: ", (Object)exportObject);
                for (MethodTuple mt : exportObject.getMethods().keySet()) {
                    this.getLogger().trace("   {} => {}", (Object)mt, (Object)exportObject.getMethods().get(mt));
                }
            }
            Object[] params = _methodCall.getParameters();
            switch (this.handleDBusBoundProperties(exportObject, _methodCall, params)) {
                case HANDLED: {
                    return;
                }
                case NO_PROPERTY: {
                    this.rejectUnknownProperty(_methodCall, params);
                    return;
                }
            }
            if (meth == null && (meth = exportObject.getMethods().get(new MethodTuple(_methodCall.getName(), _methodCall.getSig()))) == null) {
                ConnectionMessageHandler connectionMessageHandler = this;
                connectionMessageHandler.sendMessage(connectionMessageHandler.getMessageFactory().createError(_methodCall, new UnknownMethod(String.format("The method `%s.%s' does not exist on this object.", _methodCall.getInterface(), _methodCall.getName()))));
                return;
            }
            dBusInterface = var2_4.getObject().get();
        }
        if (ExportedObject.isExcluded(meth)) {
            ConnectionMessageHandler connectionMessageHandler = this;
            connectionMessageHandler.sendMessage(connectionMessageHandler.getMessageFactory().createError(_methodCall, new UnknownMethod(String.format("The method `%s.%s' is not exported.", _methodCall.getInterface(), _methodCall.getName()))));
            return;
        }
        this.queueInvokeMethod((MethodCall)var1_1, (Method)var3_2, dBusInterface);
    }
}

