/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import com.sun.security.auth.module.UnixSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.freedesktop.dbus.connections.config.SaslConfig;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.AbstractUnixTransport;
import org.freedesktop.dbus.exceptions.AuthenticationException;
import org.freedesktop.dbus.exceptions.SocketClosedException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.utils.Hexdump;
import org.freedesktop.dbus.utils.LoggingHelper;
import org.freedesktop.dbus.utils.TimeMeasure;
import org.freedesktop.dbus.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASL {
    private static final Random RANDOM = new SecureRandom();
    private static final Collator COL = Collator.getInstance();
    private static final String SYSPROP_USER_HOME;
    private static final String DBUS_TEST_HOME_DIR;
    private static final File DBUS_KEYRINGS_DIR;
    private static final Set<PosixFilePermission> BAD_FILE_PERMISSIONS;
    private String challenge = "";
    private String cookie = "";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean fileDescriptorSupported;
    private final SaslConfig saslConfig;

    /*
     * WARNING - void declaration
     */
    public SASL(SaslConfig _saslConfig) {
        void var1_1;
        this.saslConfig = (SaslConfig)Objects.requireNonNull(var1_1, "Sasl Configuration required");
    }

    /*
     * WARNING - void declaration
     */
    private String findCookie(String _context, String _id) throws IOException {
        String string;
        File keyringDir = DBUS_KEYRINGS_DIR;
        if (!Util.isBlank(DBUS_TEST_HOME_DIR)) {
            keyringDir = new File(DBUS_TEST_HOME_DIR);
        }
        File f = new File(keyringDir, _context);
        long currentTime = System.currentTimeMillis() / 1000L;
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        try {
            String s;
            String lCookie = null;
            while (null != (s = r.readLine())) {
                long timestamp;
                String[] line = s.split(" ");
                if (line.length != 3) continue;
                try {
                    timestamp = Long.parseLong(line[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (!line[0].equals(_id) || timestamp < 0L || currentTime < timestamp - 300L || currentTime >= timestamp + 420L) continue;
                lCookie = string[2];
                break;
            }
            string = lCookie;
        }
        catch (Throwable throwable) {
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        r.close();
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addCookie(String _context, String _id, long _timestamp, String _cookie) throws IOException {
        void var3_3;
        void var2_2;
        Object keyringDir = DBUS_KEYRINGS_DIR;
        if (!Util.isBlank(DBUS_TEST_HOME_DIR)) {
            keyringDir = new File(DBUS_TEST_HOME_DIR);
        }
        File cookiefile = new File((File)keyringDir, _context);
        File lock = new File((File)keyringDir, _context + ".lock");
        File temp = new File((File)keyringDir, _context + ".temp");
        if (!((File)keyringDir).exists()) {
            if (!((File)keyringDir).mkdirs()) throw new AuthenticationException("Unable to create keyring directory " + String.valueOf(keyringDir));
            if (!Util.isWindows()) {
                Util.setFilePermissions(((File)keyringDir).toPath(), null, null, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
            }
        } else if (!Util.isWindows() && Util.collectionContainsAny(keyringDir = Files.getPosixFilePermissions(((File)keyringDir).toPath(), LinkOption.NOFOLLOW_LINKS), BAD_FILE_PERMISSIONS)) {
            if (this.saslConfig.isStrictCookiePermissions()) {
                throw new AuthenticationException("Cannot authenticate using cookies: Permissions of directory " + String.valueOf(lock) + " should be 0700");
            }
            this.logger.warn("DBus keyring directory {} should have permissions 0700", (Object)lock);
        }
        Util.waitFor("Lock file " + String.valueOf(lock), lock::createNewFile, 1000L, 50L);
        ArrayList<Object> lines = new ArrayList<Object>();
        if (cookiefile.exists()) {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(cookiefile)));){
                String s;
                while (null != (s = r.readLine())) {
                    String[] stringArray = s.split(" ");
                    long time = Long.parseLong(stringArray[1]);
                    if (_timestamp - time >= 240L) continue;
                    lines.add(s);
                }
            }
        }
        lines.add((String)var2_2 + " " + (long)var3_3 + " " + _cookie);
        Files.writeString(temp.toPath(), (CharSequence)String.join((CharSequence)System.lineSeparator(), lines), Charset.defaultCharset(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        if (!temp.renameTo(cookiefile)) {
            if (!cookiefile.delete()) {
                this.logger.warn("Unable to delete cookie file {}", (Object)cookiefile);
            } else if (!temp.renameTo(cookiefile)) {
                void var1_1;
                this.logger.warn("Unable to rename cookie file {} to {}", (Object)var1_1, (Object)cookiefile);
            }
        }
        if (lock.delete()) return;
        this.logger.error("Cannot delete lock file {}", (Object)lock);
    }

    private String stupidlyEncode(String _data) {
        return Hexdump.toHex(_data.getBytes(), false);
    }

    private String stupidlyEncode(byte[] _data) {
        return Hexdump.toHex(_data, false);
    }

    /*
     * WARNING - void declaration
     */
    private byte getNibble(char _c) {
        switch (_c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return (byte)(_c - 48);
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return (byte)(_c - 65 + 10);
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                void var1_1;
                return (byte)(var1_1 - 97 + 10);
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private String stupidlyDecode(String _data) {
        void var3_4;
        char[] cs = new char[_data.length()];
        char[] res = new char[cs.length / 2];
        _data.getChars(0, _data.length(), cs, 0);
        int i = 0;
        for (int j = 0; j < res.length; ++j) {
            int n = 0 | this.getNibble(cs[i]) << 4;
            int b = n | this.getNibble(cs[i + 1]);
            res[j] = (char)b;
            i += 2;
        }
        return new String((char[])var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public Command receive(SocketChannel _sock) throws IOException {
        StringBuilder sb = new StringBuilder();
        ByteBuffer buf = ByteBuffer.allocate(1);
        boolean runLoop = true;
        int bytesRead = 0;
        while (runLoop) {
            int read = _sock.read(buf);
            bytesRead += read;
            buf.position(0);
            if (read == -1) {
                throw new SocketClosedException("Stream unexpectedly short (broken pipe)");
            }
            for (int i = buf.position(); i < read; ++i) {
                byte c = buf.get();
                if (c == 0 || c == 13) continue;
                if (c == 10) {
                    runLoop = false;
                    break;
                }
                sb.append((char)c);
            }
            buf.clear();
            if (bytesRead <= 0x100000) continue;
        }
        this.logger.trace("received: {}", (Object)sb);
        try {
            void var2_2;
            return new Command(var2_2.toString());
        }
        catch (Exception _ex) {
            this.logger.error("Cannot create command.", (Throwable)_ex);
            throw new AuthenticationException("Failed to authenticate.", _ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void send(SocketChannel _sock, SaslCommand _command, String ... _data) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        StringBuilder sb = new StringBuilder();
        sb.append(var2_2.name());
        for (void s : var3_3) {
            sb.append(' ');
            sb.append((String)s);
        }
        sb.append('\r');
        sb.append('\n');
        this.logger.trace("sending: {}", (Object)sb);
        var1_1.write(ByteBuffer.wrap(sb.toString().getBytes()));
    }

    /*
     * WARNING - void declaration
     */
    SaslResult doChallenge(int _auth, Command _c) throws IOException {
        switch (_auth) {
            case 2: {
                void var1_2;
                MessageDigest md;
                String[] reply = this.stupidlyDecode(_c.getData()).split(" ");
                LoggingHelper.logIf(this.logger.isTraceEnabled(), () -> {
                    void var1_1;
                    this.logger.trace("Auth data: {}", (Object)Arrays.toString((Object[])var1_1));
                });
                if (3 != reply.length) {
                    this.logger.debug("Reply is not length 3");
                    return SaslResult.ERROR;
                }
                String context = reply[0];
                String id = reply[1];
                String serverchallenge = reply[2];
                try {
                    md = MessageDigest.getInstance("SHA");
                }
                catch (NoSuchAlgorithmException _ex) {
                    this.logger.debug("Could not find SHA algorithm", (Throwable)_ex);
                    return SaslResult.ERROR;
                }
                byte[] buf = new byte[8];
                long l = Optional.of(System.nanoTime()).map(t -> {
                    Long l;
                    return t < 0L ? -t.longValue() : l;
                }).get();
                Message.marshallintBig(l, buf, 0, 8);
                String clientchallenge = this.stupidlyEncode(md.digest(buf));
                md.reset();
                TimeMeasure tm = new TimeMeasure();
                String lCookie = null;
                while (lCookie == null && tm.getElapsed() < 1000L) {
                    lCookie = this.findCookie(context, id);
                }
                if (lCookie == null) {
                    void var3_4;
                    this.logger.debug("Did not find a cookie in context {}  with ID {}", (Object)var3_4, (Object)id);
                    return SaslResult.ERROR;
                }
                Object response = serverchallenge + ":" + clientchallenge + ":" + lCookie;
                byte[] byArray = md.digest(((String)response).getBytes());
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Response: {} hash: {}", response, (Object)Hexdump.format(byArray));
                }
                response = this.stupidlyEncode(byArray);
                _c.setResponse(this.stupidlyEncode(clientchallenge + " " + (String)var1_2));
                return SaslResult.OK;
            }
            case 4: {
                void var2_3;
                Command command = _c;
                command.setResponse(command.getData() == null ? "" : var2_3.getData());
                return SaslResult.OK;
            }
        }
        this.logger.debug("Not DBUS_COOKIE_SHA1 authtype.");
        return SaslResult.ERROR;
    }

    /*
     * WARNING - void declaration
     */
    SaslResult doResponse(int _auth, String _uid, String _kernelUid, Command _c) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException _ex) {
            this.logger.error("SHA hash algorithm not available", (Throwable)_ex);
            return SaslResult.ERROR;
        }
        switch (_ex) {
            case 0: {
                switch (_c.getMechs()) {
                    case 4: {
                        return SaslResult.OK;
                    }
                    case 1: {
                        void var3_7;
                        if (0 == COL.compare(_uid, _c.getData()) && (_kernelUid == null || 0 == COL.compare(_uid, (String)var3_7))) {
                            return SaslResult.OK;
                        }
                        return SaslResult.REJECT;
                    }
                    case 2: {
                        String context = "org_freedesktop_java";
                        long id = System.currentTimeMillis();
                        byte[] buf = new byte[8];
                        Message.marshallintBig(id, buf, 0, 8);
                        this.challenge = this.stupidlyEncode(md.digest(buf));
                        RANDOM.nextBytes(buf);
                        this.cookie = this.stupidlyEncode(md.digest(buf));
                        try {
                            this.addCookie(context, "" + id, id / 1000L, this.cookie);
                        }
                        catch (IOException _ex) {
                            this.logger.error("Error authenticating using cookie", (Throwable)_ex);
                            return SaslResult.ERROR;
                        }
                        this.logger.debug("Sending challenge: {} {} {}", new Object[]{_ex, id, this.challenge});
                        _c.setResponse(this.stupidlyEncode((String)_ex + " " + id + " " + this.challenge));
                        return SaslResult.CONTINUE;
                    }
                }
                return SaslResult.ERROR;
            }
            case 2: {
                void var1_5;
                void var2_6;
                String[] response = this.stupidlyDecode(_c.getData()).split(" ");
                if (response.length < 2) {
                    return SaslResult.ERROR;
                }
                String cchal = response[0];
                String hash = response[1];
                String prehash = this.challenge + ":" + cchal + ":" + this.cookie;
                byte[] buf = md.digest(prehash.getBytes());
                String posthash = this.stupidlyEncode(buf);
                this.logger.debug("Authenticating Hash; data={} remote-hash={} local-hash={}", new Object[]{var2_6, hash, posthash});
                if (0 == COL.compare((String)var1_5, hash)) {
                    return SaslResult.OK;
                }
                return SaslResult.ERROR;
            }
        }
        return SaslResult.ERROR;
    }

    public String[] convertAuthTypes(int _types) {
        switch (_types) {
            case 1: {
                return new String[]{"EXTERNAL"};
            }
            case 2: {
                return new String[]{"DBUS_COOKIE_SHA1"};
            }
            case 4: {
                return new String[]{"ANONYMOUS"};
            }
            case 3: {
                return new String[]{"EXTERNAL", "DBUS_COOKIE_SHA1"};
            }
            case 6: {
                return new String[]{"ANONYMOUS", "DBUS_COOKIE_SHA1"};
            }
            case 5: {
                return new String[]{"ANONYMOUS", "EXTERNAL"};
            }
            case 7: {
                return new String[]{"ANONYMOUS", "EXTERNAL", "DBUS_COOKIE_SHA1"};
            }
        }
        return new String[0];
    }

    public boolean auth(SocketChannel _sock, AbstractTransport _transport) throws IOException {
        String kernelUid = null;
        long uid = this.saslConfig.getSaslUid().orElse(this.getUserId());
        String luid = this.stupidlyEncode("" + uid);
        int failed = 0;
        int current = 0;
        SaslAuthState state = SaslAuthState.INITIAL_STATE;
        block57: while (state != SaslAuthState.FINISHED && state != SaslAuthState.FAILED) {
            this.logger.trace("Mode: {} AUTH state: {}", (Object)this.saslConfig.getMode(), (Object)state);
            switch (this.saslConfig.getMode().ordinal()) {
                case 1: {
                    switch (state.ordinal()) {
                        case 0: {
                            _sock.write(ByteBuffer.wrap(new byte[]{0}));
                            this.send(_sock, SaslCommand.AUTH, new String[0]);
                            state = SaslAuthState.WAIT_DATA;
                            continue block57;
                        }
                        case 1: {
                            Command c = this.receive(_sock);
                            switch (c.getCommand().ordinal()) {
                                case 1: {
                                    switch (this.doChallenge(current, c).ordinal()) {
                                        case 1: {
                                            this.send(_sock, SaslCommand.DATA, c.getResponse());
                                            continue block57;
                                        }
                                        case 0: {
                                            this.send(_sock, SaslCommand.DATA, c.getResponse());
                                            state = SaslAuthState.WAIT_OK;
                                            continue block57;
                                        }
                                    }
                                    this.send(_sock, SaslCommand.ERROR, c.getResponse());
                                    continue block57;
                                }
                                case 2: {
                                    int available = c.getMechs() & ~(failed |= current);
                                    int retVal = this.handleReject(available, luid, _sock);
                                    if (retVal == -1) {
                                        state = SaslAuthState.FAILED;
                                        continue block57;
                                    }
                                    current = retVal;
                                    continue block57;
                                }
                                case 6: {
                                    if (state == SaslAuthState.NEGOTIATE_UNIX_FD) {
                                        state = SaslAuthState.FINISHED;
                                        this.logger.trace("File descriptors NOT supported by server");
                                        this.fileDescriptorSupported = false;
                                        this.send(_sock, SaslCommand.BEGIN, new String[0]);
                                        continue block57;
                                    }
                                    this.send(_sock, SaslCommand.CANCEL, new String[0]);
                                    state = SaslAuthState.WAIT_REJECT;
                                    continue block57;
                                }
                                case 3: {
                                    this.logger.trace("Authenticated");
                                    if (this.saslConfig.isFileDescriptorSupport()) {
                                        state = SaslAuthState.WAIT_DATA;
                                        this.logger.trace("Asking for file descriptor support");
                                        this.send(_sock, SaslCommand.NEGOTIATE_UNIX_FD, new String[0]);
                                        continue block57;
                                    }
                                    state = SaslAuthState.FINISHED;
                                    this.send(_sock, SaslCommand.BEGIN, new String[0]);
                                    continue block57;
                                }
                                case 8: {
                                    if (!this.saslConfig.isFileDescriptorSupport()) continue block57;
                                    state = SaslAuthState.FINISHED;
                                    this.logger.trace("File descriptors supported by server");
                                    this.fileDescriptorSupported = true;
                                    this.send(_sock, SaslCommand.BEGIN, new String[0]);
                                    continue block57;
                                }
                            }
                            this.send(_sock, SaslCommand.ERROR, "Got invalid command");
                            continue block57;
                        }
                        case 2: {
                            Command c = this.receive(_sock);
                            switch (c.getCommand().ordinal()) {
                                case 3: {
                                    this.send(_sock, SaslCommand.BEGIN, new String[0]);
                                    state = SaslAuthState.FINISHED;
                                    continue block57;
                                }
                                case 1: 
                                case 6: {
                                    this.send(_sock, SaslCommand.CANCEL, new String[0]);
                                    state = SaslAuthState.WAIT_REJECT;
                                    continue block57;
                                }
                                case 2: {
                                    int available = c.getMechs() & ~(failed |= current);
                                    state = SaslAuthState.WAIT_DATA;
                                    if (0 != (available & 1)) {
                                        this.send(_sock, SaslCommand.AUTH, "EXTERNAL", luid);
                                        current = 1;
                                        continue block57;
                                    }
                                    if (0 != (available & 2)) {
                                        this.send(_sock, SaslCommand.AUTH, "DBUS_COOKIE_SHA1", luid);
                                        current = 2;
                                        continue block57;
                                    }
                                    if (0 != (available & 4)) {
                                        this.send(_sock, SaslCommand.AUTH, "ANONYMOUS");
                                        current = 4;
                                        continue block57;
                                    }
                                    state = SaslAuthState.FAILED;
                                    continue block57;
                                }
                            }
                            this.send(_sock, SaslCommand.ERROR, "Got invalid command");
                            continue block57;
                        }
                        case 3: {
                            Command c = this.receive(_sock);
                            if (c.getCommand() == SaslCommand.REJECTED) {
                                int available = c.getMechs() & ~(failed |= current);
                                int retVal = this.handleReject(available, luid, _sock);
                                if (retVal == -1) {
                                    state = SaslAuthState.FAILED;
                                    continue block57;
                                }
                                current = retVal;
                                continue block57;
                            }
                            state = SaslAuthState.FAILED;
                            continue block57;
                        }
                    }
                    state = SaslAuthState.FAILED;
                    continue block57;
                }
                case 0: {
                    switch (state.ordinal()) {
                        case 0: {
                            ByteBuffer buf = ByteBuffer.allocate(1);
                            if (_sock instanceof NetworkChannel) {
                                _sock.read(buf);
                                state = SaslAuthState.WAIT_AUTH;
                                continue block57;
                            }
                            try {
                                int kuid22 = -1;
                                if (_transport instanceof AbstractUnixTransport) {
                                    AbstractUnixTransport kuid22 = (AbstractUnixTransport)_transport;
                                    kuid22 = kuid22.getUid(_sock);
                                }
                                if (kuid22 >= 0) {
                                    kernelUid = this.stupidlyEncode("" + kuid22);
                                }
                                state = SaslAuthState.WAIT_AUTH;
                            }
                            catch (SocketException socketException) {
                                state = SaslAuthState.FAILED;
                            }
                            continue block57;
                        }
                        case 4: {
                            Command c = this.receive(_sock);
                            switch (c.getCommand().ordinal()) {
                                case 0: {
                                    switch (this.doResponse(current, luid, kernelUid, c).ordinal()) {
                                        case 1: {
                                            this.send(_sock, SaslCommand.DATA, c.getResponse());
                                            current = c.getMechs();
                                            state = SaslAuthState.WAIT_DATA;
                                            continue block57;
                                        }
                                        case 0: {
                                            this.send(_sock, SaslCommand.OK, this.saslConfig.getGuid());
                                            state = SaslAuthState.WAIT_BEGIN;
                                            current = 0;
                                            continue block57;
                                        }
                                    }
                                    SASL sASL = this;
                                    this.send(_sock, SaslCommand.REJECTED, sASL.convertAuthTypes(sASL.saslConfig.getAuthMode()));
                                    current = 0;
                                    continue block57;
                                }
                                case 6: {
                                    SASL sASL = this;
                                    this.send(_sock, SaslCommand.REJECTED, sASL.convertAuthTypes(sASL.saslConfig.getAuthMode()));
                                    continue block57;
                                }
                                case 4: {
                                    state = SaslAuthState.FAILED;
                                    continue block57;
                                }
                            }
                            this.send(_sock, SaslCommand.ERROR, "Got invalid command");
                            continue block57;
                        }
                        case 1: {
                            Command c = this.receive(_sock);
                            switch (c.getCommand().ordinal()) {
                                case 1: {
                                    switch (this.doResponse(current, luid, kernelUid, c).ordinal()) {
                                        case 1: {
                                            this.send(_sock, SaslCommand.DATA, c.getResponse());
                                            state = SaslAuthState.WAIT_DATA;
                                            continue block57;
                                        }
                                        case 0: {
                                            this.send(_sock, SaslCommand.OK, this.saslConfig.getGuid());
                                            state = SaslAuthState.WAIT_BEGIN;
                                            current = 0;
                                            continue block57;
                                        }
                                    }
                                    SASL sASL = this;
                                    this.send(_sock, SaslCommand.REJECTED, sASL.convertAuthTypes(sASL.saslConfig.getAuthMode()));
                                    current = 0;
                                    continue block57;
                                }
                                case 5: 
                                case 6: {
                                    SASL sASL = this;
                                    this.send(_sock, SaslCommand.REJECTED, sASL.convertAuthTypes(sASL.saslConfig.getAuthMode()));
                                    state = SaslAuthState.WAIT_AUTH;
                                    continue block57;
                                }
                                case 4: {
                                    state = SaslAuthState.FAILED;
                                    continue block57;
                                }
                            }
                            this.send(_sock, SaslCommand.ERROR, "Got invalid command");
                            continue block57;
                        }
                        case 5: {
                            Command command = this.receive(_sock);
                            switch (command.getCommand().ordinal()) {
                                case 5: 
                                case 6: {
                                    SASL sASL = this;
                                    this.send(_sock, SaslCommand.REJECTED, sASL.convertAuthTypes(sASL.saslConfig.getAuthMode()));
                                    state = SaslAuthState.WAIT_AUTH;
                                    continue block57;
                                }
                                case 4: {
                                    state = SaslAuthState.FINISHED;
                                    continue block57;
                                }
                                case 7: {
                                    this.logger.debug("File descriptor negotiation requested");
                                    if (!this.saslConfig.isFileDescriptorSupport()) {
                                        this.send(_sock, SaslCommand.ERROR, new String[0]);
                                        continue block57;
                                    }
                                    this.send(_sock, SaslCommand.AGREE_UNIX_FD, new String[0]);
                                    continue block57;
                                }
                            }
                            this.send(_sock, SaslCommand.ERROR, "Got invalid command");
                            continue block57;
                        }
                    }
                    state = SaslAuthState.FAILED;
                    continue block57;
                }
            }
            return false;
        }
        return state == SaslAuthState.FINISHED;
    }

    public boolean isFileDescriptorSupported() {
        return this.fileDescriptorSupported;
    }

    /*
     * WARNING - void declaration
     */
    private int handleReject(int _available, String _luid, SocketChannel _sock) throws IOException {
        void var1_1;
        int current = -1;
        if (0 != (_available & 1)) {
            this.send(_sock, SaslCommand.AUTH, "EXTERNAL", _luid);
            current = 1;
        } else if (0 != (_available & 2)) {
            void var2_2;
            this.send(_sock, SaslCommand.AUTH, new String[]{"DBUS_COOKIE_SHA1", var2_2});
            current = 2;
        } else if (0 != (var1_1 & 4)) {
            void var3_3;
            this.send((SocketChannel)var3_3, SaslCommand.AUTH, "ANONYMOUS");
            current = 4;
        }
        return current;
    }

    private long getUserId() {
        if (!Util.isWindows()) {
            return new UnixSystem().getUid();
        }
        return 0L;
    }

    static {
        COL.setDecomposition(2);
        COL.setStrength(0);
        SYSPROP_USER_HOME = System.getProperty("user.home");
        DBUS_TEST_HOME_DIR = System.getProperty("DBUS_TEST_HOMEDIR");
        DBUS_KEYRINGS_DIR = new File(SYSPROP_USER_HOME, ".dbus-keyrings");
        BAD_FILE_PERMISSIONS = Set.of(PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE);
    }

    public static class Command {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private SaslCommand command;
        private int mechs;
        private String data;
        private String response;

        public Command() {
        }

        /*
         * WARNING - void declaration
         */
        public Command(String _s) throws IOException {
            String[] ss = _s.split(" ");
            LoggingHelper.logIf(this.logger.isTraceEnabled(), () -> {
                void var1_1;
                this.logger.trace("Creating command from: {}", (Object)Arrays.toString((Object[])var1_1));
            });
            if (0 == COL.compare(ss[0], "OK")) {
                this.command = SaslCommand.OK;
                this.data = ss[1];
            } else if (0 == COL.compare(ss[0], "AUTH")) {
                this.command = SaslCommand.AUTH;
                if (ss.length > 1) {
                    if (0 == COL.compare(ss[1], "EXTERNAL")) {
                        this.mechs = 1;
                    } else if (0 == COL.compare(ss[1], "DBUS_COOKIE_SHA1")) {
                        this.mechs = 2;
                    } else if (0 == COL.compare(ss[1], "ANONYMOUS")) {
                        this.mechs = 4;
                    }
                }
                if (ss.length > 2) {
                    this.data = ss[2];
                }
            } else if (0 == COL.compare(ss[0], "DATA")) {
                this.command = SaslCommand.DATA;
                this.data = ss.length < 2 ? null : ss[1];
            } else if (0 == COL.compare(ss[0], "REJECTED")) {
                this.command = SaslCommand.REJECTED;
                for (int i = 1; i < ss.length; ++i) {
                    if (0 == COL.compare(ss[i], "EXTERNAL")) {
                        this.mechs |= 1;
                        continue;
                    }
                    if (0 == COL.compare(ss[i], "DBUS_COOKIE_SHA1")) {
                        this.mechs |= 2;
                        continue;
                    }
                    if (0 != COL.compare(ss[i], "ANONYMOUS")) continue;
                    this.mechs |= 4;
                }
            } else if (0 == COL.compare(ss[0], "BEGIN")) {
                this.command = SaslCommand.BEGIN;
            } else if (0 == COL.compare(ss[0], "CANCEL")) {
                this.command = SaslCommand.CANCEL;
            } else if (0 == COL.compare(ss[0], "ERROR")) {
                this.command = SaslCommand.ERROR;
                this.data = ss[1];
            } else if (0 == COL.compare(ss[0], "NEGOTIATE_UNIX_FD")) {
                this.command = SaslCommand.NEGOTIATE_UNIX_FD;
            } else if (0 == COL.compare(ss[0], "AGREE_UNIX_FD")) {
                this.command = SaslCommand.AGREE_UNIX_FD;
            } else {
                void var1_1;
                throw new IOException("Invalid Command " + (String)var1_1[0]);
            }
            this.logger.trace("Created command: {}", (Object)this);
        }

        public SaslCommand getCommand() {
            return this.command;
        }

        public int getMechs() {
            return this.mechs;
        }

        public String getData() {
            return this.data;
        }

        public String getResponse() {
            return this.response;
        }

        /*
         * WARNING - void declaration
         */
        public void setResponse(String _s) {
            void var1_1;
            this.response = var1_1;
        }

        public String toString() {
            return "Command(" + String.valueOf((Object)this.command) + ", " + this.mechs + ", " + this.data + ")";
        }
    }

    public static final class SaslCommand
    extends Enum<SaslCommand> {
        public static final /* enum */ SaslCommand AUTH = new SaslCommand();
        public static final /* enum */ SaslCommand DATA = new SaslCommand();
        public static final /* enum */ SaslCommand REJECTED = new SaslCommand();
        public static final /* enum */ SaslCommand OK = new SaslCommand();
        public static final /* enum */ SaslCommand BEGIN = new SaslCommand();
        public static final /* enum */ SaslCommand CANCEL = new SaslCommand();
        public static final /* enum */ SaslCommand ERROR = new SaslCommand();
        public static final /* enum */ SaslCommand NEGOTIATE_UNIX_FD = new SaslCommand();
        public static final /* enum */ SaslCommand AGREE_UNIX_FD = new SaslCommand();
        private static final /* synthetic */ SaslCommand[] $VALUES;

        private static /* synthetic */ SaslCommand[] $values() {
            return new SaslCommand[]{AUTH, DATA, REJECTED, OK, BEGIN, CANCEL, ERROR, NEGOTIATE_UNIX_FD, AGREE_UNIX_FD};
        }

        static {
            $VALUES = SaslCommand.$values();
        }
    }

    public static final class SaslResult
    extends Enum<SaslResult> {
        public static final /* enum */ SaslResult OK = new SaslResult();
        public static final /* enum */ SaslResult CONTINUE = new SaslResult();
        public static final /* enum */ SaslResult ERROR = new SaslResult();
        public static final /* enum */ SaslResult REJECT = new SaslResult();
        private static final /* synthetic */ SaslResult[] $VALUES;

        private static /* synthetic */ SaslResult[] $values() {
            return new SaslResult[]{OK, CONTINUE, ERROR, REJECT};
        }

        static {
            $VALUES = SaslResult.$values();
        }
    }

    static final class SaslAuthState
    extends Enum<SaslAuthState> {
        public static final /* enum */ SaslAuthState INITIAL_STATE = new SaslAuthState();
        public static final /* enum */ SaslAuthState WAIT_DATA = new SaslAuthState();
        public static final /* enum */ SaslAuthState WAIT_OK = new SaslAuthState();
        public static final /* enum */ SaslAuthState WAIT_REJECT = new SaslAuthState();
        public static final /* enum */ SaslAuthState WAIT_AUTH = new SaslAuthState();
        public static final /* enum */ SaslAuthState WAIT_BEGIN = new SaslAuthState();
        public static final /* enum */ SaslAuthState NEGOTIATE_UNIX_FD = new SaslAuthState();
        public static final /* enum */ SaslAuthState FINISHED = new SaslAuthState();
        public static final /* enum */ SaslAuthState FAILED = new SaslAuthState();
        private static final /* synthetic */ SaslAuthState[] $VALUES;

        private static /* synthetic */ SaslAuthState[] $values() {
            return new SaslAuthState[]{INITIAL_STATE, WAIT_DATA, WAIT_OK, WAIT_REJECT, WAIT_AUTH, WAIT_BEGIN, NEGOTIATE_UNIX_FD, FINISHED, FAILED};
        }

        static {
            $VALUES = SaslAuthState.$values();
        }
    }

    public static final class SaslMode
    extends Enum<SaslMode> {
        public static final /* enum */ SaslMode SERVER = new SaslMode();
        public static final /* enum */ SaslMode CLIENT = new SaslMode();
        private static final /* synthetic */ SaslMode[] $VALUES;

        private static /* synthetic */ SaslMode[] $values() {
            return new SaslMode[]{SERVER, CLIENT};
        }

        static {
            $VALUES = SaslMode.$values();
        }
    }
}

