/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.freedesktop.dbus.exceptions.InvalidBusAddressException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusAddress {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusAddress.class);
    private String type;
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();

    /*
     * WARNING - void declaration
     */
    protected BusAddress(BusAddress _obj) {
        if (_obj != null) {
            void var1_1;
            this.parameters.putAll(_obj.parameters);
            this.type = var1_1.type;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static BusAddress of(String _address) {
        void var1_1;
        void var2_2;
        String[] stringArray;
        if (_address == null || _address.isEmpty()) {
            throw new InvalidBusAddressException("Bus address is blank");
        }
        BusAddress busAddress = new BusAddress(null);
        LOGGER.trace("Parsing bus address: {}", (Object)_address);
        String[] ss = _address.split(":", 2);
        if (ss.length < 2) {
            throw new InvalidBusAddressException("Bus address is invalid: " + (String)stringArray);
        }
        String string = busAddress.type = ss[0] != null ? ss[0].toLowerCase(Locale.US) : null;
        if (busAddress.type == null) {
            throw new InvalidBusAddressException("Unsupported transport type: " + ss[0]);
        }
        LOGGER.trace("Transport type: {}", (Object)busAddress.type);
        String[] stringArray2 = var2_2[1].split(",");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            String[] kv = string2.split("=", 2);
            busAddress.addParameter(kv[0], kv[1]);
        }
        LOGGER.trace("Transport options: {}", busAddress.parameters);
        return var1_1;
    }

    public String getType() {
        return this.type;
    }

    public String getBusType() {
        if (this.type == null) {
            return null;
        }
        return this.type.toUpperCase(Locale.US);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isBusType(String _type) {
        void var1_1;
        return this.type != null && this.type.equalsIgnoreCase((String)var1_1);
    }

    public boolean isListeningSocket() {
        return this.parameters.containsKey("listen");
    }

    public final String toString() {
        return this.type + ":" + this.parameters.entrySet().stream().map(e -> {
            Map.Entry entry;
            return (String)e.getKey() + "=" + (String)entry.getValue();
        }).collect(Collectors.joining(","));
    }

    /*
     * WARNING - void declaration
     */
    public BusAddress addParameter(String _parameter, String _value) {
        void var2_2;
        void var1_1;
        this.parameters.put((String)var1_1, (String)var2_2);
        return this;
    }
}

