/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.base.ConnectionMessageHandler;
import org.freedesktop.dbus.connections.base.IncomingMessageThread;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.impl.ConnectionConfig;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.MethodCall;

public abstract class AbstractConnection
extends ConnectionMessageHandler {
    public static final boolean FLOAT_SUPPORT = null != System.getenv("DBUS_JAVA_FLOATS");
    public static final Pattern DOLLAR_PATTERN = Pattern.compile("[$]");

    /*
     * WARNING - void declaration
     */
    protected AbstractConnection(ConnectionConfig _conCfg, TransportConfig _transportConfig, ReceivingServiceConfig _rsCfg) throws DBusException {
        super((ConnectionConfig)var1_1, (TransportConfig)var2_2, (ReceivingServiceConfig)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected IncomingMessageThread createReaderThread(BusAddress _busAddress) {
        void var1_1;
        return new IncomingMessageThread(this, (BusAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected <T extends DBusInterface> List<Class<?>> findMatchingTypes(Class<T> _type, List<String> _ifaces) {
        void var3_3;
        ArrayList<Object> ifcs = new ArrayList<Object>();
        if (_type == null) {
            block2: for (String iface : _ifaces) {
                this.getLogger().debug("Trying interface {}", (Object)iface);
                int j = 0;
                while (j >= 0) {
                    try {
                        Class<?> ifclass = Class.forName(iface);
                        if (ifcs.contains(ifclass)) continue block2;
                        ifcs.add(ifclass);
                        continue block2;
                    }
                    catch (Exception _ex) {
                        this.getLogger().trace("No class found for {}", (Object)iface, (Object)_ex);
                        j = iface.lastIndexOf(46);
                        char[] cs = iface.toCharArray();
                        if (j < 0) continue;
                        cs[j] = 36;
                        iface = String.valueOf(cs);
                    }
                }
            }
        } else {
            void var1_1;
            ifcs.add(var1_1);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected <T extends DBusSignal> void addSigHandlerWithoutMatch(Class<? extends DBusSignal> _signal, DBusSigHandler<T> _handler) throws DBusException {
        DBusMatchRule rule = new DBusMatchRule(_signal);
        Map<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>> map = this.getHandledSignals();
        synchronized (map) {
            Queue<DBusSigHandler<? extends DBusSignal>> v = this.getHandledSignals().get(rule);
            if (v == null) {
                void var1_1;
                v = new ConcurrentLinkedQueue<DBusSigHandler<? extends DBusSignal>>();
                v.add(_handler);
                this.getHandledSignals().put((DBusMatchRule)var1_1, v);
            } else {
                void var2_3;
                v.add((DBusSigHandler<? extends DBusSignal>)var2_3);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void queueCallback(MethodCall _call, Method _method, CallbackHandler<?> _callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getCallbackManager().queueCallback((MethodCall)var1_1, (Method)var2_2, (CallbackHandler<?>)var3_3, this);
    }
}

