/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.annotations.DBusBoundProperty;
import org.freedesktop.dbus.annotations.MethodNoReply;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.base.AbstractConnectionBase;
import org.freedesktop.dbus.errors.NoReply;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.Error;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.propertyref.PropRefRemoteHandler;
import org.freedesktop.dbus.utils.DBusNamingUtil;
import org.freedesktop.dbus.utils.LoggingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInvocationHandler
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInvocationHandler.class);
    AbstractConnection conn;
    RemoteObject remote;

    /*
     * WARNING - void declaration
     */
    public RemoteInvocationHandler(AbstractConnection _conn, RemoteObject _remote) {
        void var1_1;
        void var2_2;
        this.remote = var2_2;
        this.conn = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object invoke(Object _proxy, Method _method, Object[] _args) throws Throwable {
        void var3_6;
        void var2_2;
        switch (_method.getName()) {
            case "isRemote": {
                return Boolean.TRUE;
            }
            case "getObjectPath": {
                return this.remote.getObjectPath();
            }
            case "clone": {
                return null;
            }
            case "equals": {
                try {
                    if (1 == _args.length) {
                        return _args[0] != null && this.remote.equals(((RemoteInvocationHandler)Proxy.getInvocationHandler((Object)_args[0])).remote);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return Boolean.FALSE;
                }
            }
            case "finalize": {
                return null;
            }
            case "getClass": {
                return DBusInterface.class;
            }
            case "hashCode": {
                return this.remote.hashCode();
            }
            case "notify": {
                Object object = this.remote;
                synchronized (object) {
                    this.remote.notify();
                }
                return null;
            }
            case "notifyAll": {
                Object object = this.remote;
                synchronized (object) {
                    this.remote.notifyAll();
                }
                return null;
            }
            case "wait": {
                Object object = this.remote;
                synchronized (object) {
                    Object object2;
                    Object object3;
                    if (_args.length == 0) {
                        this.remote.wait();
                    } else if (_args.length == 1 && (object3 = _args[0]) instanceof Long) {
                        l = (Long)object3;
                        this.remote.wait(l);
                    } else if (_args.length == 2 && (object2 = _args[0]) instanceof Long) {
                        l = (Long)object2;
                        object2 = _args[1];
                        if (object2 instanceof Integer) {
                            Integer i = (Integer)object2;
                            this.remote.wait(var2_2.longValue(), i);
                        }
                    }
                    if (_args.length <= 2) {
                        return null;
                    }
                }
            }
            case "toString": {
                return this.remote.toString();
            }
        }
        if (var2_2.isAnnotationPresent(DBusBoundProperty.class)) {
            return PropRefRemoteHandler.handleDBusBoundProperty(this.conn, this.remote, (Method)var2_2, _args);
        }
        return RemoteInvocationHandler.executeRemoteMethod(this.remote, (Method)var2_2, this.conn, 0, null, (Object[])var3_6);
    }

    /*
     * WARNING - void declaration
     */
    public static Object convertRV(Object[] _rp, Method _m, AbstractConnection _conn) throws DBusException {
        void var2_2;
        void var1_1;
        return RemoteInvocationHandler.convertRV(_rp, new Type[]{_m.getGenericReturnType()}, (Method)var1_1, (AbstractConnection)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object convertRV(Object[] _rp, Type[] _types, Method _m, AbstractConnection _conn) throws DBusException {
        Class<?> c = _m.getReturnType();
        Object[] rp = _rp;
        if (_rp == null) {
            if (c == null || Void.TYPE.equals(c)) {
                return null;
            }
            throw new DBusException("Wrong return type (got void, expected a value)");
        }
        try {
            void var3_5;
            void var1_3;
            void var2_4;
            LoggingHelper.logIf(LOGGER.isTraceEnabled(), () -> RemoteInvocationHandler.lambda$convertRV$0(_rp, (Method)var2_4));
            rp = Marshalling.deSerializeParameters(rp, (Type[])var1_3, (AbstractConnectionBase)var3_5);
        }
        catch (Exception _ex) {
            LOGGER.debug("Wrong return type.", (Throwable)_ex);
            throw new DBusException(String.format("Wrong return type (failed to de-serialize correct types: %s )", _ex.getMessage()), _ex);
        }
        switch (rp.length) {
            case 0: {
                if (c == null || Void.TYPE.equals(c)) {
                    return null;
                }
                throw new DBusException("Wrong return type (got void, expected a value)");
            }
            case 1: {
                return rp[0];
            }
        }
        if (!Tuple.class.isAssignableFrom(c)) {
            throw new DBusException("Wrong return type (not expecting Tuple)");
        }
        Constructor<?> cons = c.getConstructors()[0];
        try {
            return cons.newInstance(rp);
        }
        catch (Exception _ex) {
            void var0_2;
            LOGGER.debug("Error creating tuple instance using reflection", (Throwable)_ex);
            throw new DBusException(var0_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object executeRemoteMethod(RemoteObject _ro, Method _m, AbstractConnection _conn, int _syncmethod, CallbackHandler<?> _callback, Object ... _args) throws DBusException {
        void var3_3;
        void var2_2;
        void var1_1;
        return RemoteInvocationHandler.executeRemoteMethod(_ro, _m, new Type[]{var1_1.getGenericReturnType()}, (AbstractConnection)var2_2, (int)var3_3, _callback, _args);
    }

    /*
     * WARNING - void declaration
     */
    public static Object executeRemoteMethod(RemoteObject _ro, Method _m, String[] _customSignatures, Type[] _types, AbstractConnection _conn, int _syncmethod, CallbackHandler<?> _callback, Object ... _args) throws DBusException {
        Object object;
        Object iface;
        Object call;
        Object _ex2;
        Type[] ts = _m.getGenericParameterTypes();
        String sig = null;
        Object[] args = _args;
        if (ts.length > 0) {
            try {
                sig = Marshalling.getDBusType(ts);
                args = Marshalling.convertParameters(args, ts, _customSignatures, _conn);
            }
            catch (DBusException _ex2) {
                throw new DBusExecutionException("Failed to construct D-Bus type: " + _ex2.getMessage(), _ex2);
            }
        }
        byte flags = 0;
        if (!((RemoteObject)_ex2).isAutostart()) {
            flags = 2;
        }
        if (_syncmethod == 1) {
            flags = (byte)(flags | 0x40);
        }
        if (_m.isAnnotationPresent(MethodNoReply.class)) {
            flags = (byte)(flags | 1);
        }
        try {
            String name = DBusNamingUtil.getMethodName(_m);
            if (null == ((RemoteObject)_ex2).getInterface()) {
                call = _conn.getMessageFactory().createMethodCall(null, ((RemoteObject)_ex2).getBusName(), ((RemoteObject)_ex2).getObjectPath(), null, name, flags, sig, args);
            } else {
                void var2_4;
                iface = DBusNamingUtil.getInterfaceName(((RemoteObject)call).getInterface());
                call = _conn.getMessageFactory().createMethodCall(null, ((RemoteObject)call).getBusName(), ((RemoteObject)call).getObjectPath(), (String)iface, name, (byte)var2_4, sig, args);
            }
        }
        catch (DBusException _ex3) {
            LOGGER.debug("Failed to construct outgoing method call.", (Throwable)_ex3);
            throw new DBusExecutionException("Failed to construct outgoing method call: " + _ex3.getMessage(), _ex3);
        }
        if (!_conn.isConnected()) {
            throw new NotConnected("Not Connected");
        }
        switch (_syncmethod) {
            case 1: {
                _conn.sendMessage((Message)call);
                return new DBusAsyncReply((MethodCall)call, _m, _conn);
            }
            case 2: {
                _conn.queueCallback((MethodCall)call, _m, _callback);
                _conn.sendMessage((Message)call);
                return null;
            }
            case 0: {
                _conn.sendMessage((Message)call);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Method call type: " + _syncmethod);
            }
        }
        if (_m.isAnnotationPresent(MethodNoReply.class)) {
            return null;
        }
        Message reply = ((MethodCall)object).getReply();
        if (reply == null) {
            throw new NoReply("No reply within specified time");
        }
        if (reply instanceof Error) {
            iface = (Error)reply;
            ((Error)iface).throwException();
        }
        try {
            void var1_2;
            void var3_5;
            return RemoteInvocationHandler.convertRV(reply.getParameters(), (Type[])var3_5, (Method)var1_2, _conn);
        }
        catch (DBusException _ex4) {
            LOGGER.debug("", (Throwable)_ex4);
            throw new DBusExecutionException(_ex4.getMessage(), _ex4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object executeRemoteMethod(RemoteObject _ro, Method _m, Type[] _types, AbstractConnection _conn, int _syncmethod, CallbackHandler<?> _callback, Object ... _args) throws DBusException {
        void var3_3;
        void var2_2;
        void var1_1;
        return RemoteInvocationHandler.executeRemoteMethod(_ro, (Method)var1_1, null, (Type[])var2_2, (AbstractConnection)var3_3, _syncmethod, _callback, _args);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$convertRV$0(Object[] _rp, Method _m) {
        void var1_1;
        Object[] objectArray;
        LOGGER.trace("Converting return parameters from {} to type {}", (Object)Arrays.deepToString(objectArray), (Object)var1_1.getGenericReturnType());
    }
}

