/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.base.AbstractConnectionBase;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSerializable;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.DBusStructType;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.LoggingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Marshalling {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private static final Logger LOGGER = LoggerFactory.getLogger(Marshalling.class);
    private static final Map<Type, String[]> TYPE_CACHE = new ConcurrentHashMap<Type, String[]>();
    private static final Map<Class<?>, Byte> CLASS_TO_ARGUMENTTYPE = new LinkedHashMap();

    private Marshalling() {
    }

    /*
     * WARNING - void declaration
     */
    public static String getDBusType(Type[] _javaType) throws DBusException {
        void var1_1;
        Type[] typeArray;
        StringBuilder sb = new StringBuilder();
        for (Type type : typeArray) {
            for (String s : Marshalling.getDBusType(type)) {
                sb.append(s);
            }
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getDBusType(Type _javaType) throws DBusException {
        void var1_1;
        Type type;
        String[] cached = TYPE_CACHE.get(_javaType);
        if (cached != null) {
            return cached;
        }
        cached = Marshalling.getDBusType(_javaType, false);
        TYPE_CACHE.put(type, cached);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getDBusType(Type _dataType, boolean _basic) throws DBusException {
        void var1_1;
        Type type;
        return Marshalling.recursiveGetDBusType(new StringBuffer[10], type, (boolean)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] recursiveGetDBusType(StringBuffer[] _out, Type _dataType, boolean _basic, int _level) throws DBusException {
        void var3_11;
        StringBuffer[] stringBufferArray;
        void var1_1;
        block38: {
            Type[] ts;
            block50: {
                int dataTypeClazz2;
                Field[] j2;
                block51: {
                    Type t3;
                    int _ex2;
                    Type[] t2;
                    block46: {
                        Type[] newtypes;
                        block42: {
                            Class dataTypeClazz2;
                            block49: {
                                block48: {
                                    String[] s;
                                    block43: {
                                        block47: {
                                            block45: {
                                                ParameterizedType p;
                                                block44: {
                                                    block41: {
                                                        ParameterizedType pt;
                                                        block40: {
                                                            block39: {
                                                                while (true) {
                                                                    WildcardType wildcardType;
                                                                    if (_out.length <= _level) {
                                                                        StringBuffer[] newout = new StringBuffer[_level + 10];
                                                                        System.arraycopy(_out, 0, newout, 0, _out.length);
                                                                        _out = newout;
                                                                    }
                                                                    if (null == _out[_level]) {
                                                                        _out[_level] = new StringBuffer();
                                                                    } else {
                                                                        _out[_level].delete(0, _out[_level].length());
                                                                    }
                                                                    if (_basic && !(_dataType instanceof Class)) {
                                                                        throw new DBusException(String.valueOf(_dataType) + " is not a basic type");
                                                                    }
                                                                    if (!(_dataType instanceof WildcardType) || (wildcardType = (WildcardType)_dataType).getUpperBounds().length <= 0) break;
                                                                    _dataType = wildcardType.getUpperBounds()[0];
                                                                }
                                                                if (!(_dataType instanceof TypeVariable)) break block39;
                                                                _out[_level].append('v');
                                                                break block38;
                                                            }
                                                            if (!(_dataType instanceof GenericArrayType)) break block40;
                                                            GenericArrayType gat = (GenericArrayType)_dataType;
                                                            _out[_level].append('a');
                                                            s = Marshalling.recursiveGetDBusType(_out, gat.getGenericComponentType(), false, _level + 1);
                                                            if (s.length != 1) {
                                                                throw new DBusException("Multi-valued array types not permitted");
                                                            }
                                                            _out[_level].append(s[0]);
                                                            break block38;
                                                        }
                                                        if ((!(_dataType instanceof Class) || !DBusSerializable.class.isAssignableFrom((Class)_dataType)) && (!(_dataType instanceof ParameterizedType) || !DBusSerializable.class.isAssignableFrom((Class)(pt = (ParameterizedType)_dataType).getRawType()))) break block41;
                                                        newtypes = null;
                                                        if (_dataType instanceof Class) {
                                                            Class clazz = (Class)_dataType;
                                                            for (Method m : clazz.getDeclaredMethods()) {
                                                                if (!m.getName().equals("deserialize")) continue;
                                                                newtypes = m.getGenericParameterTypes();
                                                            }
                                                        } else {
                                                            for (Method m : ((Class)((ParameterizedType)_dataType).getRawType()).getDeclaredMethods()) {
                                                                if (!m.getName().equals("deserialize")) continue;
                                                                newtypes = m.getGenericParameterTypes();
                                                            }
                                                        }
                                                        if (newtypes == null) {
                                                            throw new DBusException("Serializable classes must implement a deserialize method");
                                                        }
                                                        break block42;
                                                    }
                                                    if (!(_dataType instanceof ParameterizedType)) break block43;
                                                    p = (ParameterizedType)_dataType;
                                                    if (!p.getRawType().equals(Map.class)) break block44;
                                                    _out[_level].append("a{");
                                                    t2 = p.getActualTypeArguments();
                                                    try {
                                                        String[] s2 = Marshalling.recursiveGetDBusType(_out, t2[0], true, _level + 1);
                                                        if (s2.length != 1) {
                                                            throw new DBusException("Multi-valued array types not permitted");
                                                        }
                                                        _out[_level].append(s2[0]);
                                                        s2 = Marshalling.recursiveGetDBusType(_out, t2[1], false, _level + 1);
                                                        if (s2.length != 1) {
                                                            throw new DBusException("Multi-valued array types not permitted");
                                                        }
                                                        _out[_level].append(s2[0]);
                                                    }
                                                    catch (ArrayIndexOutOfBoundsException _ex2) {
                                                        LOGGER.debug("", (Throwable)_ex2);
                                                        throw new DBusException("Map must have 2 parameters");
                                                    }
                                                    _out[_level].append("}");
                                                    break block38;
                                                }
                                                if (!List.class.isAssignableFrom((Class)p.getRawType())) break block45;
                                                t2 = p.getActualTypeArguments();
                                                _ex2 = t2.length;
                                                break block46;
                                            }
                                            if (!t3.getRawType().equals(Variant.class)) break block47;
                                            _out[_level].append('v');
                                            break block38;
                                        }
                                        if (DBusInterface.class.isAssignableFrom((Class)t3.getRawType())) {
                                            _out[_level].append('o');
                                            break block38;
                                        } else if (Struct.class.isAssignableFrom((Class)t3.getRawType())) {
                                            _out[_level].append('(');
                                            break block38;
                                        } else {
                                            if (!Tuple.class.isAssignableFrom((Class)t3.getRawType())) {
                                                throw new DBusException("Exporting non-exportable parameterized type " + String.valueOf(_dataType));
                                            }
                                            ts = t3.getActualTypeArguments();
                                            ArrayList vs = new ArrayList();
                                            Type[] j2 = ts;
                                            int t3 = ts.length;
                                            int s3 = 0;
                                            while (true) {
                                                if (s3 >= t3) {
                                                    return vs.toArray(EMPTY_STRING_ARRAY);
                                                }
                                                Type t4 = j2[s3];
                                                Collections.addAll(vs, Marshalling.recursiveGetDBusType(_out, t4, false, _level + 1));
                                                ++s3;
                                            }
                                        }
                                    }
                                    if (!(_dataType instanceof Class)) break block38;
                                    dataTypeClazz2 = (Class)_dataType;
                                    if (!dataTypeClazz2.isArray()) break block48;
                                    if (Type.class.equals(((Class)_dataType).getComponentType())) {
                                        _out[_level].append('g');
                                        break block38;
                                    } else {
                                        _out[_level].append('a');
                                        s = Marshalling.recursiveGetDBusType(_out, ((Class)_dataType).getComponentType(), false, _level + 1);
                                        if (s.length != 1) {
                                            throw new DBusException("Multi-valued array types not permitted");
                                        }
                                        _out[_level].append(s[0]);
                                    }
                                    break block38;
                                }
                                if (!Struct.class.isAssignableFrom((Class)_dataType)) break block49;
                                _out[_level].append('(');
                                ts = Container.getTypeCache(_dataType);
                                if (ts != null) break block50;
                                Field[] fs = ((Class)_dataType).getDeclaredFields();
                                ts = new Type[fs.length];
                                j2 = fs;
                                dataTypeClazz2 = fs.length;
                                break block51;
                            }
                            if (Enum.class.isAssignableFrom(dataTypeClazz2)) {
                                _out[_level].append('s');
                                break block38;
                            } else {
                                boolean found = false;
                                for (Map.Entry<Class<?>, Byte> entry : CLASS_TO_ARGUMENTTYPE.entrySet()) {
                                    if (!entry.getKey().isAssignableFrom(dataTypeClazz2)) continue;
                                    _out[_level].append((char)entry.getValue().byteValue());
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    throw new DBusException("Exporting non-exportable type: " + String.valueOf(_dataType));
                                }
                            }
                            break block38;
                        }
                        String[] sigs = new String[newtypes.length];
                        int j2 = 0;
                        while (true) {
                            if (j2 >= sigs.length) {
                                return sigs;
                            }
                            String[] ss = Marshalling.recursiveGetDBusType(_out, newtypes[j2], false, _level + 1);
                            if (1 != ss.length) {
                                throw new DBusException("Serializable classes must serialize to native DBus types");
                            }
                            sigs[j2] = ss[0];
                            ++j2;
                        }
                    }
                    for (int j2 = 0; j2 < _ex2; ++j2) {
                        t3 = t2[j2];
                        if (Type.class.equals((Object)t3)) {
                            _out[_level].append('g');
                            continue;
                        }
                        String[] s3 = Marshalling.recursiveGetDBusType(_out, t3, false, _level + 1);
                        if (s3.length != 1) {
                            throw new DBusException("Multi-valued array types not permitted");
                        }
                        _out[_level].append('a');
                        _out[_level].append(s3[0]);
                    }
                    break block38;
                }
                for (int s3 = 0; s3 < dataTypeClazz2; ++s3) {
                    Field f = j2[s3];
                    Position p = f.getAnnotation(Position.class);
                    if (p == null) continue;
                    ts[p.value()] = f.getGenericType();
                }
                Container.putTypeCache(_dataType, ts);
            }
            Type[] typeArray = ts;
            int j2 = ts.length;
            for (int dataTypeClazz2 = 0; dataTypeClazz2 < j2; ++dataTypeClazz2) {
                Type t = typeArray[dataTypeClazz2];
                if (t == null) continue;
                for (String s : Marshalling.recursiveGetDBusType(_out, t, false, _level + 1)) {
                    _out[_level].append(s);
                }
            }
            _out[_level].append(")");
        }
        LOGGER.trace("Converted Java type: {} to D-Bus Type: {}", (Object)var1_1, (Object)_out[_level]);
        return new String[]{stringBufferArray[var3_11].toString()};
    }

    /*
     * WARNING - void declaration
     */
    public static int getJavaType(String _dbusType, List<Type> _resultValue, int _limit) throws DBusException {
        if (_dbusType == null || _dbusType.isEmpty() || _limit == 0) {
            return 0;
        }
        try {
            int idx;
            block22: for (idx = 0; idx < _dbusType.length() && (-1 == _limit || _limit > _resultValue.size()); ++idx) {
                switch (_dbusType.charAt(idx)) {
                    case '(': {
                        int structIdx = idx + 1;
                        int structLen = 1;
                        while (structLen > 0) {
                            if (')' == _dbusType.charAt(structIdx)) {
                                --structLen;
                            } else if ('(' == _dbusType.charAt(structIdx)) {
                                ++structLen;
                            }
                            ++structIdx;
                        }
                        ArrayList<Type> contained = new ArrayList();
                        Marshalling.getJavaType(_dbusType.substring(idx + 1, structIdx - 1), contained, -1);
                        _resultValue.add(new DBusStructType(contained.toArray(EMPTY_TYPE_ARRAY)));
                        idx = structIdx - 1;
                        continue block22;
                    }
                    case 'a': {
                        int javaType;
                        ArrayList<Type> contained;
                        if ('{' == _dbusType.charAt(idx + 1)) {
                            contained = new ArrayList();
                            javaType = Marshalling.getJavaType(_dbusType.substring(idx + 2), contained, 2);
                            _resultValue.add(new DBusMapType((Type)contained.get(0), (Type)contained.get(1)));
                            idx += javaType + 2;
                            continue block22;
                        }
                        contained = new ArrayList();
                        javaType = Marshalling.getJavaType(_dbusType.substring(idx + 1), contained, 1);
                        _resultValue.add(new DBusListType((Type)contained.get(0)));
                        idx += javaType;
                        continue block22;
                    }
                    case 'v': {
                        _resultValue.add((Type)((Object)Variant.class));
                        continue block22;
                    }
                    case 'b': {
                        _resultValue.add((Type)((Object)Boolean.class));
                        continue block22;
                    }
                    case 'n': {
                        _resultValue.add((Type)((Object)Short.class));
                        continue block22;
                    }
                    case 'y': {
                        _resultValue.add((Type)((Object)Byte.class));
                        continue block22;
                    }
                    case 'o': {
                        _resultValue.add((Type)((Object)DBusPath.class));
                        continue block22;
                    }
                    case 'q': {
                        _resultValue.add((Type)((Object)UInt16.class));
                        continue block22;
                    }
                    case 'i': {
                        _resultValue.add((Type)((Object)Integer.class));
                        continue block22;
                    }
                    case 'u': {
                        _resultValue.add((Type)((Object)UInt32.class));
                        continue block22;
                    }
                    case 'x': {
                        _resultValue.add((Type)((Object)Long.class));
                        continue block22;
                    }
                    case 't': {
                        _resultValue.add((Type)((Object)UInt64.class));
                        continue block22;
                    }
                    case 'd': {
                        _resultValue.add((Type)((Object)Double.class));
                        continue block22;
                    }
                    case 'f': {
                        _resultValue.add((Type)((Object)Float.class));
                        continue block22;
                    }
                    case 's': {
                        _resultValue.add((Type)((Object)CharSequence.class));
                        continue block22;
                    }
                    case 'h': {
                        _resultValue.add((Type)((Object)FileDescriptor.class));
                        continue block22;
                    }
                    case 'g': {
                        _resultValue.add((Type)((Object)Type[].class));
                        continue block22;
                    }
                    case '{': {
                        ArrayList<Type> contained = new ArrayList<Type>();
                        int javaType = Marshalling.getJavaType(_dbusType.substring(idx + 1), contained, 2);
                        _resultValue.add(new DBusMapType((Type)contained.get(0), (Type)contained.get(1)));
                        idx += javaType + 1;
                        continue block22;
                    }
                    default: {
                        throw new DBusException(String.format("Failed to parse DBus type signature: %s (%s).", _dbusType, Character.valueOf(_dbusType.charAt(idx))));
                    }
                }
            }
            return idx;
        }
        catch (IndexOutOfBoundsException _ex) {
            String string;
            void var3_4;
            LOGGER.debug("Failed to parse DBus type signature.", (Throwable)var3_4);
            throw new DBusException("Failed to parse DBus type signature: " + string);
        }
    }

    public static Object[] convertParameters(Object[] _parameters, Type[] _types, String[] _customSignatures, AbstractConnectionBase _conn) throws DBusException {
        Object[] objectArray;
        Object[] parameters;
        if (_parameters == null) {
            return null;
        }
        int lastCustomSig = 0;
        for (int i = 0; i < parameters.length; ++i) {
            Type[] types;
            if (null == parameters[i]) continue;
            LOGGER.trace("Converting {} from '{}' to {}", new Object[]{i, parameters[i], types[i]});
            Object object = parameters[i];
            if (object instanceof DBusSerializable) {
                DBusSerializable ds = (DBusSerializable)object;
                for (Method m : parameters[i].getClass().getDeclaredMethods()) {
                    if (!m.getName().equals("deserialize")) continue;
                    Class<?>[] newtypes = m.getParameterTypes();
                    Type[] expand = new Type[types.length + newtypes.length - 1];
                    System.arraycopy(types, 0, expand, 0, i);
                    System.arraycopy(newtypes, 0, expand, i, newtypes.length);
                    System.arraycopy(types, i + 1, expand, i + newtypes.length, types.length - i - 1);
                    types = expand;
                    Object[] newparams = ds.serialize();
                    Object[] exparams = new Object[parameters.length + newparams.length - 1];
                    System.arraycopy(parameters, 0, exparams, 0, i);
                    System.arraycopy(newparams, 0, exparams, i, newparams.length);
                    System.arraycopy(parameters, i + 1, exparams, i + newparams.length, parameters.length - i - 1);
                    parameters = exparams;
                }
                --i;
                continue;
            }
            Object object2 = parameters[i];
            if (object2 instanceof Tuple) {
                Tuple tup = (Tuple)object2;
                Type[] typeArray = ((ParameterizedType)types[i]).getActualTypeArguments();
                Type[] expand = new Type[types.length + typeArray.length - 1];
                System.arraycopy(types, 0, expand, 0, i);
                System.arraycopy(typeArray, 0, expand, i, typeArray.length);
                System.arraycopy(types, i + 1, expand, i + typeArray.length, types.length - i - 1);
                types = expand;
                Object[] newparams = tup.getParameters();
                Object[] exparams = new Object[parameters.length + newparams.length - 1];
                System.arraycopy(parameters, 0, exparams, 0, i);
                System.arraycopy(newparams, 0, exparams, i, newparams.length);
                System.arraycopy(parameters, i + 1, exparams, i + newparams.length, parameters.length - i - 1);
                parameters = exparams;
                LoggingHelper.logIf(LOGGER.isTraceEnabled(), () -> {
                    void var1_1;
                    Object[] objectArray;
                    LOGGER.trace("New params: {}, new types: {}", (Object)Arrays.deepToString(objectArray), (Object)Arrays.deepToString((Object[])var1_1));
                });
                --i;
                continue;
            }
            if (types[i] instanceof TypeVariable && !(parameters[i] instanceof Variant)) {
                if (_customSignatures != null && _customSignatures.length > 0 && _customSignatures.length > lastCustomSig) {
                    parameters[i] = new Variant<Object>(parameters[i], _customSignatures[lastCustomSig]);
                    ++lastCustomSig;
                    continue;
                }
                parameters[i] = new Variant<Object>(parameters[i]);
                continue;
            }
            Object object3 = parameters[i];
            if (!(object3 instanceof DBusInterface)) continue;
            DBusInterface di = (DBusInterface)object3;
            parameters[i] = _conn.getExportedObject(di);
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] convertParameters(Object[] _parameters, Type[] _types, AbstractConnectionBase _conn) throws DBusException {
        void var2_2;
        void var1_1;
        return Marshalling.convertParameters(_parameters, (Type[])var1_1, null, (AbstractConnectionBase)var2_2);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    static Object deSerializeParameter(Object _parameter, Type _type, AbstractConnectionBase _conn) throws Exception {
        block33: {
            block35: {
                block36: {
                    block34: {
                        Marshalling.LOGGER.trace("Deserializing from {} to {}", _parameter.getClass(), (Object)_type);
                        if (_type instanceof TypeVariable && parameter /* !! */  instanceof Variant) {
                            var3_3 = (Variant)parameter /* !! */ ;
                            parameter /* !! */  = var3_3.getValue();
                            Marshalling.LOGGER.trace("Type is variant, unwrapping to {}", (Object)parameter /* !! */ );
                        }
                        if (_type instanceof Class && ((Class)_type).isArray() && ((Class)_type).getComponentType().equals(Type.class) && parameter /* !! */  instanceof String) {
                            rv = new ArrayList<Type>();
                            Marshalling.getJavaType((String)parameter /* !! */ , rv, -1);
                            parameter /* !! */  = rv.toArray(Marshalling.EMPTY_TYPE_ARRAY);
                        }
                        if (parameter /* !! */  instanceof ObjectPath) {
                            op = (ObjectPath)parameter /* !! */ ;
                            Marshalling.LOGGER.trace("Parameter is ObjectPath");
                            parameter /* !! */  = _type instanceof Class != false && DBusInterface.class.isAssignableFrom((Class)_type) != false ? _conn.getExportedObject(op.getSource(), op.getPath(), (Class)_type) : new DBusPath(op.getPath());
                        }
                        if (parameter /* !! */  instanceof DBusPath) {
                            op = (DBusPath)parameter /* !! */ ;
                            Marshalling.LOGGER.trace("Parameter is DBusPath");
                            parameter /* !! */  = _type instanceof Class != false && DBusInterface.class.isAssignableFrom((Class)_type) != false ? _conn.getExportedObject(op.getSource(), op.getPath(), (Class)_type) : new DBusPath(op.getPath());
                        }
                        if (parameter /* !! */  instanceof String) {
                            str = (String)parameter /* !! */ ;
                            if (_type instanceof Class && Enum.class.isAssignableFrom((Class)_type)) {
                                Marshalling.LOGGER.trace("Type seems to be an enum");
                                parameter /* !! */  = Enum.valueOf((Class)_type, str);
                            }
                        }
                        if (parameter /* !! */  instanceof Object[]) {
                            objArr = parameter /* !! */ ;
                            if (_type instanceof Class && Struct.class.isAssignableFrom((Class)_type)) {
                                Marshalling.LOGGER.trace("Creating Struct {} from {}", (Object)_type, (Object)parameter /* !! */ );
                                ts /* !! */  = Container.getTypeCache(_type);
                                if (ts /* !! */  == null) {
                                    fs = ((Class)_type).getDeclaredFields();
                                    ts /* !! */  = new Type[fs.length];
                                    var6_6 = fs;
                                    var7_12 = fs.length;
                                    for (var8_17 = 0; var8_17 < var7_12; ++var8_17) {
                                        f = var6_6[var8_17];
                                        p /* !! */  = f.getAnnotation(Position.class);
                                        if (p /* !! */  == null) continue;
                                        ts /* !! */ [var0 /* !! */ .value()] = f.getGenericType();
                                    }
                                    Container.putTypeCache(_type, (Type[])ts /* !! */ );
                                }
                                var0 /* !! */  = Marshalling.deSerializeParameters(objArr, (Type[])ts /* !! */ , _conn);
                                for (AccessibleObject con : ((Class)_type).getDeclaredConstructors()) {
                                    try {
                                        var0 /* !! */  = con.newInstance(objArr);
                                        break;
                                    }
                                    catch (IllegalArgumentException _exIa) {
                                        Marshalling.LOGGER.trace("Could not create new instance", (Throwable)_exIa);
                                    }
                                }
                            }
                        }
                        if (var0 /* !! */  instanceof Object[]) {
                            oa = var0 /* !! */ ;
                            Marshalling.LOGGER.trace("Parameter is object array");
                            ts /* !! */  = new Type[oa.length];
                            Arrays.fill(ts /* !! */ , var0 /* !! */ .getClass().getComponentType());
                            var0 /* !! */  = Marshalling.deSerializeParameters(oa, (Type[])ts /* !! */ , _conn);
                        }
                        if (!(var0 /* !! */  instanceof List)) break block33;
                        Marshalling.LOGGER.trace("Parameter is List");
                        if (!(_type instanceof ParameterizedType)) break block34;
                        ts /* !! */  = (ParameterizedType)_type;
                        type2 = ts /* !! */ .getActualTypeArguments()[0];
                        break block35;
                    }
                    if (!(_type instanceof GenericArrayType)) break block36;
                    fs = (Field[])_type;
                    type2 = fs.getGenericComponentType();
                    break block35;
                }
                if (!(_type instanceof Class)) ** GOTO lbl-1000
                clz = (Class)_type;
                if (((Class)_type).isArray()) {
                    type2 = clz.getComponentType();
                } else lbl-1000:
                // 2 sources

                {
                    type2 = null;
                }
            }
            Marshalling.LOGGER.trace("Type is: {}", (Object)type2);
            if (type2 != null) {
                var0 /* !! */  = Marshalling.deSerializeParameters((List)var0 /* !! */ , type2, _conn);
            }
        }
        if ((_type.equals(Float.class) || _type.equals(Float.TYPE)) && !(var0 /* !! */  instanceof Float)) {
            var0 /* !! */  = Float.valueOf(((Number)var0 /* !! */ ).floatValue());
            Marshalling.LOGGER.trace("Parameter is float of value: {}", (Object)var0 /* !! */ );
        }
        if (var0 /* !! */  instanceof Object[] || var0 /* !! */  instanceof Collection || var0 /* !! */ .getClass().isArray()) {
            if (_type instanceof ParameterizedType) {
                pt = (ParameterizedType)_type;
                var0 /* !! */  = ArrayFrob.convert(var0 /* !! */ , (Class)pt.getRawType());
            } else if (_type instanceof GenericArrayType) {
                ts /* !! */  = (GenericArrayType)_type;
                ct = ts /* !! */ .getGenericComponentType();
                cc = null;
                if (ct instanceof Class) {
                    cc = con = (Class)ct;
                }
                if (ct instanceof ParameterizedType) {
                    con = (ParameterizedType)ct;
                    cc = (Class)con.getRawType();
                }
                o = Array.newInstance(cc, 0);
                var0 /* !! */  = ArrayFrob.convert(var0 /* !! */ , o.getClass());
            } else if (_type instanceof Class) {
                clz /* !! */  = (Class)_type;
                if (((Class)_type).isArray()) {
                    cc = clz /* !! */ .getComponentType();
                    if ((cc.equals(Float.class) || cc.equals(Float.TYPE)) && var0 /* !! */  instanceof double[]) {
                        dbArr = (double[])var0 /* !! */ ;
                        tmp2 = new float[dbArr.length];
                        for (i = 0; i < dbArr.length; ++i) {
                            tmp2[i] = (float)dbArr[i];
                        }
                        var0 /* !! */  = (Type[])tmp2;
                    }
                    o = Array.newInstance(cc, 0);
                    var0 /* !! */  = ArrayFrob.convert(var0 /* !! */ , o.getClass());
                }
            }
        }
        if (var0 /* !! */  instanceof Map) {
            dmap = (Map)var0 /* !! */ ;
            Marshalling.LOGGER.trace("Deserializing a Map");
            if (_type instanceof ParameterizedType) {
                clz /* !! */  = (ParameterizedType)var1_1;
                maptypes = clz /* !! */ .getActualTypeArguments();
            } else {
                maptypes = var0 /* !! */ .getClass().getTypeParameters();
            }
            map = new LinkedHashMap<Object, Object>();
            for (Map.Entry<K, V> e : var3_3.entrySet()) {
                map.put(Marshalling.deSerializeParameter(e.getKey(), maptypes[0], _conn), Marshalling.deSerializeParameter(e.getValue(), maptypes[1], _conn));
            }
            var0 /* !! */  = map;
        }
        return var0 /* !! */ ;
    }

    static List<Object> deSerializeParameters(List<Object> _parameters, Type _type, AbstractConnectionBase _conn) throws Exception {
        List<Object> list;
        LOGGER.trace("Deserializing from {} to {}", _parameters, (Object)_type);
        if (_parameters == null) {
            return null;
        }
        for (int i = 0; i < _parameters.size(); ++i) {
            if (_parameters.get(i) == null) continue;
            _parameters.set(i, Marshalling.deSerializeParameter(_parameters.get(i), _type, _conn));
        }
        return list;
    }

    public static Object[] deSerializeParameters(Object[] _parameters, Type[] _types, AbstractConnectionBase _conn) throws Exception {
        Object[] objectArray;
        Object[] parameters;
        Class clz;
        ParameterizedType pt;
        Object object;
        LoggingHelper.logIf(LOGGER.isTraceEnabled(), () -> {
            void var1_1;
            Object[] objectArray;
            LOGGER.trace("Deserializing from {} to {} ", (Object)Arrays.deepToString(objectArray), (Object)Arrays.deepToString((Object[])var1_1));
        });
        if (_parameters == null) {
            return null;
        }
        Type[] types = _types;
        if (_types.length == 1 && (object = types[0]) instanceof ParameterizedType && Tuple.class.isAssignableFrom((Class)(pt = (ParameterizedType)object).getRawType())) {
            types = pt.getActualTypeArguments();
        }
        if (types.length == 1 && (object = types[0]) instanceof Class && Tuple.class.isAssignableFrom(clz = (Class)object)) {
            object = types[0].getTypeName();
            Constructor<?>[] constructors = Class.forName((String)object).getDeclaredConstructors();
            if (constructors.length != 1) {
                throw new DBusException("Error deserializing message: We had a Tuple type but wrong number of constructors for this Tuple. There should be exactly one.");
            }
            if (constructors[0].getParameterCount() != parameters.length) {
                throw new DBusException("Error deserializing message: We had a Tuple type but it had wrong number of constructor arguments. The number of constructor arguments should match the number of parameters to deserialize.");
            }
            Object o = constructors[0].newInstance(parameters);
            return new Object[]{o};
        }
        for (int i = 0; i < parameters.length; ++i) {
            ParameterizedType pt2;
            Type j2;
            if (i >= types.length) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Parameter length differs, expected {} but got {}", (Object)parameters.length, (Object)types.length);
                    for (int j2 = 0; j2 < parameters.length; ++j2) {
                        LOGGER.debug("Error, Parameters differ: {}, '{}'", (Object)j2, parameters[j2]);
                    }
                }
                throw new DBusException("Error deserializing message: number of parameters didn't match receiving signature");
            }
            if (null == parameters[i]) continue;
            if (types[i] instanceof Class && DBusSerializable.class.isAssignableFrom((Class)types[i]) || (j2 = types[i]) instanceof ParameterizedType && DBusSerializable.class.isAssignableFrom((Class)(pt2 = (ParameterizedType)j2).getRawType())) {
                Class dsc = types[i] instanceof Class ? (Class)types[i] : (Class)((ParameterizedType)types[i]).getRawType();
                for (Method m : dsc.getDeclaredMethods()) {
                    if (!m.getName().equals("deserialize")) continue;
                    Type[] newtypes = m.getGenericParameterTypes();
                    try {
                        Object[] sub = new Object[newtypes.length];
                        System.arraycopy(parameters, i, sub, 0, newtypes.length);
                        sub = Marshalling.deSerializeParameters(sub, newtypes, _conn);
                        DBusSerializable sz = (DBusSerializable)dsc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        m.invoke((Object)sz, sub);
                        Object[] compress = new Object[parameters.length - newtypes.length + 1];
                        System.arraycopy(parameters, 0, compress, 0, i);
                        compress[i] = sz;
                        System.arraycopy(parameters, i + newtypes.length, compress, i + 1, parameters.length - i - newtypes.length);
                        parameters = compress;
                    }
                    catch (ArrayIndexOutOfBoundsException _ex) {
                        LOGGER.debug("", (Throwable)_ex);
                        throw new DBusException(String.format("Not enough elements to create custom object from serialized data (%s < %s).", parameters.length - i, newtypes.length));
                    }
                }
                continue;
            }
            parameters[i] = Marshalling.deSerializeParameter(parameters[i], types[i], _conn);
        }
        return objectArray;
    }

    static {
        CLASS_TO_ARGUMENTTYPE.put(Boolean.class, (byte)98);
        CLASS_TO_ARGUMENTTYPE.put(Boolean.TYPE, (byte)98);
        CLASS_TO_ARGUMENTTYPE.put(Byte.class, (byte)121);
        CLASS_TO_ARGUMENTTYPE.put(Byte.TYPE, (byte)121);
        CLASS_TO_ARGUMENTTYPE.put(Short.class, (byte)110);
        CLASS_TO_ARGUMENTTYPE.put(Short.TYPE, (byte)110);
        CLASS_TO_ARGUMENTTYPE.put(Integer.class, (byte)105);
        CLASS_TO_ARGUMENTTYPE.put(Integer.TYPE, (byte)105);
        CLASS_TO_ARGUMENTTYPE.put(Long.class, (byte)120);
        CLASS_TO_ARGUMENTTYPE.put(Long.TYPE, (byte)120);
        CLASS_TO_ARGUMENTTYPE.put(Double.class, (byte)100);
        CLASS_TO_ARGUMENTTYPE.put(Double.TYPE, (byte)100);
        if (AbstractConnection.FLOAT_SUPPORT) {
            CLASS_TO_ARGUMENTTYPE.put(Float.class, (byte)102);
            CLASS_TO_ARGUMENTTYPE.put(Float.TYPE, (byte)102);
        } else {
            CLASS_TO_ARGUMENTTYPE.put(Float.class, (byte)100);
            CLASS_TO_ARGUMENTTYPE.put(Float.TYPE, (byte)100);
        }
        CLASS_TO_ARGUMENTTYPE.put(UInt16.class, (byte)113);
        CLASS_TO_ARGUMENTTYPE.put(UInt32.class, (byte)117);
        CLASS_TO_ARGUMENTTYPE.put(UInt64.class, (byte)116);
        CLASS_TO_ARGUMENTTYPE.put(CharSequence.class, (byte)115);
        CLASS_TO_ARGUMENTTYPE.put(Variant.class, (byte)118);
        CLASS_TO_ARGUMENTTYPE.put(FileDescriptor.class, (byte)104);
        CLASS_TO_ARGUMENTTYPE.put(DBusInterface.class, (byte)111);
        CLASS_TO_ARGUMENTTYPE.put(DBusPath.class, (byte)111);
        CLASS_TO_ARGUMENTTYPE.put(ObjectPath.class, (byte)111);
    }
}

