/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Error;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.utils.DBusNamingUtil;
import org.freedesktop.dbus.utils.Util;

public class DBusMatchRule {
    private static final Map<String, Class<? extends DBusSignal>> SIGNALTYPEMAP = new ConcurrentHashMap<String, Class<? extends DBusSignal>>();
    private static final List<Function<DBusMatchRule, String>> MATCHRULE_EQUALS_OPERATIONS = List.of(DBusMatchRule::getInterface, DBusMatchRule::getMember, DBusMatchRule::getObject, DBusMatchRule::getSource);
    private static final List<Function<DBusSignal, String>> SIGNAL_EQUALS_OPERATIONS = List.of(Message::getInterface, Message::getName, Message::getPath, Message::getSource);
    private final String type;
    private final String iface;
    private final String member;
    private final String object;
    private final String source;

    /*
     * WARNING - void declaration
     */
    public DBusMatchRule(String _type, String _iface, String _member) {
        this((String)var1_1, (String)var2_2, (String)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DBusMatchRule(String _type, String _iface, String _member, String _object) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.type = var1_1;
        this.iface = var2_2;
        this.member = var3_3;
        this.object = _object;
        this.source = null;
    }

    /*
     * WARNING - void declaration
     */
    DBusMatchRule(Class<? extends Object> _c, String _source, String _object, String _type, String _member) throws DBusException {
        void var3_3;
        void var2_2;
        if (DBusInterface.class.isAssignableFrom(_c)) {
            this.iface = DBusNamingUtil.getInterfaceName(_c);
            DBusMatchRule dBusMatchRule = this;
            dBusMatchRule.assertDBusInterface(dBusMatchRule.iface);
            this.member = _member != null ? _member : null;
            this.type = _type != null ? _type : null;
        } else if (DBusSignal.class.isAssignableFrom(_c)) {
            if (null == _c.getEnclosingClass()) {
                throw new DBusException("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package.");
            }
            this.iface = DBusNamingUtil.getInterfaceName(_c.getEnclosingClass());
            DBusMatchRule dBusMatchRule = this;
            dBusMatchRule.assertDBusInterface(dBusMatchRule.iface);
            this.member = _member != null ? _member : DBusNamingUtil.getSignalName(_c);
            SIGNALTYPEMAP.put(this.iface + "$" + this.member, _c);
            this.type = _type != null ? _type : "signal";
        } else if (Error.class.isAssignableFrom(_c) || DBusExecutionException.class.isAssignableFrom(_c)) {
            this.iface = DBusNamingUtil.getInterfaceName(_c);
            DBusMatchRule dBusMatchRule = this;
            dBusMatchRule.assertDBusInterface(dBusMatchRule.iface);
            this.member = _member != null ? _member : null;
            this.type = _type != null ? _type : "error";
        } else {
            void var1_1;
            throw new DBusException("Invalid type for match rule: " + String.valueOf(var1_1));
        }
        this.source = var2_2;
        this.object = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public DBusMatchRule(Class<? extends Object> _c, String _source, String _object) throws DBusException {
        this((Class<? extends Object>)var1_1, (String)var2_2, (String)var3_3, null, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DBusMatchRule(Class<? extends Object> _c) throws DBusException {
        this((Class<? extends Object>)var1_1, null, null);
        void var1_1;
    }

    public static Class<? extends DBusSignal> getCachedSignalType(String _type) {
        String string;
        return SIGNALTYPEMAP.get(string);
    }

    /*
     * WARNING - void declaration
     */
    void assertDBusInterface(String _str) throws DBusException {
        void var1_1;
        if (_str == null || _str.isEmpty() || _str.startsWith(".") || !var1_1.contains(".")) {
            throw new DBusException("DBusInterfaces must be defined in a package.");
        }
    }

    public boolean matches(DBusSignal _signal, boolean _strict) {
        if (_signal == null) {
            return false;
        }
        if (_strict) {
            return Util.strEquals(_signal.getInterface(), this.getInterface()) && Util.strEquals(_signal.getName(), this.getMember()) && Util.strEquals(_signal.getPath(), this.getObject()) && Util.strEquals(_signal.getSource(), this.getSource());
        }
        String[] compareVals = new String[]{this.getInterface(), this.getMember(), this.getObject(), this.getSource()};
        for (int i = 0; i < compareVals.length; ++i) {
            Function<DBusSignal, String> function;
            if (compareVals[i] == null || Util.strEquals(compareVals[i], (function = SIGNAL_EQUALS_OPERATIONS.get(i)).apply(_signal))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        String s = null;
        if (this.type != null) {
            s = "type='" + this.type + "'";
        }
        if (this.member != null) {
            String string = s = s == null ? "member='" + this.member + "'" : s + ",member='" + this.member + "'";
        }
        if (this.iface != null) {
            String string = s = s == null ? "interface='" + this.iface + "'" : s + ",interface='" + this.iface + "'";
        }
        if (this.source != null) {
            String string = s = s == null ? "sender='" + this.source + "'" : s + ",sender='" + this.source + "'";
        }
        if (this.object != null) {
            s = s == null ? "path='" + this.object + "'" : s + ",path='" + this.object + "'";
        }
        return var1_1;
    }

    public int hashCode() {
        return Objects.hash(this.iface, this.member, this.object, this.source, this.type);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object _obj) {
        void var1_1;
        if (this == _obj) {
            return true;
        }
        if (!(_obj instanceof DBusMatchRule)) {
            return false;
        }
        DBusMatchRule other = (DBusMatchRule)_obj;
        return Objects.equals(this.iface, other.iface) && Objects.equals(this.member, other.member) && Objects.equals(this.object, other.object) && Objects.equals(this.source, other.source) && Objects.equals(this.type, var1_1.type);
    }

    public String getInterface() {
        return this.iface;
    }

    public String getMember() {
        return this.member;
    }

    public String getSource() {
        return this.source;
    }

    public String getObject() {
        return this.object;
    }
}

