/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.freedesktop.dbus.annotations.Position;
import org.slf4j.LoggerFactory;

public abstract class Container {
    private static final Map<Type, Type[]> TYPE_CACHE = new ConcurrentHashMap<Type, Type[]>();
    private Object[] parameters = null;

    Container() {
    }

    /*
     * WARNING - void declaration
     */
    private void setup() {
        void var2_2;
        void var3_3;
        void var1_1;
        Field[] fs = this.getClass().getDeclaredFields();
        Object[] args = new Object[fs.length];
        int diff = 0;
        for (void f : var1_1) {
            if (!f.isAnnotationPresent(Position.class)) {
                ++diff;
                continue;
            }
            Position p = f.getAnnotation(Position.class);
            f.setAccessible(true);
            try {
                args[p.value()] = f.get(this);
            }
            catch (IllegalAccessException _exIa) {
                LoggerFactory.getLogger(this.getClass()).trace("Could not set value", (Throwable)_exIa);
            }
        }
        this.parameters = new Object[args.length - var3_3];
        System.arraycopy(var2_2, 0, this.parameters, 0, this.parameters.length);
    }

    public final Object[] getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        this.setup();
        return this.parameters;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("<");
        if (this.parameters == null) {
            this.setup();
        }
        if (0 == this.parameters.length) {
            return sb.append(">").toString();
        }
        sb.append(Arrays.stream(this.parameters).map(Objects::toString).collect(Collectors.joining(", ")));
        return var1_1.append(">").toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object _other) {
        if (this == _other) {
            return true;
        }
        if (_other == null) {
            return false;
        }
        if (_other instanceof Container) {
            void var1_1;
            Container cont = (Container)_other;
            return this.getClass().equals(cont.getClass()) && Arrays.equals(this.getParameters(), var1_1.getParameters());
        }
        return false;
    }

    public int hashCode() {
        int n = 31 + Arrays.deepHashCode(this.parameters);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static void putTypeCache(Type _k, Type[] _v) {
        void var1_1;
        Type type;
        TYPE_CACHE.put(type, (Type[])var1_1);
    }

    static Type[] getTypeCache(Type _k) {
        Type type;
        return TYPE_CACHE.get(type);
    }
}

