/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.freedesktop.dbus.utils.PrimitiveUtils;
import org.slf4j.LoggerFactory;

public final class ArrayFrob {
    private ArrayFrob() {
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] wrap(Object _o) throws IllegalArgumentException {
        void var1_1;
        Class<?> ac = _o.getClass();
        if (!ac.isArray()) {
            throw new IllegalArgumentException("Not an array");
        }
        Class<?> cc = ac.getComponentType();
        Class<?> ncc = PrimitiveUtils.getPrimitiveToWrapperTypes().get(cc);
        if (ncc == null) {
            throw new IllegalArgumentException("Not a primitive type");
        }
        Object[] ns = (Object[])Array.newInstance(ncc, Array.getLength(_o));
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = Array.get(_o, i);
        }
        return var1_1;
    }

    public static <T> Object unwrap(T[] _ns) throws IllegalArgumentException {
        Class<?> clazz = _ns.getClass();
        Class<?> cc = clazz.getComponentType();
        Class<?> ncc = PrimitiveUtils.getWrapperToPrimitiveTypes().get(cc);
        if (ncc == null) {
            throw new IllegalArgumentException("Not a wrapper type");
        }
        Object o = Array.newInstance(ncc, _ns.length);
        for (int i = 0; i < _ns.length; ++i) {
            Array.set(o, i, _ns[i]);
        }
        return clazz;
    }

    public static <T> List<T> listify(T[] _ns) throws IllegalArgumentException {
        return Arrays.asList(_ns);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> listify(Object _o) throws IllegalArgumentException {
        void var1_1;
        if (_o instanceof Object[]) {
            return ArrayFrob.listify((Object[])_o);
        }
        if (!_o.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array");
        }
        ArrayList<Object> l = new ArrayList<Object>(Array.getLength(_o));
        for (int i = 0; i < Array.getLength(_o); ++i) {
            l.add(Array.get(_o, i));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] delist(List<T> _l, Class<T> _c) throws IllegalArgumentException {
        void var1_1;
        return _l.toArray((Object[])Array.newInstance(var1_1, 0));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Object delistprimitive(List<T> _l, Class<T> _c) throws IllegalArgumentException {
        void var1_1;
        Object o = Array.newInstance(_c, _l.size());
        for (int i = 0; i < _l.size(); ++i) {
            Array.set(o, i, _l.get(i));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Object convert(Object _o, Class<? extends Object> _c) throws IllegalArgumentException {
        void var1_2;
        Object object;
        try {
            if (List.class.equals(_c) && _o instanceof List) {
                return _o;
            }
            if (List.class.equals(_c) && _o.getClass().isArray()) {
                return ArrayFrob.listify(_o);
            }
            if (_o.getClass().isArray() && _c.isArray() && _o.getClass().getComponentType().equals(_c.getComponentType())) {
                return _o;
            }
            if (_o.getClass().isArray() && _c.isArray() && _o.getClass().getComponentType().isPrimitive()) {
                return ArrayFrob.wrap(_o);
            }
            if (_o.getClass().isArray() && _c.isArray() && _c.getComponentType().isPrimitive()) {
                return ArrayFrob.unwrap((Object[])_o);
            }
            if (_o instanceof List && _c.isArray() && _c.getComponentType().isPrimitive()) {
                return ArrayFrob.delistprimitive((List)_o, _c.getComponentType());
            }
            if (_o instanceof List && _c.isArray()) {
                return ArrayFrob.delist((List)_o, _c.getComponentType());
            }
            if (_o.getClass().isArray() && _c.isArray()) {
                return ArrayFrob.type((Object[])_o, _c.getComponentType());
            }
        }
        catch (Exception _ex) {
            void var0_1;
            LoggerFactory.getLogger(ArrayFrob.class).debug("Cannot convert object.", (Throwable)_ex);
            throw new IllegalArgumentException((Throwable)var0_1);
        }
        throw new IllegalArgumentException(String.format("Not An Expected Convertion type from %s to %s", object.getClass(), var1_2));
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] type(Object[] _old, Class<Object> _c) {
        void var1_1;
        Object[] objectArray;
        Object[] ns = (Object[])Array.newInstance(_c, _old.length);
        System.arraycopy(objectArray, 0, ns, 0, ns.length);
        return var1_1;
    }
}

