/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.app.torrent.anitorrent;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.him188.ani.app.torrent.api.TorrentLibraryLoader;
import me.him188.ani.utils.logging.LoggerKt;
import me.him188.ani.utils.logging.LoggerKt_jvmKt;
import me.him188.ani.utils.platform.Platform;
import me.him188.ani.utils.platform.PlatformKt;
import org.openani.anitorrent.binding.anitorrentJNI;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0003R\u0018\u0010\u0016\u001a\u00060\u0014j\u0002`\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001b\u0010\"\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!"}, d2={"Lme/him188/ani/app/torrent/anitorrent/AnitorrentLibraryLoader;", "Lme/him188/ani/app/torrent/api/TorrentLibraryLoader;", "<init>", "()V", "", "loadDependencies", "Ljava/nio/file/Path;", "getTempDirForPlatform", "()Ljava/nio/file/Path;", "", "name", "makeDesktopPlatformName", "(Ljava/lang/String;)Ljava/lang/String;", "tempDir", "destinationName", "extractLibraryFromResources", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;)Ljava/nio/file/Path;", "loadLibraryFromResources", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "loadLibraries", "Lorg/slf4j/Logger;", "Lme/him188/ani/utils/logging/Logger;", "logger", "Lorg/slf4j/Logger;", "Lme/him188/ani/utils/platform/Platform;", "platform", "Lme/him188/ani/utils/platform/Platform;", "", "libraryLoaded", "Z", "_initAnitorrent$delegate", "Lkotlin/Lazy;", "get_initAnitorrent", "()Lkotlin/Unit;", "_initAnitorrent"})
@SourceDebugExtension(value={"SMAP\nAnitorrentLibraryLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnitorrentLibraryLoader.kt\nme/him188/ani/app/torrent/anitorrent/AnitorrentLibraryLoader\n+ 2 Platform.kt\nme/him188/ani/utils/platform/PlatformKt\n+ 3 LoggerKt.kt\nme/him188/ani/utils/logging/LoggerKt\n+ 4 LoggerKt.jvm.kt\nme/him188/ani/utils/logging/LoggerKt_jvmKt\n*L\n1#1,159:1\n140#2:160\n86#3,4:161\n86#3,4:165\n86#3,4:169\n86#3,4:173\n86#3,4:177\n86#3,4:181\n86#3,4:185\n86#3,4:189\n41#4:193\n*S KotlinDebug\n*F\n+ 1 AnitorrentLibraryLoader.kt\nme/him188/ani/app/torrent/anitorrent/AnitorrentLibraryLoader\n*L\n45#1:160\n50#1:161,4\n51#1:165,4\n54#1:169,4\n58#1:173,4\n60#1:177,4\n64#1:181,4\n67#1:185,4\n85#1:189,4\n26#1:193\n*E\n"})
public final class AnitorrentLibraryLoader
implements TorrentLibraryLoader {
    public static final AnitorrentLibraryLoader INSTANCE = new AnitorrentLibraryLoader();
    private static final Logger logger;
    private static final Platform platform;
    private static volatile boolean libraryLoaded;
    private static final Lazy _initAnitorrent$delegate;

    private AnitorrentLibraryLoader() {
    }

    private final Unit get_initAnitorrent() {
        Lazy lazy = _initAnitorrent$delegate;
        lazy.getValue();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadDependencies() throws IOException {
        Logger logger;
        Platform platform = AnitorrentLibraryLoader.platform;
        if (platform instanceof Platform.Android) {
            System.loadLibrary("anitorrent");
            return;
        }
        Platform platform2 = AnitorrentLibraryLoader.platform;
        Intrinsics.checkNotNull((Object)platform2, (String)"null cannot be cast to non-null type me.him188.ani.utils.platform.Platform.Desktop");
        Platform.Desktop platform3 = (Platform.Desktop)platform2;
        Logger $this$info$iv = AnitorrentLibraryLoader.logger;
        if ($this$info$iv.isInfoEnabled()) {
            logger = $this$info$iv;
            LoggerKt.info((Logger)logger, (String)"Loading anitorrent library");
        }
        if (($this$info$iv = AnitorrentLibraryLoader.logger).isInfoEnabled()) {
            logger = $this$info$iv;
            LoggerKt.info((Logger)logger, (String)("java.library.path: " + System.getProperty("java.library.path")));
        }
        try {
            System.loadLibrary("anitorrent");
            $this$info$iv = AnitorrentLibraryLoader.logger;
            if ($this$info$iv.isInfoEnabled()) {
                logger = $this$info$iv;
                LoggerKt.info((Logger)logger, (String)"Loading anitorrent library: success (from java.library.path)");
            }
            return;
        }
        catch (UnsatisfiedLinkError firstE) {
            Logger $this$info$iv2;
            try {
                $this$info$iv2 = AnitorrentLibraryLoader.logger;
                if ($this$info$iv2.isInfoEnabled()) {
                    logger = $this$info$iv2;
                    LoggerKt.info((Logger)logger, (String)"Failed to load anitorrent directly from java.library.path, trying resources instead");
                }
                Path temp = this.getTempDirForPlatform();
                Logger $this$info$iv3 = AnitorrentLibraryLoader.logger;
                if ($this$info$iv3.isInfoEnabled()) {
                    LoggerKt.info((Logger)$this$info$iv3, (String)("Temp dir: " + ((Object)temp.toAbsolutePath()).toString()));
                }
                if (($this$info$iv3 = platform3) instanceof Platform.Windows) {
                    Path it;
                    Path path = AnitorrentLibraryLoader.extractLibraryFromResources$default(this, "libssl-3-x64", temp, null, 4, null);
                    if (path != null) {
                        it = path;
                        $this$info$iv3 = AnitorrentLibraryLoader.logger;
                        if ($this$info$iv3.isInfoEnabled()) {
                            LoggerKt.info((Logger)$this$info$iv3, (String)("Extract ssl: " + ((Object)it.toAbsolutePath()).toString()));
                        }
                    }
                    Path path2 = AnitorrentLibraryLoader.extractLibraryFromResources$default(this, "libcrypto-3-x64", temp, null, 4, null);
                    if (path2 != null) {
                        it = path2;
                        $this$info$iv3 = AnitorrentLibraryLoader.logger;
                        if ($this$info$iv3.isInfoEnabled()) {
                            logger = $this$info$iv3;
                            LoggerKt.info((Logger)logger, (String)("Extract crypto: " + ((Object)platform.toAbsolutePath()).toString()));
                        }
                    }
                    this.loadLibraryFromResources("torrent-rasterbar", temp);
                } else if (!(logger instanceof Platform.MacOS) && !(logger instanceof Platform.Linux)) {
                    throw new NoWhenBranchMatchedException();
                }
                this.loadLibraryFromResources("anitorrent", temp);
            }
            catch (Throwable throwable) {
                void var2_3;
                Throwable e = throwable;
                ExceptionsKt.addSuppressed((Throwable)throwable, (Throwable)((Throwable)var2_3));
                throw e;
            }
            $this$info$iv2 = AnitorrentLibraryLoader.logger;
            if ($this$info$iv2.isInfoEnabled()) {
                void var3_5;
                logger = var3_5;
                LoggerKt.info((Logger)logger, (String)"Loading anitorrent library: success (from resources)");
            }
            return;
        }
    }

    private final Path getTempDirForPlatform() {
        Path path = Paths.get(System.getProperty("user.dir"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    private final String makeDesktopPlatformName(String name) {
        Platform platform = AnitorrentLibraryLoader.platform;
        Intrinsics.checkNotNull((Object)platform, (String)"null cannot be cast to non-null type me.him188.ani.utils.platform.Platform.Desktop");
        Platform.Desktop desktop = (Platform.Desktop)platform;
        if (desktop instanceof Platform.Linux) {
            return "lib" + name + ".so";
        }
        if (desktop instanceof Platform.Windows) {
            return name + ".dll";
        }
        if (desktop instanceof Platform.MacOS) {
            void var1_1;
            return "lib" + (String)var1_1 + ".dylib";
        }
        throw new NoWhenBranchMatchedException();
    }

    private final Path extractLibraryFromResources(String name, Path tempDir, String destinationName) {
        Closeable closeable;
        String filename = this.makeDesktopPlatformName(name);
        Object object = this.getClass().getClassLoader();
        if (object != null && (object = ((ClassLoader)object).getResourceAsStream((String)((Object)closeable))) != null) {
            Throwable throwable;
            closeable = (Closeable)object;
            Throwable throwable2 = null;
            try {
                Closeable closeable2;
                InputStream it = (InputStream)closeable;
                Object tempFile2 = tempDir.resolve(INSTANCE.makeDesktopPlatformName((String)((Object)closeable2)));
                Intrinsics.checkNotNull((Object)tempFile2);
                OpenOption[] openOptionArray = new OpenOption[]{};
                OutputStream outputStream = Files.newOutputStream((Path)tempFile2, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                closeable2 = outputStream;
                Throwable throwable3 = null;
                try {
                    OutputStream output = (OutputStream)closeable2;
                    ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable4) {
                    try {
                        tempFile2 = throwable4;
                        throwable3 = throwable4;
                        throw tempFile2;
                    }
                    catch (Throwable tempFile2) {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                        throw tempFile2;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable2, null);
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throwable2 = throwable5;
                    throw throwable;
                }
                catch (Throwable throwable6) {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    throw throwable6;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, null);
            return throwable;
        }
        return null;
    }

    static /* synthetic */ Path extractLibraryFromResources$default(AnitorrentLibraryLoader anitorrentLibraryLoader, String string, Path path, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = string;
        }
        return anitorrentLibraryLoader.extractLibraryFromResources(string, path, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadLibraryFromResources(String name, Path tempDir) {
        void var1_1;
        void var2_2;
        Path path = AnitorrentLibraryLoader.extractLibraryFromResources$default(this, (String)name, (Path)var2_2, null, 4, null);
        if (path != null) {
            name = path;
            System.load(((Object)path.toAbsolutePath()).toString());
            return;
        }
        throw new UnsatisfiedLinkError("Failed to extract library " + (String)var1_1 + " from resources (possibly no such resource)");
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void loadLibraries() throws UnsatisfiedLinkError {
        AnitorrentLibraryLoader anitorrentLibraryLoader = this;
        synchronized (anitorrentLibraryLoader) {
            if (libraryLoaded) {
                return;
            }
            try {
                INSTANCE.loadDependencies();
                INSTANCE.get_initAnitorrent();
                anitorrentJNI.lt_version();
                libraryLoaded = true;
            }
            catch (Throwable e) {
                void var2_2;
                libraryLoaded = false;
                throw var2_2;
            }
            return;
        }
    }

    private static final Unit _initAnitorrent_delegate$lambda$0() {
        return Unit.INSTANCE;
    }

    static {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        Intrinsics.checkNotNullExpressionValue((Object)iLoggerFactory, (String)"getILoggerFactory(...)");
        logger = LoggerKt_jvmKt.getLogger((ILoggerFactory)iLoggerFactory, AnitorrentLibraryLoader.class);
        platform = PlatformKt.currentPlatform();
        _initAnitorrent$delegate = LazyKt.lazy(AnitorrentLibraryLoader::_initAnitorrent_delegate$lambda$0);
    }
}

