/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.DraggableAnchors;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u001a\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0096\u0002\u00a2\u0006\u0004\b\u0018\u0010\rJ\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001fR\u0014\u0010!\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001b"}, d2={"Landroidx/compose/material3/internal/MapDraggableAnchors;", "T", "Landroidx/compose/material3/internal/DraggableAnchors;", "", "", "anchors", "<init>", "(Ljava/util/Map;)V", "value", "positionOf", "(Ljava/lang/Object;)F", "", "hasAnchorFor", "(Ljava/lang/Object;)Z", "position", "closestAnchor", "(F)Ljava/lang/Object;", "searchUpwards", "(FZ)Ljava/lang/Object;", "minAnchor", "()F", "maxAnchor", "", "other", "equals", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/Map;", "getSize", "size"})
@SourceDebugExtension(value={"SMAP\nAnchoredDraggable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnchoredDraggable.kt\nandroidx/compose/material3/internal/MapDraggableAnchors\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,868:1\n1#2:869\n*E\n"})
final class MapDraggableAnchors<T>
implements DraggableAnchors<T> {
    private final Map<T, Float> anchors;

    /*
     * WARNING - void declaration
     */
    public MapDraggableAnchors(Map<T, Float> anchors) {
        void var1_1;
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        this.anchors = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float positionOf(T value) {
        void var1_1;
        Float f = this.anchors.get(var1_1);
        if (f != null) {
            return f.floatValue();
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasAnchorFor(T value) {
        void var1_1;
        return this.anchors.containsKey(var1_1);
    }

    @Override
    public final T closestAnchor(float position) {
        Object v0;
        Object object = this.anchors.entrySet();
        if (!(object = object.iterator()).hasNext()) {
            v0 = null;
        } else {
            Object e = object.next();
            if (!object.hasNext()) {
                v0 = e;
            } else {
                Map.Entry it = (Map.Entry)e;
                float f = Math.abs(position - ((Number)it.getValue()).floatValue());
                do {
                    Object e2;
                    Map.Entry it2;
                    float f2;
                    if (Float.compare(f, f2 = Math.abs(position - ((Number)(it2 = (Map.Entry)(e2 = object.next())).getValue()).floatValue())) <= 0) continue;
                    e = e2;
                    f = f2;
                } while (object.hasNext());
                v0 = e;
            }
        }
        Map.Entry entry = v0;
        if (entry != null) {
            return (T)entry.getKey();
        }
        return null;
    }

    @Override
    public final T closestAnchor(float position, boolean searchUpwards) {
        Object v0;
        Object object = this.anchors.entrySet();
        if (!(object = object.iterator()).hasNext()) {
            v0 = null;
        } else {
            Object e = object.next();
            if (!object.hasNext()) {
                v0 = e;
            } else {
                Map.Entry entry = (Map.Entry)e;
                float anchor22 = ((Number)entry.getValue()).floatValue();
                float delta = searchUpwards ? anchor22 - position : position - anchor22;
                float f = delta < 0.0f ? Float.POSITIVE_INFINITY : delta;
                do {
                    float f2;
                    Object e2 = object.next();
                    Map.Entry anchor22 = (Map.Entry)e2;
                    anchor22 = ((Number)anchor22.getValue()).floatValue();
                    float delta2 = searchUpwards ? anchor22 - position : position - anchor22;
                    float f3 = f2 = delta2 < 0.0f ? Float.POSITIVE_INFINITY : delta2;
                    if (Float.compare(f, f2) <= 0) continue;
                    e = e2;
                    f = f2;
                } while (object.hasNext());
                v0 = e;
            }
        }
        Map.Entry entry = v0;
        if (entry != null) {
            return (T)entry.getKey();
        }
        return null;
    }

    @Override
    public final float minAnchor() {
        Float f = CollectionsKt.minOrNull((Iterable)this.anchors.values());
        if (f != null) {
            return f.floatValue();
        }
        return Float.NaN;
    }

    @Override
    public final float maxAnchor() {
        Float f = CollectionsKt.maxOrNull((Iterable)this.anchors.values());
        if (f != null) {
            return f.floatValue();
        }
        return Float.NaN;
    }

    @Override
    public final int getSize() {
        return this.anchors.size();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapDraggableAnchors)) {
            return false;
        }
        return Intrinsics.areEqual(this.anchors, ((MapDraggableAnchors)var1_1).anchors);
    }

    public final int hashCode() {
        return 31 * ((Object)this.anchors).hashCode();
    }

    public final String toString() {
        return "MapDraggableAnchors(" + this.anchors + ")";
    }
}

