/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.collection.FloatList;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListKt;
import androidx.compose.material3.carousel.ShiftPointRange;
import androidx.compose.material3.carousel.StrategyKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 32\u00020\u0001:\u00013BM\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rB1\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u000eJ)\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0017\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010!R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001f\u001a\u0004\b\"\u0010!R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010#\u001a\u0004\b$\u0010%R\u0017\u0010\t\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010#\u001a\u0004\b&\u0010%R\u0011\u0010\n\u001a\u00020\u00078\u0006\u00a2\u0006\u0006\n\u0004\b\n\u0010#R\u0011\u0010\u000b\u001a\u00020\u00078\u0006\u00a2\u0006\u0006\n\u0004\b\u000b\u0010#R\u0014\u0010'\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010#R\u0014\u0010(\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010#R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010+R\u0011\u0010.\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b-\u0010%R\u0017\u0010/\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b/\u00101R\u001e\u00102\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u0010\u001f"}, d2={"Landroidx/compose/material3/carousel/Strategy;", "", "Landroidx/compose/material3/carousel/KeylineList;", "defaultKeylines", "", "startKeylineSteps", "endKeylineSteps", "", "availableSpace", "itemSpacing", "beforeContentPadding", "afterContentPadding", "<init>", "(Landroidx/compose/material3/carousel/KeylineList;Ljava/util/List;Ljava/util/List;FFFF)V", "(Landroidx/compose/material3/carousel/KeylineList;FFFF)V", "scrollOffset", "maxScrollOffset", "", "roundToNearestStep", "getKeylineListForScrollOffset$material3", "(FFZ)Landroidx/compose/material3/carousel/KeylineList;", "getKeylineListForScrollOffset", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Landroidx/compose/material3/carousel/KeylineList;", "getDefaultKeylines", "()Landroidx/compose/material3/carousel/KeylineList;", "Ljava/util/List;", "getStartKeylineSteps", "()Ljava/util/List;", "getEndKeylineSteps", "F", "getAvailableSpace", "()F", "getItemSpacing", "startShiftDistance", "endShiftDistance", "Landroidx/collection/FloatList;", "startShiftPoints", "Landroidx/collection/FloatList;", "endShiftPoints", "getItemMainAxisSize", "itemMainAxisSize", "isValid", "Z", "()Z", "lastStartAndEndKeylineListSteps", "Companion"})
public final class Strategy {
    public static final Companion Companion = new Companion(null);
    private final KeylineList defaultKeylines;
    private final List<KeylineList> startKeylineSteps;
    private final List<KeylineList> endKeylineSteps;
    private final float availableSpace;
    private final float itemSpacing;
    public final float beforeContentPadding;
    public final float afterContentPadding;
    private final float startShiftDistance;
    private final float endShiftDistance;
    private final FloatList startShiftPoints;
    private final FloatList endShiftPoints;
    private final boolean isValid;
    private List<KeylineList> lastStartAndEndKeylineListSteps;
    public static final int $stable = 8;
    private static final Strategy Empty = new Strategy(KeylineListKt.emptyKeylineList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), 0.0f, 0.0f, 0.0f, 0.0f);

    /*
     * WARNING - void declaration
     */
    private Strategy(KeylineList defaultKeylines, List<KeylineList> startKeylineSteps, List<KeylineList> endKeylineSteps, float availableSpace, float itemSpacing, float beforeContentPadding, float afterContentPadding) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.defaultKeylines = var1_1;
        this.startKeylineSteps = var2_2;
        this.endKeylineSteps = var3_3;
        this.availableSpace = availableSpace;
        this.itemSpacing = itemSpacing;
        this.beforeContentPadding = beforeContentPadding;
        this.afterContentPadding = afterContentPadding;
        this.startShiftDistance = StrategyKt.access$getStartShiftDistance(this.startKeylineSteps, this.beforeContentPadding);
        this.endShiftDistance = StrategyKt.access$getEndShiftDistance(this.endKeylineSteps, this.afterContentPadding);
        this.startShiftPoints = StrategyKt.access$getStepInterpolationPoints(this.startShiftDistance, this.startKeylineSteps, true);
        this.endShiftPoints = StrategyKt.access$getStepInterpolationPoints(this.endShiftDistance, this.endKeylineSteps, false);
        this.isValid = !((Collection)this.defaultKeylines).isEmpty() && !(this.availableSpace == 0.0f) && !(this.getItemMainAxisSize() == 0.0f);
    }

    public final KeylineList getDefaultKeylines() {
        return this.defaultKeylines;
    }

    public final List<KeylineList> getStartKeylineSteps() {
        return this.startKeylineSteps;
    }

    public final List<KeylineList> getEndKeylineSteps() {
        return this.endKeylineSteps;
    }

    public final float getAvailableSpace() {
        return this.availableSpace;
    }

    public final float getItemSpacing() {
        return this.itemSpacing;
    }

    /*
     * WARNING - void declaration
     */
    public Strategy(KeylineList defaultKeylines, float availableSpace, float itemSpacing, float beforeContentPadding, float afterContentPadding) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)defaultKeylines, (String)"defaultKeylines");
        KeylineList keylineList = defaultKeylines;
        this(keylineList, StrategyKt.access$getStartKeylineSteps(keylineList, availableSpace, itemSpacing, beforeContentPadding), StrategyKt.access$getEndKeylineSteps((KeylineList)var1_1, availableSpace, itemSpacing, afterContentPadding), (float)var2_2, (float)var3_3, beforeContentPadding, afterContentPadding);
    }

    public final float getItemMainAxisSize() {
        return this.defaultKeylines.getFirstFocal().getSize();
    }

    public final boolean isValid() {
        return this.isValid;
    }

    /*
     * WARNING - void declaration
     */
    public final KeylineList getKeylineListForScrollOffset$material3(float scrollOffset, float maxScrollOffset, boolean roundToNearestStep) {
        void var1_3;
        void var3_6;
        float positiveScrollOffset2 = Math.max(0.0f, scrollOffset);
        float startShiftOffset = this.startShiftDistance;
        float endShiftOffset = Math.max(0.0f, maxScrollOffset - this.endShiftDistance);
        boolean bl = startShiftOffset <= positiveScrollOffset2 ? positiveScrollOffset2 <= endShiftOffset : false;
        if (bl) {
            return this.defaultKeylines;
        }
        float interpolation = StrategyKt.access$lerp(1.0f, 0.0f, 0.0f, startShiftOffset, positiveScrollOffset2);
        FloatList shiftPoints = this.startShiftPoints;
        List<KeylineList> steps = this.startKeylineSteps;
        if (positiveScrollOffset2 > endShiftOffset) {
            void var2_5;
            interpolation = StrategyKt.access$lerp(0.0f, 1.0f, endShiftOffset, (float)var2_5, positiveScrollOffset2);
            shiftPoints = this.endShiftPoints;
            steps = this.endKeylineSteps;
            if (endShiftOffset < 0.01f && this.startKeylineSteps.size() == 2 && this.endKeylineSteps.size() == 2) {
                if (this.lastStartAndEndKeylineListSteps == null) {
                    Object[] objectArray = new KeylineList[2];
                    Object[] positiveScrollOffset2 = objectArray;
                    objectArray[0] = CollectionsKt.last(this.startKeylineSteps);
                    positiveScrollOffset2[1] = CollectionsKt.last(this.endKeylineSteps);
                    this.lastStartAndEndKeylineListSteps = CollectionsKt.listOf((Object[])positiveScrollOffset2);
                }
                List<KeylineList> list = this.lastStartAndEndKeylineListSteps;
                Intrinsics.checkNotNull(list);
                steps = list;
            }
        }
        ShiftPointRange shiftPointRange = StrategyKt.access$getShiftPointRange(steps.size(), shiftPoints, interpolation);
        if (var3_6 != false) {
            void var1_4;
            int roundedStepIndex = MathKt.roundToInt((float)shiftPointRange.getSteppedInterpolation()) == 0 ? shiftPointRange.getFromStepIndex() : shiftPointRange.getToStepIndex();
            return steps.get((int)var1_4);
        }
        return KeylineListKt.lerp(steps.get(var1_3.getFromStepIndex()), steps.get(var1_3.getToStepIndex()), var1_3.getSteppedInterpolation());
    }

    public static /* synthetic */ KeylineList getKeylineListForScrollOffset$material3$default(Strategy strategy, float f, float f2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return strategy.getKeylineListForScrollOffset$material3(f, f2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof Strategy)) {
            return false;
        }
        if (!this.isValid && !((Strategy)other).isValid) {
            return true;
        }
        if (this.isValid != ((Strategy)other).isValid) {
            return false;
        }
        if (!(this.availableSpace == ((Strategy)other).availableSpace)) {
            return false;
        }
        if (!(this.itemSpacing == ((Strategy)other).itemSpacing)) {
            return false;
        }
        if (!(this.beforeContentPadding == ((Strategy)other).beforeContentPadding)) {
            return false;
        }
        if (!(this.afterContentPadding == ((Strategy)other).afterContentPadding)) {
            return false;
        }
        if (!(this.getItemMainAxisSize() == ((Strategy)other).getItemMainAxisSize())) {
            return false;
        }
        if (!(this.startShiftDistance == ((Strategy)other).startShiftDistance)) {
            return false;
        }
        if (!(this.endShiftDistance == ((Strategy)other).endShiftDistance)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startShiftPoints, (Object)((Strategy)other).startShiftPoints)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endShiftPoints, (Object)((Strategy)other).endShiftPoints)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.defaultKeylines, (Object)((Strategy)var1_1).defaultKeylines);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        if (!this.isValid) {
            return Boolean.hashCode(this.isValid);
        }
        int result = Boolean.hashCode(this.isValid);
        result = result * 31 + Float.hashCode(this.availableSpace);
        result = result * 31 + Float.hashCode(this.itemSpacing);
        result = result * 31 + Float.hashCode(this.beforeContentPadding);
        result = result * 31 + Float.hashCode(this.afterContentPadding);
        result = result * 31 + Float.hashCode(this.getItemMainAxisSize());
        result = result * 31 + Float.hashCode(this.startShiftDistance);
        result = result * 31 + Float.hashCode(this.endShiftDistance);
        result = result * 31 + this.startShiftPoints.hashCode();
        result = result * 31 + this.endShiftPoints.hashCode();
        var1_1 = var1_1 * 31 + this.defaultKeylines.hashCode();
        return (int)var1_1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Landroidx/compose/material3/carousel/Strategy$Companion;", "", "<init>", "()V", "Landroidx/compose/material3/carousel/Strategy;", "Empty", "Landroidx/compose/material3/carousel/Strategy;", "getEmpty", "()Landroidx/compose/material3/carousel/Strategy;"})
    public static final class Companion {
        private Companion() {
        }

        public final Strategy getEmpty() {
            return Empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

