/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.compose.material3.carousel.Arrangement;
import androidx.compose.material3.carousel.CarouselAlignment;
import androidx.compose.material3.carousel.CarouselDefaults;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListKt;
import androidx.compose.material3.carousel.KeylineListScope;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aQ\u0010\r\u001a\u00020\f2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a7\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a7\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0014"}, d2={"Landroidx/compose/ui/unit/Density;", "density", "", "carouselMainAxisSize", "maxItemSize", "itemSpacing", "", "itemCount", "", "isCentered", "minSmallItemSize", "maxSmallItemSize", "Landroidx/compose/material3/carousel/KeylineList;", "heroKeylineList", "(Landroidx/compose/ui/unit/Density;FLjava/lang/Float;FIZFF)Landroidx/compose/material3/carousel/KeylineList;", "leftAnchorSize", "rightAnchorSize", "Landroidx/compose/material3/carousel/Arrangement;", "arrangement", "createLeftAlignedKeylineList", "(FFFFLandroidx/compose/material3/carousel/Arrangement;)Landroidx/compose/material3/carousel/KeylineList;", "createCenterAlignedKeylineList"})
@SourceDebugExtension(value={"SMAP\nKeylines.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Keylines.kt\nandroidx/compose/material3/carousel/KeylinesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1#2:361\n*E\n"})
public final class KeylinesKt {
    /*
     * WARNING - void declaration
     */
    public static final KeylineList heroKeylineList(Density density, float carouselMainAxisSize, Float maxItemSize, float itemSpacing, int itemCount, boolean isCentered, float minSmallItemSize, float maxSmallItemSize) {
        void var3_4;
        void var1_1;
        void var2_3;
        Density density2;
        int[] nArray;
        int[] nArray2;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        if (carouselMainAxisSize == 0.0f) {
            return KeylineListKt.emptyKeylineList();
        }
        boolean shouldCenter = isCentered && itemCount >= 3;
        if (shouldCenter) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = 2;
            nArray = nArray2;
        } else {
            int[] nArray4 = new int[1];
            nArray2 = nArray4;
            nArray4[0] = 1;
            nArray = nArray2;
        }
        int[] smallCounts = nArray;
        Float f = maxItemSize;
        float targetLargeSize = Math.min(f != null ? f.floatValue() : carouselMainAxisSize, carouselMainAxisSize);
        float targetSmallSize = RangesKt.coerceIn((float)(targetLargeSize / 3.0f), (float)minSmallItemSize, (float)maxSmallItemSize);
        float fullscreenThreshold22 = minSmallItemSize * (float)ArraysKt.maxOrThrow((int[])smallCounts) + minSmallItemSize * 1.25f;
        if (carouselMainAxisSize < fullscreenThreshold22) {
            int[] nArray5 = new int[1];
            int[] fullscreenThreshold22 = nArray5;
            nArray5[0] = 0;
            smallCounts = fullscreenThreshold22;
        }
        fullscreenThreshold22 = carouselMainAxisSize - minSmallItemSize * (float)ArraysKt.maxOrThrow((int[])smallCounts);
        int fullscreenThreshold22 = (int)Math.floor(fullscreenThreshold22 / targetLargeSize);
        int minLargeCount = Math.max(1, fullscreenThreshold22);
        int maxLargeCount = (int)Math.ceil(carouselMainAxisSize / targetLargeSize);
        int n = 0;
        int n2 = maxLargeCount - minLargeCount + 1;
        int[] nArray6 = new int[n2];
        while (n < n2) {
            minLargeCount = n++;
            nArray6[minLargeCount] = maxLargeCount - minLargeCount;
        }
        int[] largeCounts = nArray6;
        Density density3 = density2;
        float anchorSize = density3.toPx-0680j_4(CarouselDefaults.INSTANCE.getAnchorSize-D9Ej5fM$material3());
        int[] nArray7 = new int[1];
        nArray6 = nArray7;
        nArray7[0] = 0;
        Arrangement arrangement = Arrangement.Companion.findLowestCostArrangement(carouselMainAxisSize, itemSpacing, (float)var2_3, minSmallItemSize, maxSmallItemSize, smallCounts, 0.0f, nArray6, targetLargeSize, largeCounts);
        if (arrangement == null) {
            return KeylineListKt.emptyKeylineList();
        }
        if (shouldCenter && itemCount >= arrangement.itemCount()) {
            float f2 = anchorSize;
            return KeylinesKt.createCenterAlignedKeylineList(carouselMainAxisSize, itemSpacing, f2, f2, arrangement);
        }
        float f3 = anchorSize;
        return KeylinesKt.createLeftAlignedKeylineList((float)var1_1, (float)var3_4, f3, f3, arrangement);
    }

    /*
     * WARNING - void declaration
     */
    public static final KeylineList createLeftAlignedKeylineList(float carouselMainAxisSize, float itemSpacing, float leftAnchorSize, float rightAnchorSize, Arrangement arrangement) {
        void var3_3;
        void var2_2;
        void var1_1;
        float f;
        Intrinsics.checkNotNullParameter((Object)arrangement, (String)"arrangement");
        return KeylineListKt.keylineListOf-WNYm7Xg(f, (float)var1_1, CarouselAlignment.Companion.getStart-NUL3oTo(), (Function1<? super KeylineListScope, Unit>)((Function1)arg_0 -> KeylinesKt.createLeftAlignedKeylineList$lambda$10((float)var2_2, arrangement, (float)var3_3, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public static final KeylineList createCenterAlignedKeylineList(float carouselMainAxisSize, float itemSpacing, float leftAnchorSize, float rightAnchorSize, Arrangement arrangement) {
        void var3_3;
        void var2_2;
        void var1_1;
        float f;
        Intrinsics.checkNotNullParameter((Object)arrangement, (String)"arrangement");
        return KeylineListKt.keylineListOf-WNYm7Xg(f, (float)var1_1, CarouselAlignment.Companion.getCenter-NUL3oTo(), (Function1<? super KeylineListScope, Unit>)((Function1)arg_0 -> KeylinesKt.createCenterAlignedKeylineList$lambda$16((float)var2_2, arrangement, (float)var3_3, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createLeftAlignedKeylineList$lambda$10(float $leftAnchorSize, Arrangement $arrangement, float $rightAnchorSize, KeylineListScope $this$keylineListOf) {
        void var2_3;
        void var3_4;
        int n;
        float f;
        Intrinsics.checkNotNullParameter((Object)$this$keylineListOf, (String)"$this$keylineListOf");
        $this$keylineListOf.add(f, true);
        int n2 = $arrangement.getLargeCount();
        for (n = 0; n < n2; ++n) {
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getLargeSize(), false, 2, null);
        }
        n2 = $arrangement.getMediumCount();
        for (n = 0; n < n2; ++n) {
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getMediumSize(), false, 2, null);
        }
        n2 = $arrangement.getSmallCount();
        for (n = 0; n < n2; ++n) {
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getSmallSize(), false, 2, null);
        }
        var3_4.add((float)var2_3, true);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterAlignedKeylineList$lambda$16(float $leftAnchorSize, Arrangement $arrangement, float $rightAnchorSize, KeylineListScope $this$keylineListOf) {
        void var2_3;
        void var3_4;
        int n;
        float f;
        Intrinsics.checkNotNullParameter((Object)$this$keylineListOf, (String)"$this$keylineListOf");
        $this$keylineListOf.add(f, true);
        int n2 = $arrangement.getSmallCount() / 2;
        for (n = 0; n < n2; ++n) {
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getSmallSize(), false, 2, null);
        }
        n2 = $arrangement.getMediumCount() / 2;
        for (n = 0; n < n2; ++n) {
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getMediumSize(), false, 2, null);
        }
        n2 = $arrangement.getLargeCount();
        for (n = 0; n < n2; ++n) {
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getLargeSize(), false, 2, null);
        }
        n2 = $arrangement.getMediumCount() / 2;
        for (n = 0; n < n2; ++n) {
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getMediumSize(), false, 2, null);
        }
        n2 = $arrangement.getSmallCount() / 2;
        for (n = 0; n < n2; ++n) {
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getSmallSize(), false, 2, null);
        }
        var3_4.add((float)var2_3, true);
        return Unit.INSTANCE;
    }
}

