/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.material3.carousel.CarouselPageSize;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.Strategy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a'\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Landroidx/compose/material3/carousel/Strategy;", "strategy", "", "itemIndex", "itemCount", "getSnapPositionOffset", "(Landroidx/compose/material3/carousel/Strategy;II)I", "Landroidx/compose/material3/carousel/CarouselPageSize;", "pageSize", "Landroidx/compose/foundation/gestures/snapping/SnapPosition;", "KeylineSnapPosition", "(Landroidx/compose/material3/carousel/CarouselPageSize;)Landroidx/compose/foundation/gestures/snapping/SnapPosition;"})
public final class KeylineSnapPositionKt {
    /*
     * WARNING - void declaration
     */
    public static final int getSnapPositionOffset(Strategy strategy, int itemIndex, int itemCount) {
        int n;
        void var2_3;
        int lastItemIndex;
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        if (!strategy.isValid()) {
            return 0;
        }
        int offset22 = MathKt.roundToInt((float)(strategy.getDefaultKeylines().getFirstFocal().getUnadjustedOffset() - strategy.getItemMainAxisSize() / 2.0f));
        if (itemIndex <= CollectionsKt.getLastIndex(strategy.getStartKeylineSteps())) {
            int stepIndex = RangesKt.coerceIn((int)(CollectionsKt.getLastIndex(strategy.getStartKeylineSteps()) - itemIndex), (int)0, (int)CollectionsKt.getLastIndex(strategy.getStartKeylineSteps()));
            KeylineList offset22 = strategy.getStartKeylineSteps().get(stepIndex);
            offset22 = MathKt.roundToInt((float)(offset22.getFirstFocal().getUnadjustedOffset() - strategy.getItemMainAxisSize() / 2.0f));
        }
        if (itemIndex >= (lastItemIndex = itemCount - 1) - CollectionsKt.getLastIndex(strategy.getEndKeylineSteps()) && var2_3 > strategy.getDefaultKeylines().getFocalCount()) {
            Strategy strategy2;
            void var1_1;
            int stepIndex = RangesKt.coerceIn((int)(CollectionsKt.getLastIndex(strategy.getEndKeylineSteps()) - (lastItemIndex - var1_1)), (int)0, (int)CollectionsKt.getLastIndex(strategy.getEndKeylineSteps()));
            KeylineList keylineList = strategy.getEndKeylineSteps().get(n);
            n = MathKt.roundToInt((float)(keylineList.getFirstFocal().getUnadjustedOffset() - strategy2.getItemMainAxisSize() / 2.0f));
        }
        return n;
    }

    public static final SnapPosition KeylineSnapPosition(CarouselPageSize pageSize) {
        CarouselPageSize carouselPageSize;
        Intrinsics.checkNotNullParameter((Object)pageSize, (String)"pageSize");
        return new SnapPosition(carouselPageSize){
            final /* synthetic */ CarouselPageSize $pageSize;
            {
                void var1_1;
                this.$pageSize = var1_1;
            }

            public final int position(int layoutSize, int itemSize, int beforeContentPadding, int afterContentPadding, int itemIndex, int itemCount) {
                return KeylineSnapPositionKt.getSnapPositionOffset(this.$pageSize.getStrategy(), itemIndex, itemCount);
            }
        };
    }
}

