/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0015\u001a\u0004\b\u0019\u0010\u0014R\u0017\u0010\u0007\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0015\u001a\u0004\b\u001b\u0010\u0014R\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0016\u001a\u0004\b\u001c\u0010\u0018R\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0015\u001a\u0004\b\u001d\u0010\u0014"}, d2={"Landroidx/compose/material3/carousel/Arrangement;", "", "", "priority", "", "smallSize", "smallCount", "mediumSize", "mediumCount", "largeSize", "largeCount", "<init>", "(IFIFIFI)V", "", "isValid", "()Z", "targetLargeSize", "cost", "(F)F", "itemCount", "()I", "I", "F", "getSmallSize", "()F", "getSmallCount", "getMediumSize", "getMediumCount", "getLargeSize", "getLargeCount", "Companion"})
public final class Arrangement {
    public static final Companion Companion = new Companion(null);
    private final int priority;
    private final float smallSize;
    private final int smallCount;
    private final float mediumSize;
    private final int mediumCount;
    private final float largeSize;
    private final int largeCount;

    /*
     * WARNING - void declaration
     */
    public Arrangement(int priority, float smallSize, int smallCount, float mediumSize, int mediumCount, float largeSize, int largeCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.priority = var1_1;
        this.smallSize = var2_2;
        this.smallCount = var3_3;
        this.mediumSize = mediumSize;
        this.mediumCount = mediumCount;
        this.largeSize = largeSize;
        this.largeCount = largeCount;
    }

    public final float getSmallSize() {
        return this.smallSize;
    }

    public final int getSmallCount() {
        return this.smallCount;
    }

    public final float getMediumSize() {
        return this.mediumSize;
    }

    public final int getMediumCount() {
        return this.mediumCount;
    }

    public final float getLargeSize() {
        return this.largeSize;
    }

    public final int getLargeCount() {
        return this.largeCount;
    }

    private final boolean isValid() {
        if (this.largeCount > 0 && this.smallCount > 0 && this.mediumCount > 0) {
            return this.largeSize > this.mediumSize && this.mediumSize > this.smallSize;
        }
        if (this.largeCount > 0 && this.smallCount > 0) {
            return this.largeSize > this.smallSize;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final float cost(float targetLargeSize) {
        void var1_1;
        if (!this.isValid()) {
            return Float.MAX_VALUE;
        }
        return Math.abs((float)(var1_1 - this.largeSize)) * (float)this.priority;
    }

    public final int itemCount() {
        return this.largeCount + this.mediumCount + this.smallCount;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ float access$cost(Arrangement $this, float targetLargeSize) {
        void var1_1;
        return $this.cost((float)var1_1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J_\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\u0012Jg\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ7\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e"}, d2={"Landroidx/compose/material3/carousel/Arrangement$Companion;", "", "<init>", "()V", "", "availableSpace", "itemSpacing", "targetSmallSize", "minSmallSize", "maxSmallSize", "", "smallCounts", "targetMediumSize", "mediumCounts", "targetLargeSize", "largeCounts", "Landroidx/compose/material3/carousel/Arrangement;", "findLowestCostArrangement", "(FFFFF[IF[IF[I)Landroidx/compose/material3/carousel/Arrangement;", "", "priority", "smallCount", "smallSize", "mediumCount", "mediumSize", "largeCount", "largeSize", "fit", "(IFFIFFFIFIF)Landroidx/compose/material3/carousel/Arrangement;", "calculateLargeSize", "(FIFII)F"})
    public static final class Companion {
        private Companion() {
        }

        public final Arrangement findLowestCostArrangement(float availableSpace, float itemSpacing, float targetSmallSize, float minSmallSize, float maxSmallSize, int[] smallCounts, float targetMediumSize, int[] mediumCounts, float targetLargeSize, int[] largeCounts) {
            Intrinsics.checkNotNullParameter((Object)smallCounts, (String)"smallCounts");
            Intrinsics.checkNotNullParameter((Object)mediumCounts, (String)"mediumCounts");
            Intrinsics.checkNotNullParameter((Object)largeCounts, (String)"largeCounts");
            Arrangement lowestCostArrangement = null;
            int priority = 1;
            for (int largeCount : largeCounts) {
                for (int mediumCount : mediumCounts) {
                    for (int smallCount : smallCounts) {
                        Arrangement arrangement = this.fit(priority, availableSpace, itemSpacing, smallCount, targetSmallSize, minSmallSize, maxSmallSize, mediumCount, targetMediumSize, largeCount, targetLargeSize);
                        if ((lowestCostArrangement == null || Arrangement.access$cost(arrangement, targetLargeSize) < Arrangement.access$cost(lowestCostArrangement, targetLargeSize)) && Arrangement.access$cost(lowestCostArrangement = arrangement, targetLargeSize) == 0.0f) {
                            return lowestCostArrangement;
                        }
                        ++priority;
                    }
                }
            }
            return lowestCostArrangement;
        }

        /*
         * WARNING - void declaration
         */
        private final Arrangement fit(int priority, float availableSpace, float itemSpacing, int smallCount, float smallSize, float minSmallSize, float maxSmallSize, int mediumCount, float mediumSize, int largeCount, float largeSize) {
            void var3_3;
            void var1_1;
            int totalItemCount = largeCount + mediumCount + smallCount;
            float availableSpaceWithoutSpacing = availableSpace - (float)(totalItemCount - 1) * itemSpacing;
            float arrangedSmallSize = RangesKt.coerceIn((float)smallSize, (float)minSmallSize, (float)maxSmallSize);
            float arrangedMediumSize = mediumSize;
            mediumSize = largeSize;
            float totalSpaceTakenByArrangement = mediumSize * (float)largeCount + arrangedMediumSize * (float)mediumCount + arrangedSmallSize * (float)smallCount;
            float delta = availableSpaceWithoutSpacing - totalSpaceTakenByArrangement;
            if (smallCount > 0 && delta > 0.0f) {
                arrangedSmallSize += Math.min(delta / (float)smallCount, maxSmallSize - arrangedSmallSize);
            } else if (smallCount > 0 && delta < 0.0f) {
                arrangedSmallSize += Math.max(delta / (float)smallCount, minSmallSize - arrangedSmallSize);
            }
            arrangedSmallSize = smallCount > 0 ? arrangedSmallSize : 0.0f;
            float arrangedLargeSize = this.calculateLargeSize(availableSpaceWithoutSpacing, smallCount, arrangedSmallSize, mediumCount, largeCount);
            float f = (arrangedLargeSize + arrangedSmallSize) / 2.0f;
            if (mediumCount > 0 && !(arrangedLargeSize == largeSize)) {
                void var2_2;
                float targetAdjustment = (largeSize - arrangedLargeSize) * (float)largeCount;
                float availableMediumFlex = f * 0.1f * (float)mediumCount;
                float distribute = Math.min(Math.abs(targetAdjustment), availableMediumFlex);
                if (var2_2 > 0.0f) {
                    f -= distribute / (float)mediumCount;
                    arrangedLargeSize += distribute / (float)largeCount;
                } else {
                    f += distribute / (float)mediumCount;
                    arrangedLargeSize -= distribute / (float)largeCount;
                }
            }
            return new Arrangement((int)var1_1, (float)var3_3, smallCount, f, mediumCount, arrangedLargeSize, largeCount);
        }

        /*
         * WARNING - void declaration
         */
        private final float calculateLargeSize(float availableSpace, int smallCount, float smallSize, int mediumCount, int largeCount) {
            void var3_3;
            void var2_2;
            return (availableSpace - ((float)var2_2 + (float)mediumCount / 2.0f) * var3_3) / ((float)largeCount + (float)mediumCount / 2.0f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

