/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bytebuddy.agent.utility.nullability.MaybeNull;
import net.bytebuddy.agent.utility.nullability.UnknownNull;

public interface VirtualMachine {
    public Properties getSystemProperties() throws IOException;

    public Properties getAgentProperties() throws IOException;

    public void loadAgent(String var1) throws IOException;

    public void loadAgent(String var1, @MaybeNull String var2) throws IOException;

    public void loadAgentPath(String var1) throws IOException;

    public void loadAgentPath(String var1, @MaybeNull String var2) throws IOException;

    public void loadAgentLibrary(String var1) throws IOException;

    public void loadAgentLibrary(String var1, @MaybeNull String var2) throws IOException;

    public void startManagementAgent(Properties var1) throws IOException;

    public String startLocalManagementAgent() throws IOException;

    public void detach() throws IOException;

    public static class ForOpenJ9
    extends AbstractBase {
        private static final String IBM_TEMPORARY_FOLDER = "com.ibm.tools.attach.directory";
        private static final SecureRandom SECURE_RANDOM = new SecureRandom();
        private final Socket socket;

        /*
         * WARNING - void declaration
         */
        protected ForOpenJ9(Socket socket) {
            void var1_1;
            this.socket = var1_1;
        }

        public static VirtualMachine attach(String processId) throws IOException {
            return ForOpenJ9.attach(processId, 5000, Platform.isWindows() ? new Dispatcher.ForJnaWindowsEnvironment() : new Dispatcher.ForJnaPosixEnvironment(15, 100L, TimeUnit.MILLISECONDS));
        }

        /*
         * Could not resolve type clashes
         * Loose catch block
         * WARNING - void declaration
         */
        public static VirtualMachine attach(String processId, int timeout, Dispatcher dispatcher) throws IOException {
            String temporary = System.getProperty(IBM_TEMPORARY_FOLDER);
            File directory = temporary == null ? new File(dispatcher.getTemporaryFolder(processId), ".com_ibm_tools_attach") : new File(temporary);
            long userId = dispatcher.userId();
            RandomAccessFile attachLock = new RandomAccessFile(new File(directory, "_attachlock"), "rw");
            try {
                FileLock attachLockLock = attachLock.getChannel().lock();
                try {
                    ArrayList<Properties> virtualMachines;
                    RandomAccessFile master = new RandomAccessFile(new File(directory, "_master"), "rw");
                    try {
                        FileLock masterLock = master.getChannel().lock();
                        try {
                            File[] vmFolder = directory.listFiles();
                            if (vmFolder == null) {
                                throw new IllegalStateException("No descriptor files found in " + directory);
                            }
                            virtualMachines = new ArrayList<Properties>();
                            File[] fileArray = vmFolder;
                            int n = vmFolder.length;
                            for (int i = 0; i < n; ++i) {
                                long targetUserId;
                                File[] attachInfo;
                                File aVmFolder = fileArray[i];
                                if (!aVmFolder.isDirectory() || userId != 0L && (long)dispatcher.getOwnerIdOf(aVmFolder) != userId || !(attachInfo = new File(aVmFolder, "attachInfo")).isFile()) continue;
                                Properties virtualMachine = new Properties();
                                FileInputStream inputStream = new FileInputStream((File)attachInfo);
                                try {
                                    virtualMachine.load(inputStream);
                                }
                                finally {
                                    inputStream.close();
                                }
                                int targetProcessId = Integer.parseInt(virtualMachine.getProperty("processId"));
                                try {
                                    targetUserId = Long.parseLong(virtualMachine.getProperty("userUid"));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    targetUserId = 0L;
                                }
                                if (userId != 0L && targetUserId == 0L) {
                                    targetUserId = dispatcher.getOwnerIdOf((File)attachInfo);
                                }
                                if ((long)targetProcessId == 0L || dispatcher.isExistingProcess(targetProcessId)) {
                                    virtualMachines.add(virtualMachine);
                                    continue;
                                }
                                if (userId != 0L && targetUserId != userId) continue;
                                File[] vmFile = aVmFolder.listFiles();
                                if (vmFile != null) {
                                    attachInfo = vmFile;
                                    targetProcessId = vmFile.length;
                                    for (int j = 0; j < targetProcessId; ++j) {
                                        File aVmFile = attachInfo[j];
                                        if (aVmFile.delete()) continue;
                                        aVmFile.deleteOnExit();
                                    }
                                }
                                if (aVmFolder.delete()) continue;
                                aVmFolder.deleteOnExit();
                            }
                        }
                        finally {
                            masterLock.release();
                        }
                    }
                    finally {
                        master.close();
                    }
                    Properties target = null;
                    for (Properties virtualMachine : virtualMachines) {
                        if (!virtualMachine.getProperty("processId").equalsIgnoreCase(processId)) continue;
                        target = virtualMachine;
                        break;
                    }
                    if (target == null) {
                        throw new IllegalStateException("Could not locate target process info in " + directory);
                    }
                    ServerSocket serverSocket = new ServerSocket(0);
                    try {
                        long targetUserId;
                        String key;
                        void var1_11;
                        serverSocket.setSoTimeout((int)var1_11);
                        File receiver = new File(directory, target.getProperty("vmId"));
                        SecureRandom secureRandom = SECURE_RANDOM;
                        synchronized (secureRandom) {
                            key = Long.toHexString(SECURE_RANDOM.nextLong());
                        }
                        File reply = new File(receiver, "replyInfo");
                        try {
                            targetUserId = Long.parseLong(target.getProperty("userUid"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            targetUserId = 0L;
                        }
                        try {
                            String answer;
                            Socket socket;
                            boolean global;
                            int notifications;
                            HashMap<RandomAccessFile, FileLock> locks;
                            block70: {
                                Object attachNotificationSync;
                                if (reply.createNewFile()) {
                                    dispatcher.setPermissions(reply, 384);
                                }
                                if (userId == 0L && targetUserId != 0L) {
                                    dispatcher.chownFileToUser(reply, targetUserId);
                                }
                                FileOutputStream outputStream = new FileOutputStream(reply);
                                try {
                                    outputStream.write(key.getBytes("UTF-8"));
                                    outputStream.write("\n".getBytes("UTF-8"));
                                    outputStream.write(Long.toString(serverSocket.getLocalPort()).getBytes("UTF-8"));
                                    outputStream.write("\n".getBytes("UTF-8"));
                                }
                                finally {
                                    outputStream.close();
                                }
                                locks = new HashMap<RandomAccessFile, FileLock>();
                                String pid2222 = Long.toString(dispatcher.pid());
                                for (Properties virtualMachine : virtualMachines) {
                                    if (virtualMachine.getProperty("processId").equalsIgnoreCase(pid2222)) continue;
                                    attachNotificationSync = virtualMachine.getProperty("attachNotificationSync");
                                    RandomAccessFile syncFile = new RandomAccessFile(attachNotificationSync == null ? new File(directory, "attachNotificationSync") : new File((String)attachNotificationSync), "rw");
                                    try {
                                        RandomAccessFile randomAccessFile = syncFile;
                                        locks.put(randomAccessFile, randomAccessFile.getChannel().lock());
                                    }
                                    catch (IOException iOException) {
                                        syncFile.close();
                                    }
                                }
                                notifications = 0;
                                File[] item = directory.listFiles();
                                if (item != null) {
                                    attachNotificationSync = item;
                                    int syncFile = item.length;
                                    for (int pid2222 = 0; pid2222 < syncFile; ++pid2222) {
                                        File file = attachNotificationSync[pid2222];
                                        String name = file.getName();
                                        if (name.startsWith(".trash_") || name.equalsIgnoreCase("_attachlock") || name.equalsIgnoreCase("_master") || name.equalsIgnoreCase("_notifier")) continue;
                                        ++notifications;
                                    }
                                }
                                global = Boolean.parseBoolean(target.getProperty("globalSemaphore"));
                                dispatcher.incrementSemaphore(directory, "_notifier", global, notifications);
                                socket = serverSocket.accept();
                                answer = new String(ForOpenJ9.read(socket), "UTF-8");
                                if (!answer.contains(" " + key + ' ')) break block70;
                                ForOpenJ9 forOpenJ9 = new ForOpenJ9(socket);
                                dispatcher.decrementSemaphore(directory, "_notifier", global, notifications);
                                for (Object entry : locks.entrySet()) {
                                    try {
                                        try {
                                            ((FileLock)entry.getValue()).release();
                                        }
                                        catch (Throwable throwable) {
                                            Object object;
                                            ((RandomAccessFile)object.getKey()).close();
                                            throw throwable;
                                        }
                                        ((RandomAccessFile)entry.getKey()).close();
                                    }
                                    catch (Throwable throwable) {
                                    }
                                }
                                return forOpenJ9;
                            }
                            try {
                                socket.close();
                                throw new IllegalStateException("Unexpected answered to attachment: " + answer);
                                {
                                    catch (Throwable throwable) {
                                        void var3_15;
                                        dispatcher.decrementSemaphore((File)var3_15, "_notifier", global, notifications);
                                        throw throwable;
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                for (Map.Entry entry : locks.entrySet()) {
                                    try {
                                        try {
                                            ((FileLock)entry.getValue()).release();
                                        }
                                        catch (Throwable throwable2) {
                                            void var2_14;
                                            ((RandomAccessFile)var2_14.getKey()).close();
                                            throw throwable2;
                                        }
                                        ((RandomAccessFile)entry.getKey()).close();
                                    }
                                    catch (Throwable throwable3) {
                                    }
                                }
                                throw throwable2;
                            }
                        }
                        finally {
                            if (!reply.delete()) {
                                reply.deleteOnExit();
                            }
                        }
                    }
                    finally {
                        serverSocket.close();
                    }
                }
                finally {
                    attachLockLock.release();
                }
            }
            finally {
                attachLock.close();
            }
        }

        /*
         * WARNING - void declaration
         */
        public Properties getSystemProperties() throws IOException {
            void var1_1;
            ForOpenJ9.write(this.socket, "ATTACH_GETSYSTEMPROPERTIES".getBytes("UTF-8"));
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(ForOpenJ9.read(this.socket)));
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Properties getAgentProperties() throws IOException {
            void var1_1;
            ForOpenJ9.write(this.socket, "ATTACH_GETAGENTPROPERTIES".getBytes("UTF-8"));
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(ForOpenJ9.read(this.socket)));
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void loadAgent(String jarFile, @MaybeNull String argument) throws IOException {
            void var2_2;
            ForOpenJ9.write(this.socket, ("ATTACH_LOADAGENT(instrument," + jarFile + '=' + (String)(argument == null ? "" : var2_2) + ')').getBytes("UTF-8"));
            String answer = new String(ForOpenJ9.read(this.socket), "UTF-8");
            if (answer.startsWith("ATTACH_ERR")) {
                throw new IllegalStateException("Target VM failed loading agent: " + answer);
            }
            if (!answer.startsWith("ATTACH_ACK") && !answer.startsWith("ATTACH_RESULT=")) {
                void var1_1;
                throw new IllegalStateException("Unexpected response: " + (String)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void loadAgentPath(String path, @MaybeNull String argument) throws IOException {
            void var2_2;
            ForOpenJ9.write(this.socket, ("ATTACH_LOADAGENTPATH(" + path + (argument == null ? "" : "," + (String)var2_2) + ')').getBytes("UTF-8"));
            String answer = new String(ForOpenJ9.read(this.socket), "UTF-8");
            if (answer.startsWith("ATTACH_ERR")) {
                throw new IllegalStateException("Target VM failed loading native agent: " + answer);
            }
            if (!answer.startsWith("ATTACH_ACK") && !answer.startsWith("ATTACH_RESULT=")) {
                void var1_1;
                throw new IllegalStateException("Unexpected response: " + (String)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void loadAgentLibrary(String library, @MaybeNull String argument) throws IOException {
            void var2_2;
            ForOpenJ9.write(this.socket, ("ATTACH_LOADAGENTLIBRARY(" + library + (argument == null ? "" : "," + (String)var2_2) + ')').getBytes("UTF-8"));
            String answer = new String(ForOpenJ9.read(this.socket), "UTF-8");
            if (answer.startsWith("ATTACH_ERR")) {
                throw new IllegalStateException("Target VM failed loading native library: " + answer);
            }
            if (!answer.startsWith("ATTACH_ACK") && !answer.startsWith("ATTACH_RESULT=")) {
                void var1_1;
                throw new IllegalStateException("Unexpected response: " + (String)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void startManagementAgent(Properties properties) throws IOException {
            void var2_2;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            properties.store(outputStream, null);
            ForOpenJ9.write(this.socket, "ATTACH_START_MANAGEMENT_AGENT".getBytes("UTF-8"));
            ForOpenJ9.write(this.socket, var2_2.toByteArray());
            String answer = new String(ForOpenJ9.read(this.socket), "UTF-8");
            if (answer.startsWith("ATTACH_ERR")) {
                throw new IllegalStateException("Target VM could not start management agent: " + answer);
            }
            if (!answer.startsWith("ATTACH_ACK") && !answer.startsWith("ATTACH_RESULT=")) {
                void var1_1;
                throw new IllegalStateException("Unexpected response: " + (String)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public String startLocalManagementAgent() throws IOException {
            void var1_1;
            ForOpenJ9.write(this.socket, "ATTACH_START_LOCAL_MANAGEMENT_AGENT".getBytes("UTF-8"));
            String answer = new String(ForOpenJ9.read(this.socket), "UTF-8");
            if (answer.startsWith("ATTACH_ERR")) {
                throw new IllegalStateException("Target VM could not start management agent: " + answer);
            }
            if (answer.startsWith("ATTACH_ACK")) {
                return answer.substring(10);
            }
            if (answer.startsWith("ATTACH_RESULT=")) {
                return answer.substring(14);
            }
            throw new IllegalStateException("Unexpected response: " + (String)var1_1);
        }

        public void detach() throws IOException {
            try {
                ForOpenJ9.write(this.socket, "ATTACH_DETACH".getBytes("UTF-8"));
                ForOpenJ9.read(this.socket);
                return;
            }
            finally {
                this.socket.close();
            }
        }

        /*
         * WARNING - void declaration
         */
        private static void write(Socket socket, byte[] value) throws IOException {
            Socket socket2;
            void var1_1;
            socket.getOutputStream().write((byte[])var1_1);
            socket.getOutputStream().write(0);
            socket2.getOutputStream().flush();
        }

        /*
         * WARNING - void declaration
         */
        private static byte[] read(Socket socket) throws IOException {
            void var1_1;
            int length;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = socket.getInputStream().read(buffer)) != -1) {
                void var3_3;
                if (length > 0 && buffer[length - 1] == 0) {
                    outputStream.write(buffer, 0, length - 1);
                    break;
                }
                outputStream.write(buffer, 0, (int)var3_3);
            }
            return var1_1.toByteArray();
        }

        public static interface Dispatcher {
            public String getTemporaryFolder(String var1);

            public int pid();

            public int userId();

            public boolean isExistingProcess(int var1);

            public int getOwnerIdOf(File var1);

            public void setPermissions(File var1, int var2);

            public void incrementSemaphore(File var1, String var2, boolean var3, int var4);

            public void decrementSemaphore(File var1, String var2, boolean var3, int var4);

            public void chownFileToUser(File var1, long var2);

            public static class ForJnaWindowsEnvironment
            implements Dispatcher {
                private static final int NO_USER_ID = 0;
                private static final String CREATION_MUTEX_NAME = "j9shsemcreationMutex";
                private final WindowsLibrary library = (WindowsLibrary)Native.loadLibrary((String)"kernel32", WindowsLibrary.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

                /*
                 * WARNING - void declaration
                 */
                public String getTemporaryFolder(String processId) {
                    void var2_2;
                    void var1_1;
                    WinDef.DWORD length = new WinDef.DWORD(260L);
                    char[] path = new char[length.intValue()];
                    if (Kernel32.INSTANCE.GetTempPath((WinDef.DWORD)var1_1, path).intValue() == 0) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    return Native.toString((char[])var2_2);
                }

                public int pid() {
                    return Kernel32.INSTANCE.GetCurrentProcessId();
                }

                public int userId() {
                    return 0;
                }

                /*
                 * WARNING - void declaration
                 */
                public boolean isExistingProcess(int processId) {
                    void var2_3;
                    void var1_2;
                    WinNT.HANDLE handle = Kernel32.INSTANCE.OpenProcess(1024, false, processId);
                    if (handle == null) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    IntByReference exists = new IntByReference();
                    if (!Kernel32.INSTANCE.GetExitCodeProcess((WinNT.HANDLE)var1_2, exists)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    return var2_3.getValue() == 259;
                }

                public int getOwnerIdOf(File file) {
                    return 0;
                }

                public void setPermissions(File file, int permissions) {
                }

                /*
                 * WARNING - void declaration
                 */
                public void incrementSemaphore(File directory, String name, boolean global, int count) {
                    void var3_4;
                    void var2_2;
                    AttachmentHandle handle = this.openSemaphore(directory, (String)var2_2, (boolean)var3_4);
                    try {
                        while (count-- > 0) {
                            if (this.library.ReleaseSemaphore(handle.getHandle(), 1L, null)) continue;
                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        }
                        handle.close();
                        return;
                    }
                    catch (Throwable throwable) {
                        void var1_1;
                        var1_1.close();
                        throw throwable;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void decrementSemaphore(File directory, String name, boolean global, int count) {
                    void var3_5;
                    AttachmentHandle handle = this.openSemaphore(directory, name, (boolean)var3_5);
                    try {
                        block7: while (count-- > 0) {
                            int result = Kernel32.INSTANCE.WaitForSingleObject(handle.getHandle(), 0);
                            switch (result) {
                                case 0: 
                                case 128: {
                                    continue block7;
                                }
                                case 258: {
                                    handle.close();
                                    return;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        void var1_1;
                        var1_1.close();
                        throw throwable;
                    }
                    {
                        void var2_3;
                        throw new Win32Exception((int)var2_3);
                    }
                    handle.close();
                }

                public void chownFileToUser(File file, long userId) {
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive exception aggregation
                 */
                private AttachmentHandle openSemaphore(File directory, String name, boolean global) {
                    AttachmentHandle attachmentHandle;
                    block24: {
                        void var2_5;
                        Object child;
                        WinNT.HANDLE mutex;
                        block22: {
                            block23: {
                                WinNT.SECURITY_DESCRIPTOR securityDescriptor = new WinNT.SECURITY_DESCRIPTOR(65536);
                                if (!Advapi32.INSTANCE.InitializeSecurityDescriptor(securityDescriptor, 1)) {
                                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                                }
                                if (!Advapi32.INSTANCE.SetSecurityDescriptorDacl(securityDescriptor, true, null, true)) {
                                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                                }
                                WindowsLibrary.SecurityAttributes securityAttributes = new WindowsLibrary.SecurityAttributes();
                                securityAttributes.length = new WinDef.DWORD((long)securityAttributes.size());
                                securityAttributes.securityDescriptor = securityDescriptor.getPointer();
                                mutex = this.library.CreateMutex(securityAttributes, false, CREATION_MUTEX_NAME);
                                if (mutex == null) {
                                    int lastError = Kernel32.INSTANCE.GetLastError();
                                    if (lastError == 183) {
                                        mutex = this.library.OpenMutex(0x1F0001, false, CREATION_MUTEX_NAME);
                                        if (mutex == null) {
                                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                                        }
                                    } else {
                                        throw new Win32Exception(lastError);
                                    }
                                }
                                int result = Kernel32.INSTANCE.WaitForSingleObject(mutex, 2000);
                                switch (result) {
                                    case -1: 
                                    case 258: {
                                        throw new Win32Exception(result);
                                    }
                                }
                                try {
                                    void var3_6;
                                    String target = (var3_6 != false ? "Global\\" : "") + (directory.getAbsolutePath() + '_' + name).replaceAll("[^a-zA-Z0-9_]", "") + "_semaphore";
                                    WinNT.HANDLE parent = this.library.OpenSemaphoreW(2031619, false, target);
                                    if (parent != null) break block22;
                                    parent = this.library.CreateSemaphoreW(null, 0L, Integer.MAX_VALUE, target);
                                    if (parent == null) {
                                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                                    }
                                    child = this.library.CreateSemaphoreW(null, 0L, Integer.MAX_VALUE, target + "_set0");
                                    if (child == null) {
                                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                                    }
                                    child = new AttachmentHandle(parent, (WinNT.HANDLE)child);
                                    if (this.library.ReleaseMutex(mutex)) break block23;
                                }
                                catch (Throwable throwable) {
                                    if (!this.library.ReleaseMutex(mutex)) {
                                        throw new Win32Exception(Native.getLastError());
                                    }
                                    throw throwable;
                                }
                                throw new Win32Exception(Native.getLastError());
                            }
                            return child;
                        }
                        child = this.library.OpenSemaphoreW(2031619, false, (String)child + "_set0");
                        if (child == null) {
                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        }
                        attachmentHandle = new AttachmentHandle((WinNT.HANDLE)var2_5, (WinNT.HANDLE)attachmentHandle);
                        if (this.library.ReleaseMutex(mutex)) break block24;
                        throw new Win32Exception(Native.getLastError());
                    }
                    return attachmentHandle;
                }

                protected static class AttachmentHandle
                implements Closeable {
                    private final WinNT.HANDLE parent;
                    private final WinNT.HANDLE child;

                    /*
                     * WARNING - void declaration
                     */
                    protected AttachmentHandle(WinNT.HANDLE parent, WinNT.HANDLE child) {
                        void var2_2;
                        void var1_1;
                        this.parent = var1_1;
                        this.child = var2_2;
                    }

                    protected WinNT.HANDLE getHandle() {
                        return this.child;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void close() {
                        void var1_1;
                        try {
                            if (!Kernel32.INSTANCE.CloseHandle(this.child)) {
                                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                            }
                        }
                        catch (Throwable closed) {
                            Kernel32.INSTANCE.CloseHandle(this.parent);
                            throw closed;
                        }
                        boolean closed = Kernel32.INSTANCE.CloseHandle(this.parent);
                        if (var1_1 == false) {
                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        }
                    }
                }

                protected static interface WindowsLibrary
                extends StdCallLibrary {
                    public static final int SEMAPHORE_ALL_ACCESS = 2031619;

                    @MaybeNull
                    public WinNT.HANDLE OpenSemaphoreW(int var1, boolean var2, String var3);

                    @MaybeNull
                    public WinNT.HANDLE CreateSemaphoreW(@MaybeNull WinBase.SECURITY_ATTRIBUTES var1, long var2, long var4, String var6);

                    public boolean ReleaseSemaphore(WinNT.HANDLE var1, long var2, @MaybeNull Long var4);

                    @MaybeNull
                    public WinNT.HANDLE CreateMutex(SecurityAttributes var1, boolean var2, String var3);

                    public WinNT.HANDLE OpenMutex(int var1, boolean var2, String var3);

                    public boolean ReleaseMutex(WinNT.HANDLE var1);

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field required by native implementation.")
                    public static class SecurityAttributes
                    extends Structure {
                        @MaybeNull
                        public WinDef.DWORD length;
                        @MaybeNull
                        public Pointer securityDescriptor;
                        public boolean inherit;

                        protected List<String> getFieldOrder() {
                            return Arrays.asList("length", "securityDescriptor", "inherit");
                        }
                    }
                }
            }

            public static class ForJnaPosixEnvironment
            implements Dispatcher {
                private final PosixLibrary library;
                private final PosixOwnerProvider provider;

                /*
                 * WARNING - void declaration
                 */
                public ForJnaPosixEnvironment(int attempts, long pause, TimeUnit timeUnit) {
                    void var2_2;
                    void var1_1;
                    this.provider = Platform.isAIX() ? new PosixOwnerProvider.UsingIStat(attempts, pause, timeUnit) : new PosixOwnerProvider.UsingStat((int)var1_1, (long)var2_2, timeUnit);
                    this.library = (PosixLibrary)Native.loadLibrary((String)"c", PosixLibrary.class);
                }

                /*
                 * WARNING - void declaration
                 */
                public String getTemporaryFolder(String processId) {
                    void var1_1;
                    File file;
                    if (Platform.isLinux() && (file = new File("/proc/" + processId + "/root/tmp")).isDirectory() && file.canRead()) {
                        return file.getAbsolutePath();
                    }
                    String temporaryFolder = System.getenv("TMPDIR");
                    if (temporaryFolder == null) {
                        return "/tmp";
                    }
                    return var1_1;
                }

                public int pid() {
                    return this.library.getpid();
                }

                public int userId() {
                    return this.library.getuid();
                }

                /*
                 * WARNING - void declaration
                 */
                public boolean isExistingProcess(int processId) {
                    void var1_1;
                    return this.library.kill((int)var1_1, 0) != 3;
                }

                /*
                 * WARNING - void declaration
                 */
                @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="The stream life-cycle is bound to its process.")
                public int getOwnerIdOf(File file) {
                    void var1_1;
                    return this.provider.getOwnerIdOf((File)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public void setPermissions(File file, int permissions) {
                    void var2_2;
                    void var1_1;
                    this.library.chmod(var1_1.getAbsolutePath(), (int)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                public void incrementSemaphore(File directory, String name, boolean global, int count) {
                    void var2_2;
                    void var1_1;
                    this.notifySemaphore((File)var1_1, (String)var2_2, count, (short)1, (short)0, false);
                }

                /*
                 * WARNING - void declaration
                 */
                public void decrementSemaphore(File directory, String name, boolean global, int count) {
                    void var2_2;
                    void var1_1;
                    this.notifySemaphore((File)var1_1, (String)var2_2, count, (short)-1, (short)6144, true);
                }

                /*
                 * WARNING - void declaration
                 */
                public void chownFileToUser(File file, long userId) {
                    void var2_2;
                    void var1_1;
                    this.library.chown(var1_1.getAbsolutePath(), (long)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="Modifier is required by JNA.")
                private void notifySemaphore(File directory, String name, int count, short operation, short flags, boolean acceptUnavailable) {
                    int semaphore = this.library.semget(this.library.ftok(new File(directory, name).getAbsolutePath(), 161), 2, 438);
                    PosixLibrary.SemaphoreOperation target = new PosixLibrary.SemaphoreOperation();
                    new PosixLibrary.SemaphoreOperation().operation = operation;
                    target.flags = flags;
                    while (count-- > 0) {
                        try {
                            this.library.semop(semaphore, target, 1);
                        }
                        catch (LastErrorException exception) {
                            void var1_3;
                            if (acceptUnavailable && (Native.getLastError() == 11 || Native.getLastError() == 35)) {
                                return;
                            }
                            throw var1_3;
                        }
                    }
                }

                protected static interface PosixOwnerProvider {
                    public int getOwnerIdOf(File var1);

                    public static class UsingIStat
                    implements PosixOwnerProvider {
                        private static final Pattern AIX_OWNER_PATTERN = Pattern.compile("Owner: (\\d+)\\(");
                        private final int attempts;
                        private final long pause;
                        private final TimeUnit timeUnit;

                        /*
                         * WARNING - void declaration
                         */
                        public UsingIStat(int attempts, long pause, TimeUnit timeUnit) {
                            void var2_2;
                            void var1_1;
                            this.attempts = var1_1;
                            this.pause = var2_2;
                            this.timeUnit = timeUnit;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public int getOwnerIdOf(File file) {
                            try {
                                void var3_4;
                                Process process = Runtime.getRuntime().exec(new String[]{"istat", file.getAbsolutePath()});
                                int attempts = this.attempts;
                                String lines = null;
                                while (true) {
                                    try {
                                        if (process.exitValue() != 0) {
                                            throw new IllegalStateException("Error while executing istat");
                                        }
                                        StringBuilder output = new StringBuilder();
                                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
                                        try {
                                            String line;
                                            while ((line = reader.readLine()) != null) {
                                                output.append(line).append("\n");
                                            }
                                        }
                                        finally {
                                            reader.close();
                                        }
                                        lines = output.toString();
                                    }
                                    catch (IllegalThreadStateException illegalThreadStateException) {
                                        try {
                                            Thread.sleep(this.timeUnit.toMillis(this.pause));
                                            continue;
                                        }
                                        catch (InterruptedException exception) {
                                            Thread.currentThread().interrupt();
                                            throw new IllegalStateException(exception);
                                        }
                                        if (--attempts > 0) continue;
                                    }
                                    break;
                                }
                                if (lines == null) {
                                    process.destroy();
                                    throw new IllegalStateException("Command for istat did not exit in time");
                                }
                                Matcher matcher = AIX_OWNER_PATTERN.matcher(lines);
                                if (matcher.find()) {
                                    return Integer.parseInt(matcher.group(1));
                                }
                                throw new IllegalStateException("Unable to parse response from istat command: " + (String)var3_4);
                            }
                            catch (IOException exception) {
                                void var1_2;
                                throw new IllegalStateException("Unable to execute istat command", (Throwable)var1_2);
                            }
                        }
                    }

                    public static class UsingStat
                    implements PosixOwnerProvider {
                        private final int attempts;
                        private final long pause;
                        private final TimeUnit timeUnit;

                        /*
                         * WARNING - void declaration
                         */
                        public UsingStat(int attempts, long pause, TimeUnit timeUnit) {
                            void var2_2;
                            void var1_1;
                            this.attempts = var1_1;
                            this.pause = var2_2;
                            this.timeUnit = timeUnit;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public int getOwnerIdOf(File file) {
                            try {
                                void var3_4;
                                Process process = Runtime.getRuntime().exec(new String[]{"stat", Platform.isMac() ? "-f" : "-c", "%u", file.getAbsolutePath()});
                                int attempts = this.attempts;
                                String line = null;
                                while (true) {
                                    try {
                                        if (process.exitValue() != 0) {
                                            throw new IllegalStateException("Error while executing stat");
                                        }
                                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
                                        try {
                                            line = reader.readLine();
                                        }
                                        finally {
                                            reader.close();
                                        }
                                    }
                                    catch (IllegalThreadStateException illegalThreadStateException) {
                                        try {
                                            Thread.sleep(this.timeUnit.toMillis(this.pause));
                                            continue;
                                        }
                                        catch (InterruptedException exception) {
                                            Thread.currentThread().interrupt();
                                            throw new IllegalStateException(exception);
                                        }
                                        if (--attempts > 0) continue;
                                    }
                                    break;
                                }
                                if (line == null) {
                                    process.destroy();
                                    throw new IllegalStateException("Command for stat did not exit in time");
                                }
                                return Integer.parseInt((String)var3_4);
                            }
                            catch (IOException exception) {
                                void var1_2;
                                throw new IllegalStateException("Unable to execute stat command", (Throwable)var1_2);
                            }
                        }
                    }
                }

                protected static interface PosixLibrary
                extends Library {
                    public static final int NULL_SIGNAL = 0;
                    public static final int ESRCH = 3;
                    public static final int EAGAIN = 11;
                    public static final int EDEADLK = 35;
                    public static final short SEM_UNDO = 4096;
                    public static final short IPC_NOWAIT = 2048;

                    public int getpid() throws LastErrorException;

                    public int getuid() throws LastErrorException;

                    public int kill(int var1, int var2) throws LastErrorException;

                    public int chmod(String var1, int var2) throws LastErrorException;

                    public int chown(String var1, long var2) throws LastErrorException;

                    public int ftok(String var1, int var2) throws LastErrorException;

                    public int semget(int var1, int var2, int var3) throws LastErrorException;

                    public int semop(int var1, SemaphoreOperation var2, int var3) throws LastErrorException;

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public static class SemaphoreOperation
                    extends Structure {
                        public short number;
                        public short operation;
                        public short flags;

                        protected List<String> getFieldOrder() {
                            return Arrays.asList("number", "operation", "flags");
                        }
                    }
                }
            }
        }
    }

    public static class ForHotSpot
    extends AbstractBase {
        private static final String PROTOCOL_VERSION = "1";
        private static final String LOAD_COMMAND = "load";
        private static final String INSTRUMENT_COMMAND = "instrument";
        private static final String ARGUMENT_DELIMITER = "=";
        private final Connection connection;

        /*
         * WARNING - void declaration
         */
        protected ForHotSpot(Connection connection) {
            void var1_1;
            this.connection = var1_1;
        }

        public static VirtualMachine attach(String processId) throws IOException {
            String string;
            if (Platform.isWindows()) {
                return ForHotSpot.attach(processId, new Connection.ForJnaWindowsNamedPipe.Factory());
            }
            if (Platform.isSolaris()) {
                return ForHotSpot.attach(processId, new Connection.ForJnaSolarisDoor.Factory(15, 100L, TimeUnit.MILLISECONDS));
            }
            return ForHotSpot.attach(string, Connection.ForJnaPosixSocket.Factory.withDefaultTemporaryFolder(15, 100L, TimeUnit.MILLISECONDS));
        }

        /*
         * WARNING - void declaration
         */
        public static VirtualMachine attach(String processId, Connection.Factory connectionFactory) throws IOException {
            String string;
            void var1_1;
            return new ForHotSpot(var1_1.connect(string));
        }

        /*
         * WARNING - void declaration
         */
        private static void checkHeader(Connection.Response response) throws IOException {
            void var2_2;
            int length;
            byte[] buffer = new byte[1];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((length = response.read(buffer)) != -1) {
                if (length <= 0) continue;
                if (buffer[0] == 10) break;
                outputStream.write(buffer[0]);
            }
            switch (Integer.parseInt(outputStream.toString("UTF-8"))) {
                case 0: {
                    return;
                }
                case 101: {
                    throw new IOException("Protocol mismatch with target VM");
                }
            }
            buffer = new byte[1024];
            outputStream = new ByteArrayOutputStream();
            while ((length = response.read(buffer)) != -1) {
                void var3_3;
                outputStream.write(buffer, 0, (int)var3_3);
            }
            throw new IllegalStateException(var2_2.toString("UTF-8"));
        }

        public Properties getSystemProperties() throws IOException {
            return this.getProperties("properties");
        }

        public Properties getAgentProperties() throws IOException {
            return this.getProperties("agentProperties");
        }

        /*
         * WARNING - void declaration
         */
        private Properties getProperties(String command) throws IOException {
            void var2_2;
            Connection.Response response = this.connection.execute(PROTOCOL_VERSION, command, null, null, null);
            try {
                void var3_4;
                int length;
                ForHotSpot.checkHeader(response);
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                while ((length = response.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, length);
                }
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(var3_4.toByteArray()));
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            response.close();
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void loadAgent(String jarFile, @MaybeNull String argument) throws IOException {
            void var2_2;
            void var1_1;
            this.load((String)var1_1, false, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void loadAgentPath(String path, @MaybeNull String argument) throws IOException {
            void var2_2;
            void var1_1;
            this.load((String)var1_1, true, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void loadAgentLibrary(String library, @MaybeNull String argument) throws IOException {
            void var2_2;
            void var1_1;
            this.load((String)var1_1, false, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        protected void load(String file, boolean absolute, @MaybeNull String argument) throws IOException {
            void var3_4;
            void var2_2;
            Connection.Response response = this.connection.execute(PROTOCOL_VERSION, LOAD_COMMAND, INSTRUMENT_COMMAND, Boolean.toString((boolean)var2_2), argument == null ? file : file + ARGUMENT_DELIMITER + (String)var3_4);
            try {
                ForHotSpot.checkHeader(response);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            response.close();
        }

        /*
         * WARNING - void declaration
         */
        public void startManagementAgent(Properties properties) throws IOException {
            void var2_2;
            StringBuilder stringBuilder = new StringBuilder("ManagementAgent.start ");
            boolean first = true;
            for (Map.Entry<Object, Object> entry : ((Properties)((Object)properties)).entrySet()) {
                if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith("com.sun.management.")) {
                    throw new IllegalArgumentException("Illegal property name: " + entry.getKey());
                }
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(((String)entry.getKey()).substring(19)).append('=');
                String string = entry.getValue().toString();
                if (string.contains(" ")) {
                    stringBuilder.append('\'').append(string).append('\'');
                    continue;
                }
                stringBuilder.append(string);
            }
            Connection.Response response = this.connection.execute(PROTOCOL_VERSION, "jcmd", var2_2.toString(), null, null);
            try {
                ForHotSpot.checkHeader(response);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            response.close();
        }

        /*
         * WARNING - void declaration
         */
        public String startLocalManagementAgent() throws IOException {
            String string;
            Connection.Response response = this.connection.execute(PROTOCOL_VERSION, "jcmd", "ManagementAgent.start_local", null, null);
            try {
                ForHotSpot.checkHeader(response);
                string = this.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            response.close();
            return string;
        }

        public void detach() throws IOException {
            this.connection.close();
        }

        public static interface Connection
        extends Closeable {
            public Response execute(String var1, String ... var2) throws IOException;

            public static class ForJnaSolarisDoor
            implements Connection {
                private final SolarisLibrary library;
                private final File socket;

                /*
                 * WARNING - void declaration
                 */
                protected ForJnaSolarisDoor(SolarisLibrary library, File socket) {
                    void var2_2;
                    void var1_1;
                    this.library = var1_1;
                    this.socket = var2_2;
                }

                /*
                 * Exception decompiling
                 */
                @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="This pattern is required for use of JNA.")
                public net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Response execute(String protocol, String ... argument) throws IOException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public void close() {
                }

                public static class Factory
                extends Factory.ForSocketFile {
                    private final SolarisLibrary library = (SolarisLibrary)Native.loadLibrary((String)"c", SolarisLibrary.class);

                    /*
                     * WARNING - void declaration
                     */
                    public Factory(int attempts, long pause, TimeUnit timeUnit) {
                        super("/tmp", (int)var1_1, (long)var2_2, timeUnit);
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected void kill(String processId, int signal) {
                        void var2_2;
                        void var1_1;
                        this.library.kill(Integer.parseInt((String)var1_1), (int)var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected Connection doConnect(File socket) {
                        void var1_1;
                        return new ForJnaSolarisDoor(this.library, (File)var1_1);
                    }
                }

                protected static class Response
                implements net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Response {
                    private final SolarisLibrary library;
                    private final int handle;

                    /*
                     * WARNING - void declaration
                     */
                    protected Response(SolarisLibrary library, int handle) {
                        void var2_2;
                        void var1_1;
                        this.library = var1_1;
                        this.handle = var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public int read(byte[] buffer) {
                        void var1_2;
                        int read = this.library.read(this.handle, ByteBuffer.wrap(buffer), buffer.length);
                        if (read == 0) {
                            return -1;
                        }
                        return (int)var1_2;
                    }

                    public void close() {
                        this.library.close(this.handle);
                    }
                }

                protected static interface SolarisLibrary
                extends Library {
                    public int kill(int var1, int var2) throws LastErrorException;

                    public int open(String var1, int var2) throws LastErrorException;

                    public int read(int var1, ByteBuffer var2, int var3) throws LastErrorException;

                    public int close(int var1) throws LastErrorException;

                    public int door_call(int var1, DoorArgument var2) throws LastErrorException;

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public static class DoorArgument
                    extends Structure {
                        @MaybeNull
                        public Pointer dataPointer;
                        public int dataSize;
                        @MaybeNull
                        public Pointer descriptorPointer;
                        public int descriptorCount;
                        @UnknownNull
                        public Pointer resultPointer;
                        public int resultSize;

                        protected List<String> getFieldOrder() {
                            return Arrays.asList("dataPointer", "dataSize", "descriptorPointer", "descriptorCount", "resultPointer", "resultSize");
                        }
                    }
                }
            }

            public static class ForJnaWindowsNamedPipe
            implements Connection {
                private static final int MEM_RELEASE = 32768;
                private final WindowsLibrary library;
                private final WindowsAttachLibrary attachLibrary;
                private final WinNT.HANDLE process;
                private final WinDef.LPVOID code;
                private final SecureRandom random;

                /*
                 * WARNING - void declaration
                 */
                protected ForJnaWindowsNamedPipe(WindowsLibrary library, WindowsAttachLibrary attachLibrary, WinNT.HANDLE process, WinDef.LPVOID code) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.library = var1_1;
                    this.attachLibrary = var2_2;
                    this.process = var3_3;
                    this.code = code;
                    this.random = new SecureRandom();
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive exception aggregation
                 */
                public Response execute(String protocol, String ... argument) {
                    WinBase.SECURITY_ATTRIBUTES sa;
                    if (!ForHotSpot.PROTOCOL_VERSION.equals(protocol)) {
                        throw new IllegalArgumentException("Unknown protocol version: " + protocol);
                    }
                    if (argument.length > 4) {
                        throw new IllegalArgumentException("Cannot supply more then four arguments to Windows attach mechanism: " + Arrays.asList(argument));
                    }
                    String name = "\\\\.\\pipe\\javatool" + Math.abs(this.random.nextInt() + 1);
                    WinNT.HANDLE pipe = Kernel32.INSTANCE.CreateNamedPipe(name, 1, 0, 1, 4096, 8192, 0, sa = this.createSecurityAttributesToAllowMediumIntegrity());
                    if (pipe == null) {
                        throw new Win32Exception(Native.getLastError());
                    }
                    try {
                        WinDef.LPVOID data = this.attachLibrary.allocate_remote_argument(this.process, name, argument.length <= 0 ? null : argument[0], argument.length < 2 ? null : argument[1], argument.length < 3 ? null : argument[2], argument.length < 4 ? null : argument[3]);
                        if (data == null) {
                            throw new Win32Exception(Native.getLastError());
                        }
                        try {
                            NamedPipeResponse namedPipeResponse;
                            WinNT.HANDLE thread = this.library.CreateRemoteThread(this.process, null, 0, this.code.getPointer(), data.getPointer(), null, null);
                            if (thread == null) {
                                throw new Win32Exception(Native.getLastError());
                            }
                            try {
                                int code;
                                int result = Kernel32.INSTANCE.WaitForSingleObject(thread, -1);
                                if (result != 0) {
                                    throw new Win32Exception(result);
                                }
                                IntByReference exitCode = new IntByReference();
                                if (!this.library.GetExitCodeThread(thread, exitCode)) {
                                    throw new Win32Exception(Native.getLastError());
                                }
                                if (exitCode.getValue() != 0) {
                                    throw new IllegalStateException("Target VM could not dispatch command successfully: " + exitCode.getValue());
                                }
                                if (!Kernel32.INSTANCE.ConnectNamedPipe(pipe, null) && (code = Native.getLastError()) != 535) {
                                    throw new Win32Exception(code);
                                }
                                namedPipeResponse = new NamedPipeResponse(pipe);
                            }
                            catch (Throwable throwable) {
                                void var2_3;
                                if (!Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var2_3)) {
                                    throw new Win32Exception(Native.getLastError());
                                }
                                throw throwable;
                            }
                            if (!Kernel32.INSTANCE.CloseHandle(thread)) {
                                throw new Win32Exception(Native.getLastError());
                            }
                            return namedPipeResponse;
                        }
                        finally {
                            if (!this.library.VirtualFreeEx(this.process, data.getPointer(), 0, 32768)) {
                                throw new Win32Exception(Native.getLastError());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        void var1_2;
                        void var3_5;
                        if (!Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var3_5)) {
                            throw new Win32Exception(Native.getLastError());
                        }
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        throw new IllegalStateException((Throwable)var1_2);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private WinBase.SECURITY_ATTRIBUTES createSecurityAttributesToAllowMediumIntegrity() {
                    void var2_2;
                    void var1_1;
                    void var3_3;
                    WinNT.PSID pSidEverybody = new WinNT.PSID(68);
                    if (!Advapi32.INSTANCE.CreateWellKnownSid(1, null, pSidEverybody, new IntByReference(68))) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    WinNT.PSID pSidSystem = new WinNT.PSID(68);
                    if (!Advapi32.INSTANCE.CreateWellKnownSid(31, null, pSidSystem, new IntByReference(68))) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    WinNT.PSID pSidAdmin = new WinNT.PSID(68);
                    if (!Advapi32.INSTANCE.CreateWellKnownSid(26, null, pSidAdmin, new IntByReference(68))) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    int n = Native.getNativeSize(WinNT.ACL.class, null);
                    n += Native.getNativeSize(WinNT.ACCESS_ALLOWED_ACE.class, null) * 3;
                    n += Advapi32.INSTANCE.GetLengthSid(pSidEverybody) - 4;
                    n += Advapi32.INSTANCE.GetLengthSid(pSidSystem) - 4;
                    int cbAcl = Advapi32Util.alignOnDWORD((int)(n += Advapi32.INSTANCE.GetLengthSid(pSidAdmin) - 4));
                    WinNT.ACL pAcl = new WinNT.ACL(cbAcl);
                    if (!Advapi32.INSTANCE.InitializeAcl(pAcl, cbAcl, 2)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    if (!Advapi32.INSTANCE.AddAccessAllowedAce(pAcl, 2, -1073741824, pSidEverybody)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    if (!Advapi32.INSTANCE.AddAccessAllowedAce(pAcl, 2, 0x10000000, pSidSystem)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    if (!Advapi32.INSTANCE.AddAccessAllowedAce(pAcl, 2, 0x10000000, (WinNT.PSID)var3_3)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    WinNT.SECURITY_DESCRIPTOR sd = new WinNT.SECURITY_DESCRIPTOR(65536);
                    if (!Advapi32.INSTANCE.InitializeSecurityDescriptor(sd, 1)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    if (!Advapi32.INSTANCE.SetSecurityDescriptorDacl(sd, true, pAcl, false)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    WinBase.SECURITY_ATTRIBUTES sa = new WinBase.SECURITY_ATTRIBUTES();
                    new WinBase.SECURITY_ATTRIBUTES().dwLength = new WinDef.DWORD((long)sa.size());
                    sa.lpSecurityDescriptor = var1_1.getPointer();
                    return var2_2;
                }

                public void close() {
                    try {
                        if (!this.library.VirtualFreeEx(this.process, this.code.getPointer(), 0, 32768)) {
                            throw new Win32Exception(Native.getLastError());
                        }
                    }
                    finally {
                        if (!Kernel32.INSTANCE.CloseHandle(this.process)) {
                            throw new Win32Exception(Native.getLastError());
                        }
                    }
                }

                public static class Factory
                implements net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Factory {
                    public static final String LIBRARY_NAME = "net.bytebuddy.library.name";
                    private final WindowsLibrary library = (WindowsLibrary)Native.loadLibrary((String)"kernel32", WindowsLibrary.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                    private final WindowsAttachLibrary attachLibrary = (WindowsAttachLibrary)Native.loadLibrary((String)System.getProperty("net.bytebuddy.library.name", "attach_hotspot_windows"), WindowsAttachLibrary.class);

                    /*
                     * WARNING - void declaration
                     */
                    public Connection connect(String processId) {
                        WinNT.HANDLE process = Kernel32.INSTANCE.OpenProcess(0x1F1FFB, false, Integer.parseInt(processId));
                        if (process == null) {
                            throw new Win32Exception(Native.getLastError());
                        }
                        try {
                            WinDef.LPVOID code = this.attachLibrary.allocate_remote_code(process);
                            if (code == null) {
                                throw new Win32Exception(Native.getLastError());
                            }
                            return new ForJnaWindowsNamedPipe(this.library, this.attachLibrary, process, code);
                        }
                        catch (Throwable throwable) {
                            void var2_3;
                            void var1_1;
                            if (!Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var1_1)) {
                                throw new Win32Exception(Native.getLastError());
                            }
                            if (throwable instanceof RuntimeException) {
                                throw (RuntimeException)throwable;
                            }
                            throw new IllegalStateException((Throwable)var2_3);
                        }
                    }
                }

                protected static class NamedPipeResponse
                implements Response {
                    private final WinNT.HANDLE pipe;

                    /*
                     * WARNING - void declaration
                     */
                    protected NamedPipeResponse(WinNT.HANDLE pipe) {
                        void var1_1;
                        this.pipe = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public int read(byte[] buffer) {
                        void var2_3;
                        IntByReference read = new IntByReference();
                        if (!Kernel32.INSTANCE.ReadFile(this.pipe, buffer, buffer.length, read, null)) {
                            void var1_2;
                            int code = Native.getLastError();
                            if (code == 109) {
                                return -1;
                            }
                            throw new Win32Exception((int)var1_2);
                        }
                        return var2_3.getValue();
                    }

                    public void close() {
                        try {
                            if (!Kernel32.INSTANCE.DisconnectNamedPipe(this.pipe)) {
                                throw new Win32Exception(Native.getLastError());
                            }
                        }
                        finally {
                            if (!Kernel32.INSTANCE.CloseHandle(this.pipe)) {
                                throw new Win32Exception(Native.getLastError());
                            }
                        }
                    }
                }

                protected static interface WindowsAttachLibrary
                extends StdCallLibrary {
                    @MaybeNull
                    public WinDef.LPVOID allocate_remote_code(WinNT.HANDLE var1);

                    @MaybeNull
                    public WinDef.LPVOID allocate_remote_argument(WinNT.HANDLE var1, String var2, @MaybeNull String var3, @MaybeNull String var4, @MaybeNull String var5, @MaybeNull String var6);
                }

                protected static interface WindowsLibrary
                extends StdCallLibrary {
                    public Pointer VirtualAllocEx(WinNT.HANDLE var1, Pointer var2, int var3, int var4, int var5);

                    public boolean VirtualFreeEx(WinNT.HANDLE var1, Pointer var2, int var3, int var4);

                    @MaybeNull
                    public WinNT.HANDLE CreateRemoteThread(WinNT.HANDLE var1, @MaybeNull WinBase.SECURITY_ATTRIBUTES var2, int var3, Pointer var4, Pointer var5, @MaybeNull WinDef.DWORD var6, @MaybeNull Pointer var7);

                    public boolean GetExitCodeThread(WinNT.HANDLE var1, IntByReference var2);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class ForJnaPosixSocket
            extends OnPersistentByteChannel<Integer> {
                private final PosixLibrary library;
                private final File socket;

                /*
                 * WARNING - void declaration
                 */
                protected ForJnaPosixSocket(PosixLibrary library, File socket) {
                    void var2_2;
                    void var1_1;
                    this.library = var1_1;
                    this.socket = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected Integer connect() {
                    int handle = this.library.socket(1, 1, 0);
                    Object address22 = new PosixLibrary.SocketAddress();
                    try {
                        address22.setPath(this.socket.getAbsolutePath());
                        PosixLibrary.SocketAddress socketAddress = address22;
                        this.library.connect(handle, socketAddress, socketAddress.size());
                        address22 = handle;
                        return address22;
                    }
                    catch (Throwable address22) {
                        try {
                            throw address22;
                        }
                        catch (RuntimeException exception) {
                            void var2_4;
                            void var1_1;
                            this.library.close((int)var1_1);
                            throw var2_4;
                        }
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected int read(Integer handle, byte[] buffer) {
                    void var1_2;
                    void var2_3;
                    int read = this.library.read(handle, ByteBuffer.wrap(buffer), ((void)var2_3).length);
                    if (read == 0) {
                        return -1;
                    }
                    return (int)var1_2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void write(Integer handle, byte[] buffer) {
                    void var2_2;
                    void var1_1;
                    this.library.write(var1_1.intValue(), ByteBuffer.wrap(buffer), ((void)var2_2).length);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void close(Integer handle) {
                    void var1_1;
                    this.library.close(var1_1.intValue());
                }

                @Override
                public void close() {
                }

                public static class Factory
                extends Factory.ForSocketFile {
                    private final PosixLibrary library = (PosixLibrary)Native.loadLibrary((String)"c", PosixLibrary.class);

                    /*
                     * WARNING - void declaration
                     */
                    public Factory(String temporaryDirectory, int attempts, long pause, TimeUnit timeUnit) {
                        super((String)var1_1, (int)var2_2, (long)var3_3, timeUnit);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public static net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Factory withDefaultTemporaryFolder(int attempts, long pause, TimeUnit timeUnit) {
                        void var3_3;
                        void var1_2;
                        int n;
                        String temporaryDirectory;
                        if (Platform.isMac()) {
                            MacLibrary library = (MacLibrary)Native.loadLibrary((String)"c", MacLibrary.class);
                            Memory memory = new Memory(4096L);
                            Memory memory2 = memory;
                            long length = library.confstr(65537, (Pointer)memory2, memory2.size());
                            if (length == 0L || length > 4096L) {
                                temporaryDirectory = "/tmp";
                            }
                            temporaryDirectory = memory.getString(0L);
                        } else {
                            temporaryDirectory = "/tmp";
                        }
                        return new Factory(temporaryDirectory, n, (long)var1_2, (TimeUnit)var3_3);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected void kill(String processId, int signal) {
                        void var2_2;
                        void var1_1;
                        this.library.kill(Integer.parseInt((String)var1_1), (int)var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Connection doConnect(File socket) {
                        void var1_1;
                        return new ForJnaPosixSocket(this.library, (File)var1_1);
                    }

                    public static interface MacLibrary
                    extends Library {
                        public static final int CS_DARWIN_USER_TEMP_DIR = 65537;

                        public long confstr(int var1, Pointer var2, long var3);
                    }
                }

                protected static interface PosixLibrary
                extends Library {
                    public int kill(int var1, int var2) throws LastErrorException;

                    public int socket(int var1, int var2, int var3) throws LastErrorException;

                    public int connect(int var1, SocketAddress var2, int var3) throws LastErrorException;

                    public int read(int var1, ByteBuffer var2, int var3) throws LastErrorException;

                    public int write(int var1, ByteBuffer var2, int var3) throws LastErrorException;

                    public int close(int var1) throws LastErrorException;

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public static class SocketAddress
                    extends Structure {
                        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field required by native implementation.")
                        public short family = 1;
                        public byte[] path = new byte[100];

                        /*
                         * WARNING - void declaration
                         */
                        protected void setPath(String path) {
                            try {
                                System.arraycopy(path.getBytes("UTF-8"), 0, this.path, 0, path.length());
                                System.arraycopy(new byte[]{0}, 0, this.path, path.length(), 1);
                                return;
                            }
                            catch (UnsupportedEncodingException exception) {
                                void var1_2;
                                throw new IllegalStateException((Throwable)var1_2);
                            }
                        }

                        protected List<String> getFieldOrder() {
                            return Arrays.asList("family", "path");
                        }
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static abstract class OnPersistentByteChannel<T>
            implements Connection {
                private static final byte[] BLANK = new byte[]{0};

                /*
                 * WARNING - void declaration
                 */
                @Override
                public net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Response execute(String protocol, String ... argument) throws IOException {
                    T connection = this.connect();
                    try {
                        void var2_3;
                        this.write(connection, protocol.getBytes("UTF-8"));
                        this.write(connection, BLANK);
                        for (String anArgument : var2_3) {
                            if (anArgument != null) {
                                this.write(connection, anArgument.getBytes("UTF-8"));
                            }
                            this.write(connection, BLANK);
                        }
                        return new Response(connection);
                    }
                    catch (Throwable throwable) {
                        void var1_2;
                        void var3_5;
                        this.close(var3_5);
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        if (throwable instanceof IOException) {
                            throw (IOException)throwable;
                        }
                        throw new IllegalStateException((Throwable)var1_2);
                    }
                }

                protected abstract T connect() throws IOException;

                protected abstract void close(T var1) throws IOException;

                protected abstract void write(T var1, byte[] var2) throws IOException;

                protected abstract int read(T var1, byte[] var2) throws IOException;

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                private class Response
                implements net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Response {
                    private final T connection;

                    /*
                     * WARNING - void declaration
                     */
                    private Response(T connection) {
                        void var2_2;
                        this.connection = var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int read(byte[] buffer) throws IOException {
                        void var1_1;
                        return OnPersistentByteChannel.this.read(this.connection, (byte[])var1_1);
                    }

                    @Override
                    public void close() throws IOException {
                        OnPersistentByteChannel.this.close(this.connection);
                    }
                }
            }

            public static interface Factory {
                public Connection connect(String var1) throws IOException;

                public static abstract class ForSocketFile
                implements Factory {
                    private static final String SOCKET_FILE_PREFIX = ".java_pid";
                    private static final String ATTACH_FILE_PREFIX = ".attach_pid";
                    private final String temporaryDirectory;
                    private final int attempts;
                    private final long pause;
                    private final TimeUnit timeUnit;

                    /*
                     * WARNING - void declaration
                     */
                    protected ForSocketFile(String temporaryDirectory, int attempts, long pause, TimeUnit timeUnit) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.temporaryDirectory = var1_1;
                        this.attempts = var2_2;
                        this.pause = var3_3;
                        this.timeUnit = timeUnit;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="File name convention is specified.")
                    public Connection connect(String processId) throws IOException {
                        void var2_3;
                        File socket = new File(this.temporaryDirectory, SOCKET_FILE_PREFIX + processId);
                        if (!socket.exists()) {
                            File attachFile;
                            block12: {
                                String target = ATTACH_FILE_PREFIX + processId;
                                String path = "/proc/" + processId + "/cwd/" + target;
                                attachFile = new File(path);
                                try {
                                    if (!attachFile.createNewFile() && !attachFile.isFile()) {
                                        throw new IllegalStateException("Could not create attach file: " + attachFile);
                                    }
                                }
                                catch (IOException iOException) {
                                    attachFile = new File(this.temporaryDirectory, target);
                                    if (attachFile.createNewFile() || attachFile.isFile()) break block12;
                                    throw new IllegalStateException("Could not create attach file: " + attachFile);
                                }
                            }
                            try {
                                this.kill(processId, 3);
                                int attempts = this.attempts;
                                while (!socket.exists() && attempts-- > 0) {
                                    this.timeUnit.sleep(this.pause);
                                }
                                if (!socket.exists()) {
                                    void var1_1;
                                    throw new IllegalStateException("Target VM did not respond: " + (String)var1_1);
                                }
                            }
                            catch (InterruptedException exception) {
                                void var3_6;
                                Thread.currentThread().interrupt();
                                throw new IllegalStateException((Throwable)var3_6);
                            }
                            finally {
                                if (!attachFile.delete()) {
                                    attachFile.deleteOnExit();
                                }
                            }
                        }
                        return this.doConnect((File)var2_3);
                    }

                    protected abstract void kill(String var1, int var2);

                    protected abstract Connection doConnect(File var1) throws IOException;
                }
            }

            public static interface Response
            extends Closeable {
                public int read(byte[] var1) throws IOException;
            }
        }
    }

    public static abstract class AbstractBase
    implements VirtualMachine {
        /*
         * WARNING - void declaration
         */
        public void loadAgent(String jarFile) throws IOException {
            void var1_1;
            this.loadAgent((String)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        public void loadAgentPath(String path) throws IOException {
            void var1_1;
            this.loadAgentPath((String)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        public void loadAgentLibrary(String library) throws IOException {
            void var1_1;
            this.loadAgentLibrary((String)var1_1, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Resolver implements PrivilegedAction<Class<? extends VirtualMachine>>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final Class<? extends VirtualMachine> run() {
            try {
                Class.forName("com.sun.jna.Platform");
            }
            catch (ClassNotFoundException exception) {
                void var1_1;
                throw new IllegalStateException("Optional JNA dependency is not available", (Throwable)var1_1);
            }
            if (System.getProperty("java.vm.name", "").toUpperCase(Locale.US).contains("J9")) {
                return ForOpenJ9.class;
            }
            return ForHotSpot.class;
        }
    }
}

