/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import net.bytebuddy.agent.Attacher;
import net.bytebuddy.agent.Installer;
import net.bytebuddy.agent.VirtualMachine;
import net.bytebuddy.agent.utility.nullability.AlwaysNull;
import net.bytebuddy.agent.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBuddyAgent {
    public static final String LATENT_RESOLVE = "net.bytebuddy.agent.latent";
    private static final String AGENT_CLASS_PROPERTY = "Agent-Class";
    private static final String CAN_REDEFINE_CLASSES_PROPERTY = "Can-Redefine-Classes";
    private static final String CAN_RETRANSFORM_CLASSES_PROPERTY = "Can-Retransform-Classes";
    private static final String CAN_SET_NATIVE_METHOD_PREFIX = "Can-Set-Native-Method-Prefix";
    private static final String MANIFEST_VERSION_VALUE = "1.0";
    @AlwaysNull
    private static final ClassLoader BOOTSTRAP_CLASS_LOADER = null;
    @AlwaysNull
    private static final String WITHOUT_ARGUMENT = null;
    private static final String ATTACHER_FILE_NAME = "byteBuddyAttacher";
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String CLASS_PATH_ARGUMENT = "-cp";
    private static final String AGENT_ARGUMENT_SEPARATOR = "=";
    private static final String JAVA_HOME = "java.home";
    private static final String OS_NAME = "os.name";
    private static final AttachmentTypeEvaluator ATTACHMENT_TYPE_EVALUATOR = ByteBuddyAgent.doPrivileged(AttachmentTypeEvaluator.InstallationAction.INSTANCE);

    private ByteBuddyAgent() {
        throw new UnsupportedOperationException("This class is a utility class and not supposed to be instantiated");
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        try {
            return (T)Class.forName("java.security.AccessController").getMethod("doPrivileged", PrivilegedAction.class).invoke(null, action);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return action.run();
        }
        catch (InvocationTargetException exception) {
            throw new IllegalStateException("Failed to invoke access controller", exception.getTargetException());
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("Failed to access access controller", exception);
        }
        catch (NoSuchMethodException exception) {
            void var0_3;
            throw new IllegalStateException("Failed to resolve well-known access controller method", (Throwable)var0_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Instrumentation getInstrumentation() {
        void var0;
        Instrumentation instrumentation = ByteBuddyAgent.doGetInstrumentation();
        if (instrumentation == null) {
            throw new IllegalStateException("The Byte Buddy agent is not initialized or unavailable");
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static void attach(File agentJar, String processId) {
        void var1_1;
        ByteBuddyAgent.attach(agentJar, (String)var1_1, WITHOUT_ARGUMENT);
    }

    /*
     * WARNING - void declaration
     */
    public static void attach(File agentJar, String processId, @MaybeNull String argument) {
        void var2_2;
        void var1_1;
        ByteBuddyAgent.attach(agentJar, (String)var1_1, (String)var2_2, AttachmentProvider.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public static void attach(File agentJar, String processId, AttachmentProvider attachmentProvider) {
        void var2_2;
        void var1_1;
        ByteBuddyAgent.attach(agentJar, (String)var1_1, WITHOUT_ARGUMENT, (AttachmentProvider)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void attach(File agentJar, String processId, @MaybeNull String argument, AttachmentProvider attachmentProvider) {
        File file;
        void var2_2;
        void var1_1;
        ByteBuddyAgent.install(attachmentProvider, (String)var1_1, (String)var2_2, new AgentProvider.ForExistingAgent(file), false);
    }

    /*
     * WARNING - void declaration
     */
    public static void attach(File agentJar, ProcessProvider processProvider) {
        void var1_1;
        ByteBuddyAgent.attach(agentJar, (ProcessProvider)var1_1, WITHOUT_ARGUMENT);
    }

    /*
     * WARNING - void declaration
     */
    public static void attach(File agentJar, ProcessProvider processProvider, @MaybeNull String argument) {
        void var2_2;
        void var1_1;
        ByteBuddyAgent.attach(agentJar, (ProcessProvider)var1_1, (String)var2_2, AttachmentProvider.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public static void attach(File agentJar, ProcessProvider processProvider, AttachmentProvider attachmentProvider) {
        void var2_2;
        void var1_1;
        ByteBuddyAgent.attach(agentJar, (ProcessProvider)var1_1, WITHOUT_ARGUMENT, (AttachmentProvider)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void attach(File agentJar, ProcessProvider processProvider, @MaybeNull String argument, AttachmentProvider attachmentProvider) {
        File file;
        void var2_2;
        void var1_1;
        ByteBuddyAgent.install(attachmentProvider, var1_1.resolve(), (String)var2_2, new AgentProvider.ForExistingAgent(file), false);
    }

    /*
     * WARNING - void declaration
     */
    public static void attachNative(File agentLibrary, String processId) {
        void var1_1;
        ByteBuddyAgent.attachNative(agentLibrary, (String)var1_1, WITHOUT_ARGUMENT);
    }

    /*
     * WARNING - void declaration
     */
    public static void attachNative(File agentLibrary, String processId, @MaybeNull String argument) {
        void var2_2;
        void var1_1;
        ByteBuddyAgent.attachNative(agentLibrary, (String)var1_1, (String)var2_2, AttachmentProvider.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public static void attachNative(File agentLibrary, String processId, AttachmentProvider attachmentProvider) {
        void var2_2;
        void var1_1;
        ByteBuddyAgent.attachNative(agentLibrary, (String)var1_1, WITHOUT_ARGUMENT, (AttachmentProvider)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void attachNative(File agentLibrary, String processId, @MaybeNull String argument, AttachmentProvider attachmentProvider) {
        File file;
        void var2_2;
        void var1_1;
        ByteBuddyAgent.install(attachmentProvider, (String)var1_1, (String)var2_2, new AgentProvider.ForExistingAgent(file), true);
    }

    /*
     * WARNING - void declaration
     */
    public static void attachNative(File agentLibrary, ProcessProvider processProvider) {
        void var1_1;
        ByteBuddyAgent.attachNative(agentLibrary, (ProcessProvider)var1_1, WITHOUT_ARGUMENT);
    }

    /*
     * WARNING - void declaration
     */
    public static void attachNative(File agentLibrary, ProcessProvider processProvider, @MaybeNull String argument) {
        void var2_2;
        void var1_1;
        ByteBuddyAgent.attachNative(agentLibrary, (ProcessProvider)var1_1, (String)var2_2, AttachmentProvider.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public static void attachNative(File agentLibrary, ProcessProvider processProvider, AttachmentProvider attachmentProvider) {
        void var2_2;
        void var1_1;
        ByteBuddyAgent.attachNative(agentLibrary, (ProcessProvider)var1_1, WITHOUT_ARGUMENT, (AttachmentProvider)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void attachNative(File agentLibrary, ProcessProvider processProvider, @MaybeNull String argument, AttachmentProvider attachmentProvider) {
        File file;
        void var2_2;
        void var1_1;
        ByteBuddyAgent.install(attachmentProvider, var1_1.resolve(), (String)var2_2, new AgentProvider.ForExistingAgent(file), true);
    }

    public static Instrumentation install() {
        return ByteBuddyAgent.install(AttachmentProvider.DEFAULT);
    }

    public static Instrumentation install(AttachmentProvider attachmentProvider) {
        return ByteBuddyAgent.install(attachmentProvider, ProcessProvider.ForCurrentVm.INSTANCE);
    }

    public static Instrumentation install(ProcessProvider processProvider) {
        ProcessProvider processProvider2;
        return ByteBuddyAgent.install(AttachmentProvider.DEFAULT, processProvider2);
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized Instrumentation install(AttachmentProvider attachmentProvider, ProcessProvider processProvider) {
        void var1_1;
        AttachmentProvider attachmentProvider2;
        Instrumentation instrumentation = ByteBuddyAgent.doGetInstrumentation();
        if (instrumentation != null) {
            void var2_2;
            return var2_2;
        }
        ByteBuddyAgent.install(attachmentProvider2, var1_1.resolve(), WITHOUT_ARGUMENT, AgentProvider.ForByteBuddyAgent.INSTANCE, false);
        return ByteBuddyAgent.getInstrumentation();
    }

    /*
     * WARNING - void declaration
     */
    private static void install(AttachmentProvider attachmentProvider, String processId, @MaybeNull String argument, AgentProvider agentProvider, boolean isNative) {
        AttachmentProvider.Accessor attachmentAccessor = attachmentProvider.attempt();
        if (!attachmentAccessor.isAvailable()) {
            throw new IllegalStateException("No compatible attachment provider is available");
        }
        try {
            if (!attachmentAccessor.isExternalAttachmentRequired() || !ATTACHMENT_TYPE_EVALUATOR.requiresExternalAttachment((String)processId)) {
                void var2_3;
                void var3_4;
                Attacher.install(attachmentAccessor.getVirtualMachineType(), (String)processId, var3_4.resolve().getAbsolutePath(), isNative, (String)var2_3);
                return;
            }
            ByteBuddyAgent.installExternal(attachmentAccessor.getExternalAttachment(), (String)processId, agentProvider.resolve(), isNative, argument);
        }
        catch (RuntimeException runtimeException) {
            processId = runtimeException;
            throw runtimeException;
        }
        catch (Exception exception) {
            void var1_2;
            AttachmentProvider attachmentProvider2;
            throw new IllegalStateException("Error during attachment using: " + attachmentProvider2, (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"OS_OPEN_STREAM_EXCEPTION_PATH"}, justification="Outer stream holds file handle and is closed")
    private static void installExternal(AttachmentProvider.Accessor.ExternalAttachment externalAttachment, String processId, File agent, boolean isNative, @MaybeNull String argument) throws Exception {
        File selfResolvedJar = ByteBuddyAgent.trySelfResolve();
        File attachmentJar = null;
        try {
            void var3_6;
            void var2_5;
            void var1_4;
            AttachmentProvider.Accessor.ExternalAttachment externalAttachment2;
            if (selfResolvedJar == null) {
                InputStream inputStream = Attacher.class.getResourceAsStream("/" + Attacher.class.getName().replace('.', '/') + CLASS_FILE_EXTENSION);
                if (inputStream == null) {
                    throw new IllegalStateException("Cannot locate class file for Byte Buddy installation process");
                }
                try {
                    attachmentJar = File.createTempFile(ATTACHER_FILE_NAME, JAR_FILE_EXTENSION);
                    FileOutputStream outputStream = new FileOutputStream(attachmentJar);
                    try {
                        int index;
                        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
                        jarOutputStream.putNextEntry(new JarEntry(Attacher.class.getName().replace('.', '/') + CLASS_FILE_EXTENSION));
                        byte[] buffer = new byte[8192];
                        while ((index = inputStream.read(buffer)) != -1) {
                            jarOutputStream.write(buffer, 0, index);
                        }
                        jarOutputStream.closeEntry();
                        jarOutputStream.close();
                    }
                    finally {
                        ((OutputStream)outputStream).close();
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            StringBuilder classPath = new StringBuilder().append((selfResolvedJar == null ? attachmentJar : selfResolvedJar).getCanonicalPath());
            for (File jar : externalAttachment.getClassPath()) {
                classPath.append(File.pathSeparatorChar).append(jar.getCanonicalPath());
            }
            String[] stringArray = new String[10];
            stringArray[0] = System.getProperty(JAVA_HOME) + File.separatorChar + "bin" + File.separatorChar + (System.getProperty(OS_NAME, "").toLowerCase(Locale.US).contains("windows") ? "java.exe" : "java");
            stringArray[1] = "-Dnet.bytebuddy.agent.attacher.dump=" + System.getProperty("net.bytebuddy.agent.attacher.dump", "");
            stringArray[2] = CLASS_PATH_ARGUMENT;
            stringArray[3] = classPath.toString();
            stringArray[4] = Attacher.class.getName();
            stringArray[5] = externalAttachment2.getVirtualMachineType();
            stringArray[6] = var1_4;
            stringArray[7] = var2_5.getAbsolutePath();
            stringArray[8] = Boolean.toString((boolean)var3_6);
            String string = stringArray[9] = argument == null ? "" : AGENT_ARGUMENT_SEPARATOR + argument;
            if (new ProcessBuilder(stringArray).start().waitFor() != 0) {
                throw new IllegalStateException("Could not self-attach to current VM using external process - set a property net.bytebuddy.agent.attacher.dump to dump the process output to a file at the specified location");
            }
            if (attachmentJar != null && !attachmentJar.delete()) {
                attachmentJar.deleteOnExit();
                return;
            }
        }
        catch (Throwable throwable) {
            if (attachmentJar != null && !attachmentJar.delete()) {
                attachmentJar.deleteOnExit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @MaybeNull
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
    private static File trySelfResolve() {
        if (Boolean.getBoolean(LATENT_RESOLVE)) {
            return null;
        }
        ProtectionDomain protectionDomain = Attacher.class.getProtectionDomain();
        if (protectionDomain == null) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL location = codeSource.getLocation();
        if (!location.getProtocol().equals("file")) {
            return null;
        }
        try {
            void var1_1;
            File file = new File(location.toURI());
            if (file.getPath().contains(AGENT_ARGUMENT_SEPARATOR)) {
                return null;
            }
            return var1_1;
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                void var0;
                return new File(var0.getPath());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @MaybeNull
    private static Instrumentation doGetInstrumentation() {
        Instrumentation instrumentation;
        if (!Installer.NAME.equals(Installer.class.getName()) && (instrumentation = ByteBuddyAgent.doGetInstrumentation(Installer.NAME)) != null) {
            void var0;
            return var0;
        }
        return ByteBuddyAgent.doGetInstrumentation(Installer.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    @MaybeNull
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
    private static Instrumentation doGetInstrumentation(String name) {
        try {
            String string;
            Class<?> installer = Class.forName(name, true, ClassLoader.getSystemClassLoader());
            try {
                void var3_3;
                Class<?> module = Class.forName("java.lang.Module");
                Method getModule = Class.class.getMethod("getModule", new Class[0]);
                Object source = getModule.invoke(ByteBuddyAgent.class, new Object[0]);
                Object target = var3_3.invoke(installer, new Object[0]);
                if (!((Boolean)module.getMethod("canRead", module).invoke(source, target)).booleanValue()) {
                    void var1_1;
                    void var2_2;
                    module.getMethod("addReads", new Class[]{var2_2}).invoke(source, var1_1);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            return (Instrumentation)Class.forName(string, true, ClassLoader.getSystemClassLoader()).getMethod("getInstrumentation", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static interface AttachmentTypeEvaluator {
        public boolean requiresExternalAttachment(String var1);

        public static class ForJava9CapableVm
        implements AttachmentTypeEvaluator {
            private final Method current;
            private final Method pid;

            /*
             * WARNING - void declaration
             */
            protected ForJava9CapableVm(Method current, Method pid) {
                void var2_2;
                void var1_1;
                this.current = var1_1;
                this.pid = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public boolean requiresExternalAttachment(String processId) {
                try {
                    return this.pid.invoke(this.current.invoke(null, new Object[0]), new Object[0]).toString().equals(processId);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access Java 9 process API", exception);
                }
                catch (InvocationTargetException exception) {
                    void var1_3;
                    throw new IllegalStateException("Error when accessing Java 9 process API", var1_3.getTargetException());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Disabled implements AttachmentTypeEvaluator
        {
            INSTANCE;


            @Override
            public final boolean requiresExternalAttachment(String processId) {
                return false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum InstallationAction implements PrivilegedAction<AttachmentTypeEvaluator>
        {
            INSTANCE;

            private static final String JDK_ALLOW_SELF_ATTACH = "jdk.attach.allowAttachSelf";

            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
            public final AttachmentTypeEvaluator run() {
                try {
                    if (Boolean.getBoolean(JDK_ALLOW_SELF_ATTACH)) {
                        return Disabled.INSTANCE;
                    }
                    return new ForJava9CapableVm(Class.forName("java.lang.ProcessHandle").getMethod("current", new Class[0]), Class.forName("java.lang.ProcessHandle").getMethod("pid", new Class[0]));
                }
                catch (Exception exception) {
                    return Disabled.INSTANCE;
                }
            }
        }
    }

    protected static interface AgentProvider {
        public File resolve() throws IOException;

        public static class ForExistingAgent
        implements AgentProvider {
            private final File agent;

            /*
             * WARNING - void declaration
             */
            protected ForExistingAgent(File agent) {
                void var1_1;
                this.agent = var1_1;
            }

            public File resolve() {
                return this.agent;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForByteBuddyAgent implements AgentProvider
        {
            INSTANCE;

            private static final String AGENT_FILE_NAME = "byteBuddyAgent";

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            private static File trySelfResolve(Class<?> installer2) throws IOException {
                Class<?> clazz;
                void var1_2;
                Manifest manifest;
                File agentJar;
                ProtectionDomain protectionDomain = installer2.getProtectionDomain();
                if (Boolean.getBoolean(ByteBuddyAgent.LATENT_RESOLVE)) {
                    return null;
                }
                if (protectionDomain == null) {
                    return null;
                }
                CodeSource codeSource = protectionDomain.getCodeSource();
                if (codeSource == null) {
                    return null;
                }
                URL location = codeSource.getLocation();
                if (!location.getProtocol().equals("file")) {
                    return null;
                }
                try {
                    agentJar = new File(location.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    agentJar = new File(location.getPath());
                }
                if (!agentJar.isFile() || !agentJar.canRead()) {
                    return null;
                }
                FileInputStream inputStream = new FileInputStream(agentJar);
                try {
                    JarInputStream jarInputStream = new JarInputStream(inputStream);
                    manifest = jarInputStream.getManifest();
                    jarInputStream.close();
                }
                catch (Throwable installer2) {
                    void var3_4;
                    var3_4.close();
                    throw installer2;
                }
                ((InputStream)inputStream).close();
                if (manifest == null) {
                    return null;
                }
                Attributes attributes = var1_2.getMainAttributes();
                if (attributes == null) {
                    return null;
                }
                if (clazz.getName().equals(attributes.getValue(ByteBuddyAgent.AGENT_CLASS_PROPERTY)) && Boolean.parseBoolean(attributes.getValue(ByteBuddyAgent.CAN_REDEFINE_CLASSES_PROPERTY)) && Boolean.parseBoolean(attributes.getValue(ByteBuddyAgent.CAN_RETRANSFORM_CLASSES_PROPERTY)) && Boolean.parseBoolean(attributes.getValue(ByteBuddyAgent.CAN_SET_NATIVE_METHOD_PREFIX))) {
                    void var2_3;
                    return var2_3;
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            @SuppressFBWarnings(value={"OS_OPEN_STREAM_EXCEPTION_PATH"}, justification="Outer stream holds file handle and is closed")
            private static File createJarFile() throws IOException {
                void var2_4;
                InputStream inputStream = Installer.class.getResourceAsStream("/" + Installer.class.getName().replace('.', '/') + ByteBuddyAgent.CLASS_FILE_EXTENSION);
                if (inputStream == null) {
                    throw new IllegalStateException("Cannot locate class file for Byte Buddy installer");
                }
                try {
                    void var1_1;
                    File agentJar22 = File.createTempFile(AGENT_FILE_NAME, ByteBuddyAgent.JAR_FILE_EXTENSION);
                    agentJar22.deleteOnExit();
                    Manifest manifest = new Manifest();
                    manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, ByteBuddyAgent.MANIFEST_VERSION_VALUE);
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.AGENT_CLASS_PROPERTY), Installer.class.getName());
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.CAN_REDEFINE_CLASSES_PROPERTY), Boolean.TRUE.toString());
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.CAN_RETRANSFORM_CLASSES_PROPERTY), Boolean.TRUE.toString());
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.CAN_SET_NATIVE_METHOD_PREFIX), Boolean.TRUE.toString());
                    FileOutputStream outputStream = new FileOutputStream(agentJar22);
                    try {
                        int index;
                        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)outputStream, manifest);
                        jarOutputStream.putNextEntry(new JarEntry(Installer.class.getName().replace('.', '/') + ByteBuddyAgent.CLASS_FILE_EXTENSION));
                        byte[] buffer = new byte[8192];
                        while ((index = inputStream.read(buffer)) != -1) {
                            jarOutputStream.write(buffer, 0, index);
                        }
                        jarOutputStream.closeEntry();
                        var2_4.close();
                    }
                    catch (Throwable agentJar22) {
                        void var3_5;
                        var3_5.close();
                        throw agentJar22;
                    }
                    ((OutputStream)outputStream).close();
                    var2_4 = var1_1;
                }
                catch (Throwable throwable) {
                    void var0;
                    var0.close();
                    throw throwable;
                }
                inputStream.close();
                return var2_4;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
            public final File resolve() throws IOException {
                try {
                    File resolved;
                    if (!Installer.class.getName().equals(Installer.NAME)) {
                        try {
                            resolved = ForByteBuddyAgent.trySelfResolve(Class.forName(Installer.NAME, false, ClassLoader.getSystemClassLoader()));
                            if (resolved != null) {
                                return resolved;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    if ((resolved = ForByteBuddyAgent.trySelfResolve(Installer.class)) != null) {
                        void var1_1;
                        return var1_1;
                    }
                }
                catch (Exception exception) {}
                return ForByteBuddyAgent.createJarFile();
            }
        }
    }

    public static interface ProcessProvider {
        public String resolve();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForCurrentVm implements ProcessProvider
        {
            INSTANCE;

            private final ProcessProvider dispatcher = ForJava9CapableVm.make();

            @Override
            public final String resolve() {
                return this.dispatcher.resolve();
            }

            protected static class ForJava9CapableVm
            implements ProcessProvider {
                private final Method current;
                private final Method pid;

                /*
                 * WARNING - void declaration
                 */
                protected ForJava9CapableVm(Method current, Method pid) {
                    void var2_2;
                    void var1_1;
                    this.current = var1_1;
                    this.pid = var2_2;
                }

                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
                public static ProcessProvider make() {
                    try {
                        return new ForJava9CapableVm(Class.forName("java.lang.ProcessHandle").getMethod("current", new Class[0]), Class.forName("java.lang.ProcessHandle").getMethod("pid", new Class[0]));
                    }
                    catch (Exception exception) {
                        return ForLegacyVm.INSTANCE;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public String resolve() {
                    try {
                        return this.pid.invoke(this.current.invoke(null, new Object[0]), new Object[0]).toString();
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access Java 9 process API", exception);
                    }
                    catch (InvocationTargetException exception) {
                        void var1_2;
                        throw new IllegalStateException("Error when accessing Java 9 process API", var1_2.getTargetException());
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum ForLegacyVm implements ProcessProvider
            {
                INSTANCE;


                /*
                 * WARNING - void declaration
                 */
                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
                public final String resolve() {
                    void var2_3;
                    void var1_4;
                    String runtimeName;
                    try {
                        Method method = Class.forName("java.lang.management.ManagementFactory").getMethod("getRuntimeMXBean", new Class[0]);
                        runtimeName = (String)method.getReturnType().getMethod("getName", new Class[0]).invoke(method.invoke(null, new Object[0]), new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException("Failed to access VM name via management factory", exception);
                    }
                    int processIdIndex = runtimeName.indexOf(64);
                    if (processIdIndex == -1) {
                        throw new IllegalStateException("Cannot extract process id from runtime management bean");
                    }
                    return var1_4.substring(0, (int)var2_3);
                }
            }
        }
    }

    @SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="Safe initialization is implied")
    public static interface AttachmentProvider {
        public static final AttachmentProvider DEFAULT = new Compound(ForModularizedVm.INSTANCE, ForJ9Vm.INSTANCE, ForStandardToolsJarVm.JVM_ROOT, ForStandardToolsJarVm.JDK_ROOT, ForStandardToolsJarVm.MACINTOSH, ForUserDefinedToolsJar.INSTANCE, ForEmulatedAttachment.INSTANCE);

        public Accessor attempt();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Compound
        implements AttachmentProvider {
            private final List<AttachmentProvider> attachmentProviders = new ArrayList<AttachmentProvider>();

            /*
             * WARNING - void declaration
             */
            public Compound(AttachmentProvider ... attachmentProvider) {
                this(Arrays.asList(var1_1));
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Compound(List<? extends AttachmentProvider> attachmentProviders) {
                Iterator iterator;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    void var2_2;
                    AttachmentProvider attachmentProvider = (AttachmentProvider)iterator.next();
                    if (attachmentProvider instanceof Compound) {
                        this.attachmentProviders.addAll(((Compound)attachmentProvider).attachmentProviders);
                        continue;
                    }
                    this.attachmentProviders.add((AttachmentProvider)var2_2);
                }
            }

            @Override
            public Accessor attempt() {
                for (AttachmentProvider attachmentProvider : this.attachmentProviders) {
                    Accessor accessor = attachmentProvider.attempt();
                    if (!accessor.isAvailable()) continue;
                    return attachmentProvider;
                }
                return Accessor.Unavailable.INSTANCE;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForEmulatedAttachment implements AttachmentProvider
        {
            INSTANCE;


            @Override
            public final Accessor attempt() {
                try {
                    return new Accessor.Simple.WithDirectAttachment((Class)ByteBuddyAgent.doPrivileged(VirtualMachine.Resolver.INSTANCE));
                }
                catch (Throwable throwable) {
                    return Accessor.Unavailable.INSTANCE;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForUserDefinedToolsJar implements AttachmentProvider
        {
            INSTANCE;

            public static final String PROPERTY = "net.bytebuddy.agent.toolsjar";

            /*
             * WARNING - void declaration
             */
            @Override
            @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Assuring privilege is explicit user responsibility.")
            public final Accessor attempt() {
                String location = System.getProperty(PROPERTY);
                if (location == null) {
                    return Accessor.Unavailable.INSTANCE;
                }
                File toolsJar = new File(location);
                try {
                    return Accessor.Simple.of(new URLClassLoader(new URL[]{toolsJar.toURI().toURL()}, BOOTSTRAP_CLASS_LOADER), toolsJar);
                }
                catch (MalformedURLException malformedURLException) {
                    void var1_1;
                    throw new IllegalStateException("Could not represent " + var1_1 + " as URL");
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForStandardToolsJarVm implements AttachmentProvider
        {
            JVM_ROOT("../lib/tools.jar"),
            JDK_ROOT("lib/tools.jar"),
            MACINTOSH("../Classes/classes.jar");

            private static final String JAVA_HOME_PROPERTY = "java.home";
            private final String toolsJarPath;

            /*
             * WARNING - void declaration
             */
            private ForStandardToolsJarVm(String toolsJarPath) {
                void var3_3;
                this.toolsJarPath = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Assuring privilege is explicit user responsibility.")
            public final Accessor attempt() {
                File toolsJar = new File(System.getProperty("java.home"), this.toolsJarPath);
                try {
                    if (toolsJar.isFile() && toolsJar.canRead()) {
                        return Accessor.Simple.of(new URLClassLoader(new URL[]{toolsJar.toURI().toURL()}, BOOTSTRAP_CLASS_LOADER), toolsJar);
                    }
                    return Accessor.Unavailable.INSTANCE;
                }
                catch (MalformedURLException malformedURLException) {
                    void var1_1;
                    throw new IllegalStateException("Could not represent " + var1_1 + " as URL");
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForJ9Vm implements AttachmentProvider
        {
            INSTANCE;


            @Override
            public final Accessor attempt() {
                return Accessor.Simple.ofJ9();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForModularizedVm implements AttachmentProvider
        {
            INSTANCE;


            @Override
            public final Accessor attempt() {
                return Accessor.Simple.of(ClassLoader.getSystemClassLoader(), new File[0]);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Accessor {
            public static final String VIRTUAL_MACHINE_TYPE_NAME = "com.sun.tools.attach.VirtualMachine";
            public static final String VIRTUAL_MACHINE_TYPE_NAME_J9 = "com.ibm.tools.attach.VirtualMachine";

            public boolean isAvailable();

            public boolean isExternalAttachmentRequired();

            public Class<?> getVirtualMachineType();

            public ExternalAttachment getExternalAttachment();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static abstract class Simple
            implements Accessor {
                protected final Class<?> virtualMachineType;

                /*
                 * WARNING - void declaration
                 */
                protected Simple(Class<?> virtualMachineType) {
                    void var1_1;
                    this.virtualMachineType = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public static Accessor of(@MaybeNull ClassLoader classLoader, File ... classPath) {
                    try {
                        void var1_1;
                        ClassLoader classLoader2;
                        return new WithExternalAttachment(Class.forName(Accessor.VIRTUAL_MACHINE_TYPE_NAME, false, classLoader2), Arrays.asList(var1_1));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return Unavailable.INSTANCE;
                    }
                }

                public static Accessor ofJ9() {
                    try {
                        return new WithExternalAttachment(ClassLoader.getSystemClassLoader().loadClass(Accessor.VIRTUAL_MACHINE_TYPE_NAME_J9), Collections.<File>emptyList());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return Unavailable.INSTANCE;
                    }
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                public Class<?> getVirtualMachineType() {
                    return this.virtualMachineType;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static class WithDirectAttachment
                extends Simple {
                    /*
                     * WARNING - void declaration
                     */
                    public WithDirectAttachment(Class<?> virtualMachineType) {
                        super((Class<?>)var1_1);
                        void var1_1;
                    }

                    @Override
                    public boolean isExternalAttachmentRequired() {
                        return false;
                    }

                    @Override
                    public ExternalAttachment getExternalAttachment() {
                        throw new IllegalStateException("Cannot apply external attachment");
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static class WithExternalAttachment
                extends Simple {
                    private final List<File> classPath;

                    /*
                     * WARNING - void declaration
                     */
                    public WithExternalAttachment(Class<?> virtualMachineType, List<File> classPath) {
                        super((Class<?>)var1_1);
                        void var2_2;
                        void var1_1;
                        this.classPath = var2_2;
                    }

                    @Override
                    public boolean isExternalAttachmentRequired() {
                        return true;
                    }

                    @Override
                    public ExternalAttachment getExternalAttachment() {
                        return new ExternalAttachment(this.virtualMachineType.getName(), this.classPath);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class ExternalAttachment {
                private final String virtualMachineType;
                private final List<File> classPath;

                /*
                 * WARNING - void declaration
                 */
                public ExternalAttachment(String virtualMachineType, List<File> classPath) {
                    void var2_2;
                    void var1_1;
                    this.virtualMachineType = var1_1;
                    this.classPath = var2_2;
                }

                public String getVirtualMachineType() {
                    return this.virtualMachineType;
                }

                public List<File> getClassPath() {
                    return this.classPath;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Unavailable implements Accessor
            {
                INSTANCE;


                @Override
                public final boolean isAvailable() {
                    return false;
                }

                @Override
                public final boolean isExternalAttachmentRequired() {
                    throw new IllegalStateException("Cannot read the virtual machine type for an unavailable accessor");
                }

                @Override
                public final Class<?> getVirtualMachineType() {
                    throw new IllegalStateException("Cannot read the virtual machine type for an unavailable accessor");
                }

                @Override
                public final ExternalAttachment getExternalAttachment() {
                    throw new IllegalStateException("Cannot read the virtual machine type for an unavailable accessor");
                }
            }
        }
    }
}

