/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinNT;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.GlobalConfig;
import oshi.util.platform.windows.WmiUtil;

@ThreadSafe
public class WmiQueryHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WmiQueryHandler.class);
    private static int globalTimeout = GlobalConfig.get("oshi.util.wmi.timeout", -1);
    protected int wmiTimeout = globalTimeout;
    protected final Set<String> failedWmiClassNames = new HashSet<String>();
    private int comThreading = 0;
    private boolean securityInitialized = false;
    private static final Class<?>[] EMPTY_CLASS_ARRAY;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static Class<? extends WmiQueryHandler> customClass;

    public static synchronized WmiQueryHandler createInstance() {
        if (customClass == null) {
            return new WmiQueryHandler();
        }
        try {
            return customClass.getConstructor(EMPTY_CLASS_ARRAY).newInstance(EMPTY_OBJECT_ARRAY);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            LOG.error("Failed to find or access a no-arg constructor for {}", customClass);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            LOG.error("Failed to create a new instance of {}", customClass);
        }
        return null;
    }

    public static synchronized void setInstanceClass(Class<? extends WmiQueryHandler> instanceClass) {
        customClass = instanceClass;
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Enum<T>> WbemcliUtil.WmiResult<T> queryWMI(WbemcliUtil.WmiQuery<T> query) {
        void var1_1;
        return this.queryWMI((WbemcliUtil.WmiQuery<T>)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Enum<T>> WbemcliUtil.WmiResult<T> queryWMI(WbemcliUtil.WmiQuery<T> query, boolean initCom) {
        void var3_5;
        WbemcliUtil wbemcliUtil = WbemcliUtil.INSTANCE;
        Objects.requireNonNull(wbemcliUtil);
        WbemcliUtil.WmiResult result = new WbemcliUtil.WmiResult(wbemcliUtil, query.getPropertyEnum());
        if (this.failedWmiClassNames.contains(query.getWmiClassName())) {
            return result;
        }
        boolean comInit = false;
        try {
            if (initCom) {
                comInit = this.initCOM();
            }
            result = query.execute(this.wmiTimeout);
        }
        catch (COMException e) {
            if (!"ROOT\\OpenHardwareMonitor".equals(query.getNameSpace())) {
                int n = e.getHresult() == null ? -1 : e.getHresult().intValue();
                switch (n) {
                    case -2147217394: {
                        LOG.warn("COM exception: Invalid Namespace {}", (Object)query.getNameSpace());
                        break;
                    }
                    case -2147217392: {
                        LOG.warn("COM exception: Invalid Class {}", (Object)query.getWmiClassName());
                        break;
                    }
                    case -2147217385: {
                        LOG.warn("COM exception: Invalid Query: {}", (Object)WmiUtil.queryToString(query));
                        break;
                    }
                    default: {
                        void var2_4;
                        this.handleComException(query, (COMException)var2_4);
                    }
                }
                this.failedWmiClassNames.add(query.getWmiClassName());
            }
        }
        catch (TimeoutException timeoutException) {
            void var1_1;
            LOG.warn("WMI query timed out after {} ms: {}", (Object)this.wmiTimeout, (Object)WmiUtil.queryToString(var1_1));
        }
        finally {
            if (comInit) {
                this.unInitCOM();
            }
        }
        return var3_5;
    }

    /*
     * WARNING - void declaration
     */
    protected void handleComException(WbemcliUtil.WmiQuery<?> query, COMException ex) {
        void var2_2;
        void var1_1;
        LOG.warn("COM exception querying {}, which might not be on your system. Will not attempt to query it again. Error was {}: {}", new Object[]{var1_1.getWmiClassName(), ex.getHresult() == null ? null : Integer.valueOf(ex.getHresult().intValue()), var2_2.getMessage()});
    }

    /*
     * WARNING - void declaration
     */
    public boolean initCOM() {
        void var1_1;
        WmiQueryHandler wmiQueryHandler = this;
        boolean comInit = wmiQueryHandler.initCOM(wmiQueryHandler.getComThreading());
        if (!comInit) {
            WmiQueryHandler wmiQueryHandler2 = this;
            comInit = wmiQueryHandler2.initCOM(wmiQueryHandler2.switchComThreading());
        }
        if (comInit && !this.isSecurityInitialized()) {
            WinNT.HRESULT hres = Ole32.INSTANCE.CoInitializeSecurity(null, -1, null, null, 0, 3, null, 0, null);
            if (COMUtils.FAILED((WinNT.HRESULT)hres) && hres.intValue() != -2147417831) {
                void var2_2;
                Ole32.INSTANCE.CoUninitialize();
                throw new COMException("Failed to initialize security.", (WinNT.HRESULT)var2_2);
            }
            this.securityInitialized = true;
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean initCOM(int coInitThreading) {
        void var1_2;
        WinNT.HRESULT hres = Ole32.INSTANCE.CoInitializeEx(null, coInitThreading);
        switch (hres.intValue()) {
            case 0: 
            case 1: {
                return true;
            }
            case -2147417850: {
                return false;
            }
        }
        throw new COMException("Failed to initialize COM library.", (WinNT.HRESULT)var1_2);
    }

    public void unInitCOM() {
        Ole32.INSTANCE.CoUninitialize();
    }

    public int getComThreading() {
        return this.comThreading;
    }

    public int switchComThreading() {
        this.comThreading = this.comThreading == 2 ? 0 : 2;
        return this.comThreading;
    }

    public boolean isSecurityInitialized() {
        return this.securityInitialized;
    }

    public int getWmiTimeout() {
        return this.wmiTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setWmiTimeout(int wmiTimeout) {
        void var1_1;
        this.wmiTimeout = var1_1;
    }

    static {
        if (globalTimeout == 0 || globalTimeout < -1) {
            throw new GlobalConfig.PropertyException("oshi.util.wmi.timeout");
        }
        EMPTY_CLASS_ARRAY = new Class[0];
        EMPTY_OBJECT_ARRAY = new Object[0];
        customClass = null;
    }
}

