/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.WinNT;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.NotThreadSafe;
import oshi.util.FormatUtil;
import oshi.util.platform.windows.PerfDataUtil;

@NotThreadSafe
public final class PerfCounterQueryHandler
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PerfCounterQueryHandler.class);
    private Map<PerfDataUtil.PerfCounter, WinNT.HANDLEByReference> counterHandleMap = new HashMap<PerfDataUtil.PerfCounter, WinNT.HANDLEByReference>();
    private WinNT.HANDLEByReference queryHandle = null;

    /*
     * WARNING - void declaration
     */
    public final boolean addCounterToQuery(PerfDataUtil.PerfCounter counter) {
        void var2_2;
        void var1_1;
        if (this.queryHandle == null) {
            this.queryHandle = new WinNT.HANDLEByReference();
            if (!PerfDataUtil.openQuery(this.queryHandle)) {
                LOG.warn("Failed to open a query for PDH counter: {}", (Object)counter.getCounterPath());
                this.queryHandle = null;
                return false;
            }
        }
        WinNT.HANDLEByReference p = new WinNT.HANDLEByReference();
        if (!PerfDataUtil.addCounter(this.queryHandle, counter.getCounterPath(), p)) {
            LOG.warn("Failed to add counter for PDH counter: {}", (Object)counter.getCounterPath());
            return false;
        }
        this.counterHandleMap.put((PerfDataUtil.PerfCounter)var1_1, (WinNT.HANDLEByReference)var2_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeCounterFromQuery(PerfDataUtil.PerfCounter counter) {
        void var2_2;
        boolean success = false;
        WinNT.HANDLEByReference href = this.counterHandleMap.remove(counter);
        if (href != null) {
            void var1_1;
            success = PerfDataUtil.removeCounter((WinNT.HANDLEByReference)var1_1);
        }
        if (this.counterHandleMap.isEmpty()) {
            PerfDataUtil.closeQuery(this.queryHandle);
            this.queryHandle = null;
        }
        return (boolean)var2_2;
    }

    public final void removeAllCounters() {
        for (WinNT.HANDLEByReference hANDLEByReference : this.counterHandleMap.values()) {
            PerfDataUtil.removeCounter(hANDLEByReference);
        }
        this.counterHandleMap.clear();
        if (this.queryHandle != null) {
            PerfDataUtil.closeQuery(this.queryHandle);
        }
        this.queryHandle = null;
    }

    public final long updateQuery() {
        if (this.queryHandle == null) {
            LOG.warn("Query does not exist to update.");
            return 0L;
        }
        return PerfDataUtil.updateQueryTimestamp(this.queryHandle);
    }

    /*
     * WARNING - void declaration
     */
    public final long queryCounter(PerfDataUtil.PerfCounter counter) {
        void var2_2;
        if (!this.counterHandleMap.containsKey(counter)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Counter {} does not exist to query.", (Object)counter.getCounterPath());
            }
            return 0L;
        }
        long value = PerfDataUtil.queryCounter(this.counterHandleMap.get(counter));
        if (value < 0L) {
            if (LOG.isWarnEnabled()) {
                void var1_1;
                LOG.warn("Error querying counter {}: {}", (Object)var1_1.getCounterPath(), (Object)String.format(FormatUtil.formatError((int)value), new Object[0]));
            }
            return 0L;
        }
        return (long)var2_2;
    }

    @Override
    public final void close() {
        this.removeAllCounters();
    }
}

