/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.unix.openbsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.openbsd.OpenBsdLibc;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class OpenBsdSysctlUtil {
    private static final String SYSCTL_N = "sysctl -n ";
    private static final Logger LOG = LoggerFactory.getLogger(OpenBsdSysctlUtil.class);
    private static final String SYSCTL_FAIL = "Failed sysctl call: {}, Error code: {}";

    private OpenBsdSysctlUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static int sysctl(int[] name, int def) {
        void var3_3;
        void var2_2;
        LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference(new LibCAPI.size_t((long)OpenBsdLibc.INT_SIZE));
        Memory p = new Memory(size.longValue());
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)p, (LibCAPI.size_t.ByReference)var2_2, null, LibCAPI.size_t.ZERO)) {
            void var1_1;
            int[] nArray;
            LOG.warn(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
            return (int)var1_1;
        }
        return var3_3.getInt(0L);
    }

    /*
     * WARNING - void declaration
     */
    public static long sysctl(int[] name, long def) {
        void var3_2;
        LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference(new LibCAPI.size_t((long)OpenBsdLibc.UINT64_SIZE));
        Memory p = new Memory(size.longValue());
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)p, (LibCAPI.size_t.ByReference)var3_2, null, LibCAPI.size_t.ZERO)) {
            void var1_1;
            int[] nArray;
            LOG.warn(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
            return (long)var1_1;
        }
        return p.getLong(0L);
    }

    /*
     * WARNING - void declaration
     */
    public static String sysctl(int[] name, String def) {
        void var3_3;
        void var2_2;
        LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference();
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, null, size, null, LibCAPI.size_t.ZERO)) {
            LOG.warn(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        Memory p = new Memory(size.longValue() + 1L);
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)p, (LibCAPI.size_t.ByReference)var2_2, null, LibCAPI.size_t.ZERO)) {
            void var1_1;
            int[] nArray;
            LOG.warn(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
            return var1_1;
        }
        return var3_3.getString(0L);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean sysctl(int[] name, Structure struct) {
        void var1_1;
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, struct.getPointer(), new LibCAPI.size_t.ByReference(new LibCAPI.size_t((long)struct.size())), null, LibCAPI.size_t.ZERO)) {
            int[] nArray;
            LOG.error(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
            return false;
        }
        var1_1.read();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static Memory sysctl(int[] name) {
        void var2_2;
        void var1_1;
        LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference();
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, null, size, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return null;
        }
        Memory m = new Memory(size.longValue());
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)m, (LibCAPI.size_t.ByReference)var1_1, null, LibCAPI.size_t.ZERO)) {
            int[] nArray;
            LOG.error(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
            return null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int sysctl(String name, int def) {
        void var1_1;
        String string;
        return ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer(SYSCTL_N + string), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long sysctl(String name, long def) {
        void var1_1;
        String string;
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer(SYSCTL_N + string), (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String sysctl(String name, String def) {
        String string;
        String v = ExecutingCommand.getFirstAnswer(SYSCTL_N + name);
        if (v == null || v.isEmpty()) {
            void var1_1;
            return var1_1;
        }
        return string;
    }
}

