/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.unix.freebsd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class ProcstatUtil {
    private ProcstatUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Integer, String> getCwdMap(int pid) {
        void var1_2;
        Iterator iterator;
        List<String> procstat = ExecutingCommand.runNative("procstat -f " + (pid < 0 ? "-a" : Integer.valueOf(pid)));
        HashMap<Integer, void> cwdMap = new HashMap<Integer, void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_3;
            String line = (String)iterator.next();
            String[] split = ParseUtil.whitespaces.split(line.trim(), 10);
            if (split.length != 10 || !split[2].equals("cwd")) continue;
            cwdMap.put(ParseUtil.parseIntOrDefault(split[0], -1), var2_3[9]);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String getCwd(int pid) {
        int n;
        Object object = ExecutingCommand.runNative("procstat -f " + n);
        object = object.iterator();
        while (object.hasNext()) {
            void var1_2;
            String line = (String)object.next();
            String[] split = ParseUtil.whitespaces.split(line.trim(), 10);
            if (split.length != 10 || !split[2].equals("cwd")) continue;
            return var1_2[9];
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public static long getOpenFiles(int pid) {
        void var1_2;
        int n;
        long fd = 0L;
        Object object = ExecutingCommand.runNative("procstat -f " + n);
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            String line = (String)object.next();
            String[] split = ParseUtil.whitespaces.split(line.trim(), 10);
            if (split.length != 10 || "Vd-".contains((CharSequence)var3_3[4])) continue;
            ++fd;
        }
        return (long)var1_2;
    }
}

