/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.util.Map;
import java.util.Properties;
import oshi.annotation.concurrent.NotThreadSafe;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

@NotThreadSafe
public final class GlobalConfig {
    private static final String OSHI_PROPERTIES = "oshi.properties";
    private static final Properties CONFIG = FileUtil.readPropertiesFromFilename("oshi.properties");

    private GlobalConfig() {
    }

    /*
     * WARNING - void declaration
     */
    public static String get(String key, String def) {
        void var1_1;
        String string;
        return CONFIG.getProperty(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int get(String key, int def) {
        void var1_1;
        String string;
        String value = CONFIG.getProperty(key);
        if (value == null) {
            return def;
        }
        return ParseUtil.parseIntOrDefault(string, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double get(String key, double def) {
        void var1_1;
        String string;
        String value = CONFIG.getProperty(key);
        if (value == null) {
            return def;
        }
        return ParseUtil.parseDoubleOrDefault(string, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean get(String key, boolean def) {
        String string;
        String value = CONFIG.getProperty(key);
        if (value == null) {
            void var1_1;
            return (boolean)var1_1;
        }
        return Boolean.parseBoolean(string);
    }

    /*
     * WARNING - void declaration
     */
    public static void set(String key, Object val) {
        void var1_1;
        String string;
        if (val == null) {
            CONFIG.remove(key);
            return;
        }
        CONFIG.setProperty(string, var1_1.toString());
    }

    public static void remove(String key) {
        String string;
        CONFIG.remove(string);
    }

    public static void clear() {
        CONFIG.clear();
    }

    public static void load(Properties properties) {
        Properties properties2;
        CONFIG.putAll((Map<?, ?>)properties2);
    }

    public static class PropertyException
    extends RuntimeException {
        private static final long serialVersionUID = -7482581936621748005L;

        /*
         * WARNING - void declaration
         */
        public PropertyException(String property) {
            super("Invalid property: \"" + property + "\" = " + GlobalConfig.get((String)var1_1, null));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public PropertyException(String property, String message) {
            super("Invalid property \"" + (String)var1_1 + "\": " + (String)var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

