/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ExecutingCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutingCommand.class);
    private static final String[] DEFAULT_ENV = ExecutingCommand.getDefaultEnv();

    private ExecutingCommand() {
    }

    private static String[] getDefaultEnv() {
        if (Platform.isWindows()) {
            return new String[]{"LANGUAGE=C"};
        }
        return new String[]{"LC_ALL=C"};
    }

    public static List<String> runNative(String cmdToRun) {
        String[] stringArray = cmdToRun.split(" ");
        return ExecutingCommand.runNative(stringArray);
    }

    public static List<String> runNative(String[] cmdToRunWithArgs) {
        return ExecutingCommand.runNative(cmdToRunWithArgs, DEFAULT_ENV);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> runNative(String[] cmdToRunWithArgs, String[] envp) {
        block27: {
            block26: {
                Process p = null;
                try {
                    p = Runtime.getRuntime().exec(cmdToRunWithArgs, (String[])envp);
                    envp = ExecutingCommand.getProcessOutput(p, cmdToRunWithArgs);
                    if (p == null) break block26;
                }
                catch (IOException | SecurityException e) {
                    try {
                        void var1_3;
                        String[] stringArray;
                        LOG.trace("Couldn't run command {}: {}", (Object)Arrays.toString(stringArray), (Object)var1_3.getMessage());
                        if (p == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (p != null) {
                            void var2_4;
                            if (Platform.isSolaris()) {
                                try {
                                    p.getOutputStream().close();
                                }
                                catch (IOException iOException) {}
                                try {
                                    p.getInputStream().close();
                                }
                                catch (IOException iOException) {}
                                try {
                                    p.getErrorStream().close();
                                }
                                catch (IOException iOException) {}
                            }
                            var2_4.destroy();
                        }
                        throw throwable;
                    }
                    if (Platform.isSolaris()) {
                        try {
                            p.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                        try {
                            p.getInputStream().close();
                        }
                        catch (IOException iOException) {}
                        try {
                            p.getErrorStream().close();
                        }
                        catch (IOException iOException) {}
                    }
                    p.destroy();
                }
                if (Platform.isSolaris()) {
                    try {
                        p.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        p.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        p.getErrorStream().close();
                    }
                    catch (IOException iOException) {}
                }
                p.destroy();
            }
            return envp;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> getProcessOutput(Process p, String[] cmd) {
        void var2_3;
        ArrayList<String> sa = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
            Process process;
            String line;
            while ((line = reader.readLine()) != null) {
                sa.add(line);
            }
            process.waitFor();
        }
        catch (IOException e) {
            LOG.trace("Problem reading output from {}: {}", (Object)Arrays.toString(cmd), (Object)e.getMessage());
        }
        catch (InterruptedException ie) {
            void var3_6;
            void var1_2;
            LOG.trace("Interrupted while reading output from {}: {}", (Object)Arrays.toString((Object[])var1_2), (Object)var3_6.getMessage());
            Thread.currentThread().interrupt();
        }
        return var2_3;
    }

    public static String getFirstAnswer(String cmd2launch) {
        return ExecutingCommand.getAnswerAt(cmd2launch, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String getAnswerAt(String cmd2launch, int answerIdx) {
        List<String> sa = ExecutingCommand.runNative(cmd2launch);
        if (answerIdx >= 0 && answerIdx < sa.size()) {
            void var1_1;
            List<String> list;
            return (String)list.get((int)var1_1);
        }
        return "";
    }
}

