/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.W32ServiceManager;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.EnumWindows;
import oshi.driver.windows.registry.HkeyUserData;
import oshi.driver.windows.registry.NetSessionData;
import oshi.driver.windows.registry.ProcessPerformanceData;
import oshi.driver.windows.registry.ProcessWtsData;
import oshi.driver.windows.registry.SessionWtsData;
import oshi.driver.windows.registry.ThreadPerformanceData;
import oshi.driver.windows.wmi.Win32OperatingSystem;
import oshi.driver.windows.wmi.Win32Processor;
import oshi.jna.platform.windows.WinNT;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSDesktopWindow;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OSSession;
import oshi.software.os.OperatingSystem;
import oshi.software.os.windows.WindowsFileSystem;
import oshi.software.os.windows.WindowsInternetProtocolStats;
import oshi.software.os.windows.WindowsNetworkParams;
import oshi.software.os.windows.WindowsOSProcess;
import oshi.util.GlobalConfig;
import oshi.util.Memoizer;
import oshi.util.platform.windows.WmiUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class WindowsOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOperatingSystem.class);
    public static final String OSHI_OS_WINDOWS_PROCSTATE_SUSPENDED = "oshi.os.windows.procstate.suspended";
    private static final boolean USE_PROCSTATE_SUSPENDED = GlobalConfig.get("oshi.os.windows.procstate.suspended", false);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final int TOKENELEVATION = 20;
    private static Supplier<String> systemLog = Memoizer.memoize(WindowsOperatingSystem::querySystemLog, TimeUnit.HOURS.toNanos(1L));
    private static final long BOOTTIME = WindowsOperatingSystem.querySystemBootTime();
    private static final boolean X86;
    private static final boolean WOW;
    private Supplier<Map<Integer, ProcessPerformanceData.PerfCounterBlock>> processMapFromRegistry = Memoizer.memoize(WindowsOperatingSystem::queryProcessMapFromRegistry, Memoizer.defaultExpiration());
    private Supplier<Map<Integer, ProcessPerformanceData.PerfCounterBlock>> processMapFromPerfCounters = Memoizer.memoize(WindowsOperatingSystem::queryProcessMapFromPerfCounters, Memoizer.defaultExpiration());
    private Supplier<Map<Integer, ThreadPerformanceData.PerfCounterBlock>> threadMapFromRegistry = Memoizer.memoize(WindowsOperatingSystem::queryThreadMapFromRegistry, Memoizer.defaultExpiration());
    private Supplier<Map<Integer, ThreadPerformanceData.PerfCounterBlock>> threadMapFromPerfCounters = Memoizer.memoize(WindowsOperatingSystem::queryThreadMapFromPerfCounters, Memoizer.defaultExpiration());

    @Override
    public String queryManufacturer() {
        return "Microsoft";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        void var3_5;
        void var2_4;
        void var1_1;
        int sp22;
        String version = System.getProperty("os.name");
        if (version.startsWith("Windows ")) {
            version = version.substring(8);
        }
        boolean suiteMask = false;
        String buildNumber = null;
        WbemcliUtil.WmiResult<Win32OperatingSystem.OSVersionProperty> versionInfo = Win32OperatingSystem.queryOsVersion();
        if (versionInfo.getResultCount() > 0) {
            String sp22 = WmiUtil.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.CSDVERSION, 0);
            if (!sp22.isEmpty() && !"unknown".equals(sp22)) {
                version = version + " " + sp22.replace("Service Pack ", "SP");
            }
            sp22 = WmiUtil.getUint32(versionInfo, Win32OperatingSystem.OSVersionProperty.SUITEMASK, 0);
            buildNumber = WmiUtil.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.BUILDNUMBER, 0);
        }
        String codeName = WindowsOperatingSystem.parseCodeName(sp22);
        return new Pair<String, OperatingSystem.OSVersionInfo>("Windows", new OperatingSystem.OSVersionInfo((String)var1_1, (String)var2_4, (String)var3_5));
    }

    /*
     * WARNING - void declaration
     */
    private static String parseCodeName(int suiteMask) {
        void var1_1;
        int n;
        ArrayList<String> suites = new ArrayList<String>();
        if ((suiteMask & 2) != 0) {
            suites.add("Enterprise");
        }
        if ((suiteMask & 4) != 0) {
            suites.add("BackOffice");
        }
        if ((suiteMask & 8) != 0) {
            suites.add("Communications Server");
        }
        if ((suiteMask & 0x80) != 0) {
            suites.add("Datacenter");
        }
        if ((suiteMask & 0x200) != 0) {
            suites.add("Home");
        }
        if ((suiteMask & 0x400) != 0) {
            suites.add("Web Server");
        }
        if ((suiteMask & 0x2000) != 0) {
            suites.add("Storage Server");
        }
        if ((suiteMask & 0x4000) != 0) {
            suites.add("Compute Cluster");
        }
        if ((n & 0x8000) != 0) {
            suites.add("Home Server");
        }
        return String.join((CharSequence)",", (Iterable<? extends CharSequence>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int queryBitness(int jvmBitness) {
        void var1_1;
        WbemcliUtil.WmiResult<Win32Processor.BitnessProperty> bitnessMap;
        if (jvmBitness < 64 && System.getenv("ProgramFiles(x86)") != null && IS_VISTA_OR_GREATER && (bitnessMap = Win32Processor.queryBitness()).getResultCount() > 0) {
            void var2_2;
            return WmiUtil.getUint16(var2_2, Win32Processor.BitnessProperty.ADDRESSWIDTH, 0);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isElevated() {
        WinNT.HANDLEByReference hToken;
        block3: {
            boolean bl;
            hToken = new WinNT.HANDLEByReference();
            boolean bl2 = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 8, hToken);
            if (!bl2) {
                LOG.error("OpenProcessToken failed. Error: {}", (Object)Native.getLastError());
                return false;
            }
            try {
                void var2_3;
                WinNT.TOKEN_ELEVATION elevation;
                WinNT.TOKEN_ELEVATION tOKEN_ELEVATION = elevation = new WinNT.TOKEN_ELEVATION();
                if (!Advapi32.INSTANCE.GetTokenInformation(hToken.getValue(), 20, (Structure)tOKEN_ELEVATION, tOKEN_ELEVATION.size(), new IntByReference())) break block3;
                bl = var2_3.TokenIsElevated > 0;
            }
            catch (Throwable throwable) {
                void var1_1;
                Kernel32.INSTANCE.CloseHandle(var1_1.getValue());
                throw throwable;
            }
            Kernel32.INSTANCE.CloseHandle(hToken.getValue());
            return bl;
        }
        Kernel32.INSTANCE.CloseHandle(hToken.getValue());
        return false;
    }

    @Override
    public FileSystem getFileSystem() {
        return new WindowsFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new WindowsInternetProtocolStats();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSSession> getSessions() {
        void var1_1;
        List<OSSession> whoList = HkeyUserData.queryUserSessions();
        whoList.addAll(SessionWtsData.queryUserSessions());
        whoList.addAll(NetSessionData.queryUserSessions());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> getProcesses(Collection<Integer> pids) {
        void var1_1;
        return this.processMapToList((Collection<Integer>)var1_1);
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.processMapToList(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        void var1_2;
        Set<Integer> descendantPids = WindowsOperatingSystem.getChildrenOrDescendants(WindowsOperatingSystem.getParentPidsFromSnapshot(), parentPid, false);
        return this.processMapToList((Collection<Integer>)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        void var1_2;
        Set<Integer> descendantPids = WindowsOperatingSystem.getChildrenOrDescendants(WindowsOperatingSystem.getParentPidsFromSnapshot(), parentPid, true);
        return this.processMapToList((Collection<Integer>)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<Integer, Integer> getParentPidsFromSnapshot() {
        void var0;
        HashMap<Integer, Integer> parentPidMap22 = new HashMap<Integer, Integer>();
        Tlhelp32.PROCESSENTRY32.ByReference processEntry = new Tlhelp32.PROCESSENTRY32.ByReference();
        WinNT.HANDLE snapshot = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        try {
            while (Kernel32.INSTANCE.Process32Next(snapshot, (Tlhelp32.PROCESSENTRY32)processEntry)) {
                parentPidMap22.put(processEntry.th32ProcessID.intValue(), processEntry.th32ParentProcessID.intValue());
            }
        }
        catch (Throwable parentPidMap22) {
            void var2_3;
            Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var2_3);
            throw parentPidMap22;
        }
        Kernel32.INSTANCE.CloseHandle(snapshot);
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSProcess getProcess(int pid) {
        void var1_2;
        List<OSProcess> procList = this.processMapToList(Arrays.asList(pid));
        if (procList.isEmpty()) {
            return null;
        }
        return (OSProcess)var1_2.get(0);
    }

    private List<OSProcess> processMapToList(Collection<Integer> pids) {
        Map<Integer, ProcessPerformanceData.PerfCounterBlock> processMap = this.processMapFromRegistry.get();
        if (processMap == null || processMap.isEmpty()) {
            processMap = pids == null ? this.processMapFromPerfCounters.get() : ProcessPerformanceData.buildProcessMapFromPerfCounters(pids);
        }
        Map<Integer, ThreadPerformanceData.PerfCounterBlock> threadMap = null;
        if (USE_PROCSTATE_SUSPENDED && ((threadMap = this.threadMapFromRegistry.get()) == null || threadMap.isEmpty())) {
            threadMap = pids == null ? this.threadMapFromPerfCounters.get() : ThreadPerformanceData.buildThreadMapFromPerfCounters(pids);
        }
        Map<Integer, ProcessWtsData.WtsInfo> processWtsMap = ProcessWtsData.queryProcessWtsMap(pids);
        HashSet<Integer> mapKeys = new HashSet<Integer>(processWtsMap.keySet());
        mapKeys.retainAll(processMap.keySet());
        ArrayList<OSProcess> processList = new ArrayList<OSProcess>();
        for (Integer pid : mapKeys) {
            processList.add(new WindowsOSProcess(pid, this, processMap, processWtsMap, threadMap));
        }
        return processList;
    }

    private static Map<Integer, ProcessPerformanceData.PerfCounterBlock> queryProcessMapFromRegistry() {
        return ProcessPerformanceData.buildProcessMapFromRegistry(null);
    }

    private static Map<Integer, ProcessPerformanceData.PerfCounterBlock> queryProcessMapFromPerfCounters() {
        return ProcessPerformanceData.buildProcessMapFromPerfCounters(null);
    }

    private static Map<Integer, ThreadPerformanceData.PerfCounterBlock> queryThreadMapFromRegistry() {
        return ThreadPerformanceData.buildThreadMapFromRegistry(null);
    }

    private static Map<Integer, ThreadPerformanceData.PerfCounterBlock> queryThreadMapFromPerfCounters() {
        return ThreadPerformanceData.buildThreadMapFromPerfCounters(null);
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getProcessCount() {
        void var1_1;
        Psapi.PERFORMANCE_INFORMATION perfInfo;
        Psapi.PERFORMANCE_INFORMATION pERFORMANCE_INFORMATION = perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(pERFORMANCE_INFORMATION, pERFORMANCE_INFORMATION.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return var1_1.ProcessCount.intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getThreadCount() {
        void var1_1;
        Psapi.PERFORMANCE_INFORMATION perfInfo;
        Psapi.PERFORMANCE_INFORMATION pERFORMANCE_INFORMATION = perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(pERFORMANCE_INFORMATION, pERFORMANCE_INFORMATION.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return var1_1.ThreadCount.intValue();
    }

    @Override
    public long getSystemUptime() {
        return WindowsOperatingSystem.querySystemUptime();
    }

    private static long querySystemUptime() {
        if (IS_VISTA_OR_GREATER) {
            return Kernel32.INSTANCE.GetTickCount64() / 1000L;
        }
        return (long)Kernel32.INSTANCE.GetTickCount() / 1000L;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    /*
     * WARNING - void declaration
     */
    private static long querySystemBootTime() {
        String eventLog = systemLog.get();
        if (eventLog != null) {
            try {
                Advapi32Util.EventLogIterator iter = new Advapi32Util.EventLogIterator(null, eventLog, 8);
                long event6005Time = 0L;
                while (iter.hasNext()) {
                    Advapi32Util.EventLogRecord record = iter.next();
                    if (record.getStatusCode() == 12) {
                        return record.getRecord().TimeGenerated.longValue();
                    }
                    if (record.getStatusCode() != 6005) continue;
                    if (event6005Time > 0L) {
                        return event6005Time;
                    }
                    event6005Time = record.getRecord().TimeGenerated.longValue();
                }
                if (event6005Time > 0L) {
                    void var2_2;
                    return (long)var2_2;
                }
            }
            catch (Win32Exception win32Exception) {
                void var0;
                LOG.warn("Can't open event log \"{}\".", (Object)var0);
            }
        }
        return System.currentTimeMillis() / 1000L - WindowsOperatingSystem.querySystemUptime();
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new WindowsNetworkParams();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean enableDebugPrivilege() {
        WinNT.HANDLEByReference hToken;
        block7: {
            void var2_5;
            block6: {
                WinNT.LUID luid;
                boolean bl;
                block5: {
                    hToken = new WinNT.HANDLEByReference();
                    bl = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 40, hToken);
                    if (!bl) {
                        LOG.error("OpenProcessToken failed. Error: {}", (Object)Native.getLastError());
                        return false;
                    }
                    try {
                        luid = new WinNT.LUID();
                        bl = Advapi32.INSTANCE.LookupPrivilegeValue(null, "SeDebugPrivilege", luid);
                        if (bl) break block5;
                        LOG.error("LookupPrivilegeValue failed. Error: {}", (Object)Native.getLastError());
                    }
                    catch (Throwable throwable) {
                        void var0;
                        Kernel32.INSTANCE.CloseHandle(var0.getValue());
                        throw throwable;
                    }
                    Kernel32.INSTANCE.CloseHandle(hToken.getValue());
                    return false;
                }
                WinNT.TOKEN_PRIVILEGES tkp = new WinNT.TOKEN_PRIVILEGES(1);
                tkp.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES(luid, new WinDef.DWORD(2L));
                boolean success = Advapi32.INSTANCE.AdjustTokenPrivileges(hToken.getValue(), false, tkp, 0, null, null);
                int err = Native.getLastError();
                if (bl) break block6;
                LOG.error("AdjustTokenPrivileges failed. Error: {}", (Object)err);
                Kernel32.INSTANCE.CloseHandle(hToken.getValue());
                return false;
            }
            if (var2_5 != 1300) break block7;
            LOG.debug("Debug privileges not enabled.");
            Kernel32.INSTANCE.CloseHandle(hToken.getValue());
            return false;
        }
        Kernel32.INSTANCE.CloseHandle(hToken.getValue());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OSService[] getServices() {
        void var4_8;
        W32ServiceManager sm = new W32ServiceManager();
        try {
            void var3_5;
            sm.open(4);
            Winsvc.ENUM_SERVICE_STATUS_PROCESS[] services = sm.enumServicesStatusExProcess(48, 3, null);
            OSService[] svcArray = new OSService[services.length];
            for (int i = 0; i < services.length; ++i) {
                OSService.State state;
                switch (services[i].ServiceStatusProcess.dwCurrentState) {
                    case 1: {
                        state = OSService.State.STOPPED;
                        break;
                    }
                    case 4: {
                        state = OSService.State.RUNNING;
                        break;
                    }
                    default: {
                        state = OSService.State.OTHER;
                    }
                }
                svcArray[i] = new OSService(services[i].lpDisplayName, services[i].ServiceStatusProcess.dwProcessId, state);
            }
            var4_8 = var3_5;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sm.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Win32Exception ex) {
                void var1_2;
                LOG.error("Win32Exception: {}", (Object)var1_2.getMessage());
                return new OSService[0];
            }
        }
        sm.close();
        return var4_8;
    }

    /*
     * WARNING - void declaration
     */
    private static String querySystemLog() {
        void var0;
        String systemLog = GlobalConfig.get("oshi.os.windows.eventlog", "System");
        if (systemLog.isEmpty()) {
            return null;
        }
        WinNT.HANDLE hANDLE = Advapi32.INSTANCE.OpenEventLog(null, systemLog);
        if (hANDLE == null) {
            LOG.warn("Unable to open configured system Event log \"{}\". Calculating boot time from uptime.", (Object)systemLog);
            return null;
        }
        return var0;
    }

    @Override
    public List<OSDesktopWindow> getDesktopWindows(boolean visibleOnly) {
        return EnumWindows.queryDesktopWindows(visibleOnly);
    }

    static boolean isX86() {
        return X86;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isCurrentX86() {
        void var0;
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetNativeSystemInfo(sysinfo);
        return 0 == var0.processorArchitecture.pi.wProcessorArchitecture.intValue();
    }

    static boolean isWow() {
        return WOW;
    }

    /*
     * WARNING - void declaration
     */
    static boolean isWow(WinNT.HANDLE h) {
        void var1_1;
        WinNT.HANDLE hANDLE;
        if (X86) {
            return true;
        }
        IntByReference isWow = new IntByReference();
        Kernel32.INSTANCE.IsWow64Process(hANDLE, isWow);
        return var1_1.getValue() != 0;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isCurrentWow() {
        if (X86) {
            return true;
        }
        WinNT.HANDLE h = Kernel32.INSTANCE.GetCurrentProcess();
        if (h != null) {
            boolean bl;
            try {
                bl = WindowsOperatingSystem.isWow(h);
            }
            catch (Throwable throwable) {
                void var0;
                Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var0);
                throw throwable;
            }
            Kernel32.INSTANCE.CloseHandle(h);
            return bl;
        }
        return false;
    }

    static {
        WindowsOperatingSystem.enableDebugPrivilege();
        X86 = WindowsOperatingSystem.isCurrentX86();
        WOW = WindowsOperatingSystem.isCurrentWow();
    }
}

