/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.registry.ProcessPerformanceData;
import oshi.driver.windows.registry.ProcessWtsData;
import oshi.driver.windows.registry.ThreadPerformanceData;
import oshi.driver.windows.wmi.Win32Process;
import oshi.driver.windows.wmi.Win32ProcessCached;
import oshi.jna.platform.windows.NtDll;
import oshi.software.common.AbstractOSProcess;
import oshi.software.os.OSProcess;
import oshi.software.os.OSThread;
import oshi.software.os.windows.WindowsOSThread;
import oshi.software.os.windows.WindowsOperatingSystem;
import oshi.util.GlobalConfig;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public class WindowsOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOSProcess.class);
    public static final String OSHI_OS_WINDOWS_COMMANDLINE_BATCH = "oshi.os.windows.commandline.batch";
    private static final boolean USE_BATCH_COMMANDLINE = GlobalConfig.get("oshi.os.windows.commandline.batch", false);
    private static final boolean USE_PROCSTATE_SUSPENDED = GlobalConfig.get("oshi.os.windows.procstate.suspended", false);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final boolean IS_WINDOWS7_OR_GREATER = VersionHelpers.IsWindows7OrGreater();
    private final WindowsOperatingSystem os;
    private Supplier<Pair<String, String>> userInfo = Memoizer.memoize(this::queryUserInfo);
    private Supplier<Pair<String, String>> groupInfo = Memoizer.memoize(this::queryGroupInfo);
    private Supplier<String> currentWorkingDirectory = Memoizer.memoize(this::queryCwd);
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<List<String>> args = Memoizer.memoize(this::queryArguments);
    private Supplier<Triplet<String, String, Map<String, String>>> cwdCmdEnv = Memoizer.memoize(this::queryCwdCommandlineEnvironment);
    private String name;
    private String path;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long openFiles;
    private int bitness;
    private long pageFaults;

    /*
     * WARNING - void declaration
     */
    public WindowsOSProcess(int pid, WindowsOperatingSystem os, Map<Integer, ProcessPerformanceData.PerfCounterBlock> processMap, Map<Integer, ProcessWtsData.WtsInfo> processWtsMap, Map<Integer, ThreadPerformanceData.PerfCounterBlock> threadMap) {
        super(pid);
        void var1_1;
        void var3_3;
        void var2_2;
        this.os = os;
        this.bitness = var2_2.getBitness();
        this.updateAttributes((ProcessPerformanceData.PerfCounterBlock)var3_3.get(pid), processWtsMap.get((int)var1_1), threadMap);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine.get();
    }

    @Override
    public List<String> getArguments() {
        return this.args.get();
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.cwdCmdEnv.get().getC();
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return this.currentWorkingDirectory.get();
    }

    @Override
    public String getUser() {
        return this.userInfo.get().getA();
    }

    @Override
    public String getUserID() {
        return this.userInfo.get().getB();
    }

    @Override
    public String getGroup() {
        return this.groupInfo.get().getA();
    }

    @Override
    public String getGroupID() {
        return this.groupInfo.get().getB();
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getOpenFiles() {
        return this.openFiles;
    }

    @Override
    public int getBitness() {
        return this.bitness;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getAffinityMask() {
        WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID());
        if (pHandle != null) {
            void var1_1;
            try {
                void var3_4;
                BaseTSD.ULONG_PTRByReference processAffinity = new BaseTSD.ULONG_PTRByReference();
                BaseTSD.ULONG_PTRByReference systemAffinity = new BaseTSD.ULONG_PTRByReference();
                if (Kernel32.INSTANCE.GetProcessAffinityMask(pHandle, processAffinity, (BaseTSD.ULONG_PTRByReference)var3_4)) {
                    void var2_2;
                    long l = Pointer.nativeValue((Pointer)var2_2.getValue().toPointer());
                    return l;
                }
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(pHandle);
            }
            Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var1_1);
        }
        return 0L;
    }

    @Override
    public long getMinorFaults() {
        return this.pageFaults;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSThread> getThreadDetails() {
        void var1_1;
        Map<Integer, ThreadPerformanceData.PerfCounterBlock> threads = ThreadPerformanceData.buildThreadMapFromRegistry(Collections.singleton(this.getProcessID()));
        if (threads != null) {
            threads = ThreadPerformanceData.buildThreadMapFromPerfCounters(Collections.singleton(this.getProcessID()));
        }
        if (threads == null) {
            return Collections.emptyList();
        }
        return var1_1.entrySet().stream().map(entry -> {
            void var1_1;
            return new WindowsOSThread(this.getProcessID(), (Integer)entry.getKey(), this.name, (ThreadPerformanceData.PerfCounterBlock)var1_1.getValue());
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean updateAttributes() {
        void var3_3;
        void var1_1;
        void var2_2;
        Set<Integer> pids = Collections.singleton(this.getProcessID());
        Map<Integer, ProcessPerformanceData.PerfCounterBlock> pcb = ProcessPerformanceData.buildProcessMapFromRegistry(null);
        if (pcb == null) {
            pcb = ProcessPerformanceData.buildProcessMapFromPerfCounters(pids);
        }
        Map<Integer, ThreadPerformanceData.PerfCounterBlock> tcb = null;
        if (USE_PROCSTATE_SUSPENDED && (tcb = ThreadPerformanceData.buildThreadMapFromRegistry(null)) == null) {
            tcb = ThreadPerformanceData.buildThreadMapFromPerfCounters(null);
        }
        Map<Integer, ProcessWtsData.WtsInfo> wts = ProcessWtsData.queryProcessWtsMap(pids);
        return this.updateAttributes((ProcessPerformanceData.PerfCounterBlock)var2_2.get(this.getProcessID()), (ProcessWtsData.WtsInfo)var1_1.get(this.getProcessID()), (Map<Integer, ThreadPerformanceData.PerfCounterBlock>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateAttributes(ProcessPerformanceData.PerfCounterBlock pcb, ProcessWtsData.WtsInfo wts, Map<Integer, ThreadPerformanceData.PerfCounterBlock> threadMap) {
        WinNT.HANDLE pHandle;
        this.name = pcb.getName();
        this.path = ((ProcessWtsData.WtsInfo)wts).getPath();
        this.parentProcessID = pcb.getParentProcessID();
        this.threadCount = ((ProcessWtsData.WtsInfo)wts).getThreadCount();
        this.priority = pcb.getPriority();
        this.virtualSize = ((ProcessWtsData.WtsInfo)wts).getVirtualSize();
        this.residentSetSize = pcb.getResidentSetSize();
        this.kernelTime = ((ProcessWtsData.WtsInfo)wts).getKernelTime();
        this.userTime = ((ProcessWtsData.WtsInfo)wts).getUserTime();
        this.startTime = pcb.getStartTime();
        this.upTime = pcb.getUpTime();
        this.bytesRead = pcb.getBytesRead();
        this.bytesWritten = pcb.getBytesWritten();
        this.openFiles = ((ProcessWtsData.WtsInfo)wts).getOpenFiles();
        this.pageFaults = pcb.getPageFaults();
        this.state = OSProcess.State.RUNNING;
        if (threadMap != null) {
            int pid = this.getProcessID();
            for (ThreadPerformanceData.PerfCounterBlock tcb : threadMap.values()) {
                if (tcb.getOwningProcessID() != pid) continue;
                if (tcb.getThreadWaitReason() == 5) {
                    this.state = OSProcess.State.SUSPENDED;
                    continue;
                }
                this.state = OSProcess.State.RUNNING;
                break;
            }
        }
        if ((pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID())) != null) {
            try {
                WinNT.HANDLE token;
                WinNT.HANDLEByReference phToken;
                block14: {
                    IntByReference wow64;
                    if (IS_VISTA_OR_GREATER && this.bitness == 64 && Kernel32.INSTANCE.IsWow64Process(pHandle, wow64 = new IntByReference(0)) && wow64.getValue() > 0) {
                        this.bitness = 32;
                    }
                    phToken = new WinNT.HANDLEByReference();
                    try {
                        if (!IS_WINDOWS7_OR_GREATER) break block14;
                        this.path = Kernel32Util.QueryFullProcessImageName((WinNT.HANDLE)pHandle, (int)0);
                    }
                    catch (Win32Exception win32Exception) {
                        try {
                            this.state = OSProcess.State.INVALID;
                        }
                        catch (Throwable throwable) {
                            WinNT.HANDLE token2 = phToken.getValue();
                            if (token2 != null) {
                                void var2_3;
                                Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var2_3);
                            }
                            throw throwable;
                        }
                        token = phToken.getValue();
                        if (token != null) {
                            void var3_5;
                            Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var3_5);
                        }
                    }
                }
                if ((token = phToken.getValue()) != null) {
                    Kernel32.INSTANCE.CloseHandle(token);
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var1_1);
                throw throwable;
            }
            Kernel32.INSTANCE.CloseHandle(pHandle);
        }
        return !this.state.equals((Object)OSProcess.State.INVALID);
    }

    /*
     * WARNING - void declaration
     */
    private String queryCommandLine() {
        if (!this.cwdCmdEnv.get().getB().isEmpty()) {
            return this.cwdCmdEnv.get().getB();
        }
        if (USE_BATCH_COMMANDLINE) {
            return Win32ProcessCached.getInstance().getCommandLine(this.getProcessID(), this.getStartTime());
        }
        WbemcliUtil.WmiResult<Win32Process.CommandLineProperty> commandLineProcs = Win32Process.queryCommandLines(Collections.singleton(this.getProcessID()));
        if (commandLineProcs.getResultCount() > 0) {
            void var1_1;
            return WmiUtil.getString(var1_1, Win32Process.CommandLineProperty.COMMANDLINE, 0);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private List<String> queryArguments() {
        String cl = this.getCommandLine();
        if (!cl.isEmpty()) {
            void var1_1;
            return Arrays.asList(Shell32Util.CommandLineToArgv((String)var1_1));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private String queryCwd() {
        String cwd;
        if (!this.cwdCmdEnv.get().getA().isEmpty()) {
            return this.cwdCmdEnv.get().getA();
        }
        if (this.getProcessID() == this.os.getProcessId() && !(cwd = new File(".").getAbsolutePath()).isEmpty()) {
            void var1_1;
            return cwd.substring(0, var1_1.length() - 1);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private Pair<String, String> queryUserInfo() {
        void var1_1;
        Pair<String, String> pair2 = null;
        WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID());
        if (pHandle != null) {
            WinNT.HANDLEByReference phToken;
            block10: {
                phToken = new WinNT.HANDLEByReference();
                try {
                    if (Advapi32.INSTANCE.OpenProcessToken(pHandle, 10, phToken)) {
                        Advapi32Util.Account account = Advapi32Util.getTokenAccount((WinNT.HANDLE)phToken.getValue());
                        pair2 = new Pair<String, String>(account.name, account.sidString);
                        break block10;
                    }
                    int account = Kernel32.INSTANCE.GetLastError();
                    if (account == 5) break block10;
                    LOG.error("Failed to get process token for process {}: {}", (Object)this.getProcessID(), (Object)Kernel32.INSTANCE.GetLastError());
                }
                catch (Win32Exception e) {
                    try {
                        LOG.warn("Failed to query user info for process {} ({}): {}", new Object[]{this.getProcessID(), this.getName(), e.getMessage()});
                    }
                    catch (Throwable pair2) {
                        void var2_3;
                        WinNT.HANDLE token = phToken.getValue();
                        if (token != null) {
                            void var3_4;
                            Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var3_4);
                        }
                        Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var2_3);
                        throw pair2;
                    }
                    WinNT.HANDLE token = phToken.getValue();
                    if (token != null) {
                        Kernel32.INSTANCE.CloseHandle(token);
                    }
                    Kernel32.INSTANCE.CloseHandle(pHandle);
                }
            }
            WinNT.HANDLE token = phToken.getValue();
            if (token != null) {
                Kernel32.INSTANCE.CloseHandle(token);
            }
            Kernel32.INSTANCE.CloseHandle(pHandle);
        }
        if (pair2 == null) {
            return new Pair<String, String>("unknown", "unknown");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Pair<String, String> queryGroupInfo() {
        void var1_1;
        Pair<String, String> pair = null;
        WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID());
        if (pHandle != null) {
            void var2_2;
            void var3_3;
            WinNT.HANDLEByReference phToken = new WinNT.HANDLEByReference();
            if (Advapi32.INSTANCE.OpenProcessToken(pHandle, 10, phToken)) {
                Advapi32Util.Account account = Advapi32Util.getTokenPrimaryGroup((WinNT.HANDLE)phToken.getValue());
                pair = new Pair<String, String>(account.name, account.sidString);
            } else {
                int account = Kernel32.INSTANCE.GetLastError();
                if (account != 5) {
                    LOG.error("Failed to get process token for process {}: {}", (Object)this.getProcessID(), (Object)Kernel32.INSTANCE.GetLastError());
                }
            }
            WinNT.HANDLE token = var3_3.getValue();
            if (token != null) {
                Kernel32.INSTANCE.CloseHandle(token);
            }
            Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var2_2);
        }
        if (pair == null) {
            return new Pair<String, String>("unknown", "unknown");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Triplet<String, String, Map<String, String>> queryCwdCommandlineEnvironment() {
        WinNT.HANDLE h = Kernel32.INSTANCE.OpenProcess(1040, false, this.getProcessID());
        if (h != null) {
            block7: {
                String cl;
                String cwd;
                block11: {
                    Triplet<String, String, Map<String, String>> triplet;
                    void var3_4;
                    NtDll.RTL_USER_PROCESS_PARAMETERS upp;
                    Object nRead;
                    block10: {
                        Object peb;
                        block9: {
                            Object pbi;
                            block8: {
                                Triplet<String, String, Map<String, String>> triplet2;
                                try {
                                    if (WindowsOperatingSystem.isX86() != WindowsOperatingSystem.isWow(h)) break block7;
                                    nRead = new IntByReference();
                                    pbi = new NtDll.PROCESS_BASIC_INFORMATION();
                                    int n = NtDll.INSTANCE.NtQueryInformationProcess(h, 0, pbi.getPointer(), pbi.size(), (IntByReference)nRead);
                                    if (n == 0) break block8;
                                    triplet2 = WindowsOSProcess.defaultCwdCommandlineEnvironment();
                                }
                                catch (Throwable throwable) {
                                    void var1_1;
                                    Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)var1_1);
                                    throw throwable;
                                }
                                Kernel32.INSTANCE.CloseHandle(h);
                                return triplet2;
                            }
                            pbi.read();
                            peb = new NtDll.PEB();
                            Kernel32.INSTANCE.ReadProcessMemory(h, pbi.PebBaseAddress, peb.getPointer(), peb.size(), nRead);
                            if (nRead.getValue() != 0) break block9;
                            pbi = WindowsOSProcess.defaultCwdCommandlineEnvironment();
                            Kernel32.INSTANCE.CloseHandle(h);
                            return pbi;
                        }
                        peb.read();
                        upp = new NtDll.RTL_USER_PROCESS_PARAMETERS();
                        Kernel32.INSTANCE.ReadProcessMemory(h, peb.ProcessParameters, upp.getPointer(), upp.size(), nRead);
                        if (nRead.getValue() != 0) break block10;
                        peb = WindowsOSProcess.defaultCwdCommandlineEnvironment();
                        Kernel32.INSTANCE.CloseHandle(h);
                        return peb;
                    }
                    upp.read();
                    cwd = WindowsOSProcess.readUnicodeString(h, upp.CurrentDirectory.DosPath);
                    cl = WindowsOSProcess.readUnicodeString(h, upp.CommandLine);
                    int envSize = upp.EnvironmentSize.intValue();
                    if (envSize <= 0) break block11;
                    Memory buffer = new Memory((long)envSize);
                    Kernel32.INSTANCE.ReadProcessMemory(h, var3_4.Environment, (Pointer)buffer, envSize, nRead);
                    if (nRead.getValue() <= 0) break block11;
                    char[] cArray = buffer.getCharArray(0L, envSize / 2);
                    nRead = cArray;
                    Map<String, String> envMap = ParseUtil.parseCharArrayToStringMap(cArray);
                    envMap.remove("");
                    triplet = new Triplet<String, String, Map<String, String>>(cwd, cl, Collections.unmodifiableMap(triplet));
                    Kernel32.INSTANCE.CloseHandle(h);
                    return triplet;
                }
                Triplet<String, String, Map<String, String>> triplet = new Triplet<String, String, Map<String, String>>(cwd, cl, Collections.emptyMap());
                Kernel32.INSTANCE.CloseHandle(h);
                return triplet;
            }
            Kernel32.INSTANCE.CloseHandle(h);
        }
        return WindowsOSProcess.defaultCwdCommandlineEnvironment();
    }

    private static Triplet<String, String, Map<String, String>> defaultCwdCommandlineEnvironment() {
        return new Triplet<String, String, Map<String, String>>("", "", Collections.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    private static String readUnicodeString(WinNT.HANDLE h, NtDll.UNICODE_STRING s) {
        IntByReference nRead = new IntByReference();
        if (s.Length > 0) {
            void var2_2;
            void var1_1;
            WinNT.HANDLE hANDLE;
            Memory m = new Memory((long)s.Length + 2L);
            m.clear();
            Kernel32.INSTANCE.ReadProcessMemory(hANDLE, s.Buffer, (Pointer)m, (int)var1_1.Length, nRead);
            if (var2_2.getValue() > 0) {
                void var3_3;
                return var3_3.getWideString(0L);
            }
        }
        return "";
    }
}

