/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.ptr.IntByReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractNetworkParams;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
final class WindowsNetworkParams
extends AbstractNetworkParams {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsNetworkParams.class);
    private static final int COMPUTER_NAME_DNS_DOMAIN_FULLY_QUALIFIED = 3;

    WindowsNetworkParams() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getDomainName() {
        void var1_1;
        void var2_2;
        char[] buffer = new char[256];
        IntByReference bufferSize = new IntByReference(buffer.length);
        if (!Kernel32.INSTANCE.GetComputerNameEx(3, buffer, (IntByReference)var2_2)) {
            LOG.error("Failed to get dns domain name. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return "";
        }
        return Native.toString((char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String[] getDnsServers() {
        void var2_3;
        IntByReference bufferSize = new IntByReference();
        int ret = IPHlpAPI.INSTANCE.GetNetworkParams(null, bufferSize);
        if (ret != 111) {
            LOG.error("Failed to get network parameters buffer size. Error code: {}", (Object)ret);
            return new String[0];
        }
        Memory buffer = new Memory((long)bufferSize.getValue());
        ret = IPHlpAPI.INSTANCE.GetNetworkParams((Pointer)buffer, bufferSize);
        if (ret != 0) {
            LOG.error("Failed to get network parameters. Error code: {}", (Object)ret);
            return new String[0];
        }
        IPHlpAPI.FIXED_INFO fixedInfo = new IPHlpAPI.FIXED_INFO((Pointer)buffer);
        ArrayList<void> list = new ArrayList<void>();
        IPHlpAPI.IP_ADDR_STRING dns = fixedInfo.DnsServerList;
        while (dns != null) {
            void var3_4;
            String addr = Native.toString((byte[])dns.IpAddress.String, (Charset)StandardCharsets.US_ASCII);
            int nullPos = addr.indexOf(0);
            if (nullPos != -1) {
                addr = addr.substring(0, nullPos);
            }
            list.add(var3_4);
            dns = dns.Next;
        }
        return var2_3.toArray(new String[0]);
    }

    @Override
    public final String getHostName() {
        return Kernel32Util.getComputerName();
    }

    @Override
    public final String getIpv4DefaultGateway() {
        return WindowsNetworkParams.parseIpv4Route();
    }

    @Override
    public final String getIpv6DefaultGateway() {
        return WindowsNetworkParams.parseIpv6Route();
    }

    /*
     * WARNING - void declaration
     */
    private static String parseIpv4Route() {
        Object object = ExecutingCommand.runNative("route print -4 0.0.0.0");
        object = object.iterator();
        while (object.hasNext()) {
            void var1_1;
            String line = (String)object.next();
            String[] fields = ParseUtil.whitespaces.split(line.trim());
            if (fields.length <= 2 || !"0.0.0.0".equals(fields[0])) continue;
            return var1_1[2];
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private static String parseIpv6Route() {
        Object object = ExecutingCommand.runNative("route print -6 ::/0");
        object = object.iterator();
        while (object.hasNext()) {
            void var1_1;
            String line = (String)object.next();
            String[] fields = ParseUtil.whitespaces.split(line.trim());
            if (fields.length <= 3 || !"::/0".equals(fields[2])) continue;
            return var1_1[3];
        }
        return "";
    }
}

