/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractInternetProtocolStats;
import oshi.software.os.InternetProtocolStats;
import oshi.util.ParseUtil;

@ThreadSafe
public class WindowsInternetProtocolStats
extends AbstractInternetProtocolStats {
    private static final IPHlpAPI IPHLP = IPHlpAPI.INSTANCE;
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        void var1_1;
        IPHlpAPI.MIB_TCPSTATS stats = new IPHlpAPI.MIB_TCPSTATS();
        IPHLP.GetTcpStatisticsEx(stats, 2);
        return new InternetProtocolStats.TcpStats(stats.dwCurrEstab, stats.dwActiveOpens, stats.dwPassiveOpens, stats.dwAttemptFails, stats.dwEstabResets, stats.dwOutSegs, stats.dwInSegs, stats.dwRetransSegs, stats.dwInErrs, var1_1.dwOutRsts);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.TcpStats getTCPv6Stats() {
        void var1_1;
        IPHlpAPI.MIB_TCPSTATS stats = new IPHlpAPI.MIB_TCPSTATS();
        IPHLP.GetTcpStatisticsEx(stats, 23);
        return new InternetProtocolStats.TcpStats(stats.dwCurrEstab, stats.dwActiveOpens, stats.dwPassiveOpens, stats.dwAttemptFails, stats.dwEstabResets, stats.dwOutSegs, stats.dwInSegs, stats.dwRetransSegs, stats.dwInErrs, var1_1.dwOutRsts);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        void var1_1;
        IPHlpAPI.MIB_UDPSTATS stats = new IPHlpAPI.MIB_UDPSTATS();
        IPHLP.GetUdpStatisticsEx(stats, 2);
        return new InternetProtocolStats.UdpStats(stats.dwOutDatagrams, stats.dwInDatagrams, stats.dwNoPorts, var1_1.dwInErrors);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        void var1_1;
        IPHlpAPI.MIB_UDPSTATS stats = new IPHlpAPI.MIB_UDPSTATS();
        IPHLP.GetUdpStatisticsEx(stats, 23);
        return new InternetProtocolStats.UdpStats(stats.dwOutDatagrams, stats.dwInDatagrams, stats.dwNoPorts, var1_1.dwInErrors);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<InternetProtocolStats.IPConnection> getConnections() {
        if (IS_VISTA_OR_GREATER) {
            void var1_1;
            ArrayList<InternetProtocolStats.IPConnection> conns = new ArrayList<InternetProtocolStats.IPConnection>();
            conns.addAll(WindowsInternetProtocolStats.queryTCPv4Connections());
            conns.addAll(WindowsInternetProtocolStats.queryTCPv6Connections());
            conns.addAll(WindowsInternetProtocolStats.queryUDPv4Connections());
            conns.addAll(WindowsInternetProtocolStats.queryUDPv6Connections());
            return var1_1;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static List<InternetProtocolStats.IPConnection> queryTCPv4Connections() {
        void var0;
        Memory buf;
        int size;
        ArrayList<InternetProtocolStats.IPConnection> conns = new ArrayList<InternetProtocolStats.IPConnection>();
        IntByReference sizePtr = new IntByReference();
        IPHLP.GetExtendedTcpTable(null, sizePtr, false, 2, 5, 0);
        do {
            size = sizePtr.getValue();
            buf = new Memory((long)size);
            IPHLP.GetExtendedTcpTable((Pointer)buf, sizePtr, false, 2, 5, 0);
        } while (size < sizePtr.getValue());
        IPHlpAPI.MIB_TCPTABLE_OWNER_PID tcpTable = new IPHlpAPI.MIB_TCPTABLE_OWNER_PID((Pointer)buf);
        for (int i = 0; i < tcpTable.dwNumEntries; ++i) {
            void var3_3;
            IPHlpAPI.MIB_TCPROW_OWNER_PID row = tcpTable.table[i];
            conns.add(new InternetProtocolStats.IPConnection("tcp4", ParseUtil.parseIntToIP(row.dwLocalAddr), ParseUtil.bigEndian16ToLittleEndian(row.dwLocalPort), ParseUtil.parseIntToIP(row.dwRemoteAddr), ParseUtil.bigEndian16ToLittleEndian(row.dwRemotePort), WindowsInternetProtocolStats.stateLookup(row.dwState), 0, 0, var3_3.dwOwningPid));
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static List<InternetProtocolStats.IPConnection> queryTCPv6Connections() {
        void var0;
        Memory buf;
        int size;
        ArrayList<InternetProtocolStats.IPConnection> conns = new ArrayList<InternetProtocolStats.IPConnection>();
        IntByReference sizePtr = new IntByReference();
        IPHLP.GetExtendedTcpTable(null, sizePtr, false, 23, 5, 0);
        do {
            size = sizePtr.getValue();
            buf = new Memory((long)size);
            IPHLP.GetExtendedTcpTable((Pointer)buf, sizePtr, false, 23, 5, 0);
        } while (size < sizePtr.getValue());
        IPHlpAPI.MIB_TCP6TABLE_OWNER_PID tcpTable = new IPHlpAPI.MIB_TCP6TABLE_OWNER_PID((Pointer)buf);
        for (int i = 0; i < tcpTable.dwNumEntries; ++i) {
            void var3_3;
            IPHlpAPI.MIB_TCP6ROW_OWNER_PID row = tcpTable.table[i];
            conns.add(new InternetProtocolStats.IPConnection("tcp6", row.LocalAddr, ParseUtil.bigEndian16ToLittleEndian(row.dwLocalPort), row.RemoteAddr, ParseUtil.bigEndian16ToLittleEndian(row.dwRemotePort), WindowsInternetProtocolStats.stateLookup(row.State), 0, 0, var3_3.dwOwningPid));
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static List<InternetProtocolStats.IPConnection> queryUDPv4Connections() {
        void var0;
        Memory buf;
        int size;
        ArrayList<InternetProtocolStats.IPConnection> conns = new ArrayList<InternetProtocolStats.IPConnection>();
        IntByReference sizePtr = new IntByReference();
        IPHLP.GetExtendedUdpTable(null, sizePtr, false, 2, 1, 0);
        do {
            size = sizePtr.getValue();
            buf = new Memory((long)size);
            IPHLP.GetExtendedUdpTable((Pointer)buf, sizePtr, false, 2, 1, 0);
        } while (size < sizePtr.getValue());
        IPHlpAPI.MIB_UDPTABLE_OWNER_PID udpTable = new IPHlpAPI.MIB_UDPTABLE_OWNER_PID((Pointer)buf);
        for (int i = 0; i < udpTable.dwNumEntries; ++i) {
            void var3_3;
            IPHlpAPI.MIB_UDPROW_OWNER_PID row = udpTable.table[i];
            conns.add(new InternetProtocolStats.IPConnection("udp4", ParseUtil.parseIntToIP(row.dwLocalAddr), ParseUtil.bigEndian16ToLittleEndian(row.dwLocalPort), new byte[0], 0, InternetProtocolStats.TcpState.NONE, 0, 0, var3_3.dwOwningPid));
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static List<InternetProtocolStats.IPConnection> queryUDPv6Connections() {
        void var0;
        Memory buf;
        int size;
        ArrayList<InternetProtocolStats.IPConnection> conns = new ArrayList<InternetProtocolStats.IPConnection>();
        IntByReference sizePtr = new IntByReference();
        IPHLP.GetExtendedUdpTable(null, sizePtr, false, 23, 1, 0);
        do {
            size = sizePtr.getValue();
            buf = new Memory((long)size);
            IPHLP.GetExtendedUdpTable((Pointer)buf, sizePtr, false, 23, 1, 0);
        } while (size < sizePtr.getValue());
        IPHlpAPI.MIB_UDP6TABLE_OWNER_PID udpTable = new IPHlpAPI.MIB_UDP6TABLE_OWNER_PID((Pointer)buf);
        for (int i = 0; i < udpTable.dwNumEntries; ++i) {
            void var3_3;
            IPHlpAPI.MIB_UDP6ROW_OWNER_PID row = udpTable.table[i];
            conns.add(new InternetProtocolStats.IPConnection("udp6", row.ucLocalAddr, ParseUtil.bigEndian16ToLittleEndian(row.dwLocalPort), new byte[0], 0, InternetProtocolStats.TcpState.NONE, 0, 0, var3_3.dwOwningPid));
        }
        return var0;
    }

    private static InternetProtocolStats.TcpState stateLookup(int state) {
        switch (state) {
            case 1: 
            case 12: {
                return InternetProtocolStats.TcpState.CLOSED;
            }
            case 2: {
                return InternetProtocolStats.TcpState.LISTEN;
            }
            case 3: {
                return InternetProtocolStats.TcpState.SYN_SENT;
            }
            case 4: {
                return InternetProtocolStats.TcpState.SYN_RECV;
            }
            case 5: {
                return InternetProtocolStats.TcpState.ESTABLISHED;
            }
            case 6: {
                return InternetProtocolStats.TcpState.FIN_WAIT_1;
            }
            case 7: {
                return InternetProtocolStats.TcpState.FIN_WAIT_2;
            }
            case 8: {
                return InternetProtocolStats.TcpState.CLOSE_WAIT;
            }
            case 9: {
                return InternetProtocolStats.TcpState.CLOSING;
            }
            case 10: {
                return InternetProtocolStats.TcpState.LAST_ACK;
            }
            case 11: {
                return InternetProtocolStats.TcpState.TIME_WAIT;
            }
        }
        return InternetProtocolStats.TcpState.UNKNOWN;
    }
}

