/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.common.AbstractOSThread;
import oshi.software.os.OSProcess;
import oshi.software.os.unix.solaris.SolarisOSProcess;
import oshi.software.os.unix.solaris.SolarisOperatingSystem;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public class SolarisOSThread
extends AbstractOSThread {
    private int threadId;
    private OSProcess.State state = OSProcess.State.INVALID;
    private long startMemoryAddress;
    private long contextSwitches;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private int priority;

    /*
     * WARNING - void declaration
     */
    public SolarisOSThread(int pid, Map<SolarisOSProcess.PsThreadColumns, String> psMap, Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap) {
        super((int)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.updateAttributes((Map<SolarisOSProcess.PsThreadColumns, String>)var2_2, (Map<SolarisOperatingSystem.PrstatKeywords, String>)var3_3);
    }

    @Override
    public int getThreadId() {
        return this.threadId;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public long getStartMemoryAddress() {
        return this.startMemoryAddress;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean updateAttributes() {
        int pid = this.getOwningProcessId();
        List<String> threadList = ExecutingCommand.runNative("ps -o " + SolarisOSProcess.PS_THREAD_COLUMNS + " -p " + pid);
        if (threadList.size() > 1) {
            String lwpStr = Integer.toString(this.threadId);
            for (String psOutput : threadList) {
                void var1_2;
                void var2_3;
                Map<SolarisOSProcess.PsThreadColumns, String> threadMap = ParseUtil.stringToEnumMap(SolarisOSProcess.PsThreadColumns.class, psOutput.trim(), ' ');
                if (!threadMap.containsKey((Object)SolarisOSProcess.PsThreadColumns.PRI) || !lwpStr.equals(threadMap.get((Object)SolarisOSProcess.PsThreadColumns.LWP))) continue;
                Object prstatList = ExecutingCommand.runNative("prstat -L -v -p " + pid + " 1 1");
                String prstatRow = "";
                prstatList = prstatList.iterator();
                while (prstatList.hasNext()) {
                    String string = (String)prstatList.next();
                    String row = string.trim();
                    if (!row.endsWith("/" + lwpStr)) continue;
                    prstatRow = row;
                    break;
                }
                Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap = ParseUtil.stringToEnumMap(SolarisOperatingSystem.PrstatKeywords.class, (String)var2_3, ' ');
                return this.updateAttributes(threadMap, (Map<SolarisOperatingSystem.PrstatKeywords, String>)var1_2);
            }
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateAttributes(Map<SolarisOSProcess.PsThreadColumns, String> psMap, Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.threadId = ParseUtil.parseIntOrDefault(psMap.get((Object)SolarisOSProcess.PsThreadColumns.LWP), 0);
        this.state = SolarisOSProcess.getStateFromOutput(psMap.get((Object)SolarisOSProcess.PsThreadColumns.S).charAt(0));
        long elapsedTime = ParseUtil.parseDHMSOrDefault(psMap.get((Object)SolarisOSProcess.PsThreadColumns.ETIME), 0L);
        this.upTime = elapsedTime < 1L ? 1L : var3_3;
        long now = System.currentTimeMillis();
        this.startTime = now - this.upTime;
        this.kernelTime = 0L;
        this.userTime = ParseUtil.parseDHMSOrDefault(psMap.get((Object)SolarisOSProcess.PsThreadColumns.TIME), 0L);
        this.startMemoryAddress = ParseUtil.hexStringToLong(psMap.get((Object)SolarisOSProcess.PsThreadColumns.ADDR), 0L);
        this.priority = ParseUtil.parseIntOrDefault((String)var1_1.get((Object)SolarisOSProcess.PsThreadColumns.PRI), 0);
        long nonVoluntaryContextSwitches = ParseUtil.parseLongOrDefault(prstatMap.get((Object)SolarisOperatingSystem.PrstatKeywords.ICX), 0L);
        long voluntaryContextSwitches = ParseUtil.parseLongOrDefault((String)var2_2.get((Object)SolarisOperatingSystem.PrstatKeywords.VCX), 0L);
        this.contextSwitches = voluntaryContextSwitches + nonVoluntaryContextSwitches;
        return true;
    }
}

