/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.solaris.PsInfo;
import oshi.software.common.AbstractOSProcess;
import oshi.software.os.OSProcess;
import oshi.software.os.OSThread;
import oshi.software.os.unix.solaris.SolarisOSThread;
import oshi.software.os.unix.solaris.SolarisOperatingSystem;
import oshi.util.ExecutingCommand;
import oshi.util.LsofUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class SolarisOSProcess
extends AbstractOSProcess {
    static final String PS_THREAD_COLUMNS = Arrays.stream(PsThreadColumns.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(","));
    private Supplier<Integer> bitness = Memoizer.memoize(this::queryBitness);
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<Pair<List<String>, Map<String, String>>> cmdEnv = Memoizer.memoize(this::queryCommandlineEnvironment);
    private String name;
    private String path = "";
    private String commandLineBackup;
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long contextSwitches = 0L;

    /*
     * WARNING - void declaration
     */
    public SolarisOSProcess(int pid, Map<SolarisOperatingSystem.PsKeywords, String> psMap, Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap) {
        super((int)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.updateAttributes((Map<SolarisOperatingSystem.PsKeywords, String>)var2_2, (Map<SolarisOperatingSystem.PrstatKeywords, String>)var3_3);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine.get();
    }

    /*
     * WARNING - void declaration
     */
    private String queryCommandLine() {
        void var1_1;
        String cl = String.join((CharSequence)" ", this.getArguments());
        if (cl.isEmpty()) {
            return this.commandLineBackup;
        }
        return var1_1;
    }

    @Override
    public List<String> getArguments() {
        return this.cmdEnv.get().getA();
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.cmdEnv.get().getB();
    }

    private Pair<List<String>, Map<String, String>> queryCommandlineEnvironment() {
        return PsInfo.queryArgsEnv(this.getProcessID());
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return LsofUtil.getCwd(this.getProcessID());
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public long getOpenFiles() {
        return LsofUtil.getOpenFiles(this.getProcessID());
    }

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    /*
     * WARNING - void declaration
     */
    private int queryBitness() {
        Object object = ExecutingCommand.runNative("pflags " + this.getProcessID());
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            String line = (String)object.next();
            if (!line.contains("data model")) continue;
            if (line.contains("LP32")) {
                return 32;
            }
            if (!var2_2.contains("LP64")) continue;
            return 64;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getAffinityMask() {
        void var1_1;
        long bitMask = 0L;
        Object cpuset = ExecutingCommand.getFirstAnswer("pbind -q " + this.getProcessID());
        if (((String)cpuset).isEmpty()) {
            cpuset = ExecutingCommand.runNative("psrinfo");
            cpuset = cpuset.iterator();
            while (cpuset.hasNext()) {
                String proc = cpuset.next();
                String[] stringArray = ParseUtil.whitespaces.split(proc);
                int bitToSet = ParseUtil.parseIntOrDefault(stringArray[0], -1);
                if (bitToSet < 0) continue;
                bitMask |= 1L << bitToSet;
            }
            return bitMask;
        }
        if (((String)cpuset).endsWith(".") && ((String)cpuset).contains("strongly bound to processor(s)")) {
            int bitToSet;
            String parse = ((String)cpuset).substring(0, ((String)cpuset).length() - 1);
            String[] split = ParseUtil.whitespaces.split(parse);
            for (int i = split.length - 1; i >= 0 && (bitToSet = ParseUtil.parseIntOrDefault(split[i], -1)) >= 0; --i) {
                bitMask |= 1L << bitToSet;
            }
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSThread> getThreadDetails() {
        void var1_1;
        ArrayList<SolarisOSThread> threads = new ArrayList<SolarisOSThread>();
        List<String> threadList = ExecutingCommand.runNative("ps -o " + PS_THREAD_COLUMNS + " -p " + this.getProcessID());
        if (threadList.size() > 1) {
            Iterator<Object> iterator;
            List<String> prstatList = ExecutingCommand.runNative("prstat -L -v -p " + this.getProcessID() + " 1 1");
            HashMap<String, String> prstatRowMap = new HashMap<String, String>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String row = string.trim();
                int idx = row.lastIndexOf(47);
                if (idx <= 0) continue;
                prstatRowMap.put(row.substring(idx + 1), row);
            }
            threadList.remove(0);
            for (String thread : threadList) {
                void var2_2;
                Map<PsThreadColumns, String> psMap = ParseUtil.stringToEnumMap(PsThreadColumns.class, thread.trim(), ' ');
                if (!psMap.containsKey((Object)PsThreadColumns.PRI)) continue;
                String lwpStr = psMap.get((Object)PsThreadColumns.LWP);
                Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap = ParseUtil.stringToEnumMap(SolarisOperatingSystem.PrstatKeywords.class, prstatRowMap.getOrDefault(lwpStr, ""), ' ');
                threads.add(new SolarisOSThread(this.getProcessID(), psMap, (Map<SolarisOperatingSystem.PrstatKeywords, String>)var2_2));
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean updateAttributes() {
        Map<SolarisOperatingSystem.PsKeywords, String> psMap;
        int pid = this.getProcessID();
        List<String> procList = ExecutingCommand.runNative("ps -o " + SolarisOperatingSystem.PS_COMMAND_ARGS + " -p " + pid);
        if (procList.size() > 1 && (psMap = ParseUtil.stringToEnumMap(SolarisOperatingSystem.PsKeywords.class, procList.get(1).trim(), ' ')).containsKey((Object)SolarisOperatingSystem.PsKeywords.ARGS)) {
            void var3_4;
            void var1_2;
            String pidStr = psMap.get((Object)SolarisOperatingSystem.PsKeywords.PID);
            Object prstatList = ExecutingCommand.runNative("prstat -v -p " + pidStr + " 1 1");
            String prstatRow = "";
            prstatList = prstatList.iterator();
            while (prstatList.hasNext()) {
                String string = (String)prstatList.next();
                String row = string.trim();
                if (!row.startsWith(pidStr + " ")) continue;
                prstatRow = row;
                break;
            }
            Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap = ParseUtil.stringToEnumMap(SolarisOperatingSystem.PrstatKeywords.class, prstatRow, ' ');
            return this.updateAttributes((Map<SolarisOperatingSystem.PsKeywords, String>)var1_2, (Map<SolarisOperatingSystem.PrstatKeywords, String>)var3_4);
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateAttributes(Map<SolarisOperatingSystem.PsKeywords, String> psMap, Map<SolarisOperatingSystem.PrstatKeywords, String> prstatMap) {
        void var1_1;
        void var3_3;
        long now = System.currentTimeMillis();
        this.state = SolarisOSProcess.getStateFromOutput(psMap.get((Object)SolarisOperatingSystem.PsKeywords.S).charAt(0));
        this.parentProcessID = ParseUtil.parseIntOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.PPID), 0);
        this.user = psMap.get((Object)SolarisOperatingSystem.PsKeywords.USER);
        this.userID = psMap.get((Object)SolarisOperatingSystem.PsKeywords.UID);
        this.group = psMap.get((Object)SolarisOperatingSystem.PsKeywords.GROUP);
        this.groupID = psMap.get((Object)SolarisOperatingSystem.PsKeywords.GID);
        this.threadCount = ParseUtil.parseIntOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.NLWP), 0);
        this.priority = ParseUtil.parseIntOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.PRI), 0);
        this.virtualSize = ParseUtil.parseLongOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.VSZ), 0L) << 10;
        this.residentSetSize = ParseUtil.parseLongOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.RSS), 0L) << 10;
        long elapsedTime = ParseUtil.parseDHMSOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.ETIME), 0L);
        this.upTime = elapsedTime < 1L ? 1L : elapsedTime;
        this.startTime = var3_3 - this.upTime;
        this.kernelTime = 0L;
        this.userTime = ParseUtil.parseDHMSOrDefault(psMap.get((Object)SolarisOperatingSystem.PsKeywords.TIME), 0L);
        this.path = psMap.get((Object)SolarisOperatingSystem.PsKeywords.COMM);
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        this.commandLineBackup = (String)var1_1.get((Object)SolarisOperatingSystem.PsKeywords.ARGS);
        if (prstatMap.containsKey((Object)SolarisOperatingSystem.PrstatKeywords.ICX)) {
            void var2_2;
            long nonVoluntaryContextSwitches = ParseUtil.parseLongOrDefault(prstatMap.get((Object)SolarisOperatingSystem.PrstatKeywords.ICX), 0L);
            long voluntaryContextSwitches = ParseUtil.parseLongOrDefault((String)var2_2.get((Object)SolarisOperatingSystem.PrstatKeywords.VCX), 0L);
            this.contextSwitches = voluntaryContextSwitches + nonVoluntaryContextSwitches;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static OSProcess.State getStateFromOutput(char stateValue) {
        void var0_1;
        switch (stateValue) {
            case 'O': {
                OSProcess.State state = OSProcess.State.RUNNING;
                break;
            }
            case 'S': {
                OSProcess.State state = OSProcess.State.SLEEPING;
                break;
            }
            case 'R': 
            case 'W': {
                OSProcess.State state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                OSProcess.State state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                OSProcess.State state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                OSProcess.State state = OSProcess.State.OTHER;
            }
        }
        return var0_1;
    }

    static enum PsThreadColumns {
        LWP,
        S,
        ETIME,
        TIME,
        ADDR,
        PRI;

    }
}

