/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.freebsd;

import com.sun.jna.Native;
import com.sun.jna.ptr.PointerByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.CLibrary;
import oshi.jna.platform.unix.freebsd.FreeBsdLibc;
import oshi.software.common.AbstractNetworkParams;
import oshi.util.ExecutingCommand;

@ThreadSafe
final class FreeBsdNetworkParams
extends AbstractNetworkParams {
    private static final Logger LOG = LoggerFactory.getLogger(FreeBsdNetworkParams.class);
    private static final FreeBsdLibc LIBC = FreeBsdLibc.INSTANCE;

    FreeBsdNetworkParams() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getDomainName() {
        void var1_3;
        void var3_5;
        void var2_4;
        CLibrary.Addrinfo hint = new CLibrary.Addrinfo();
        new CLibrary.Addrinfo().ai_flags = 2;
        String hostname = ((AbstractNetworkParams)this).getHostName();
        PointerByReference ptr = new PointerByReference();
        int res22 = LIBC.getaddrinfo((String)var2_4, null, hint, ptr);
        if (res22 > 0) {
            if (LOG.isErrorEnabled()) {
                LOG.warn("Failed getaddrinfo(): {}", (Object)LIBC.gai_strerror(res22));
            }
            return "";
        }
        CLibrary.Addrinfo res22 = new CLibrary.Addrinfo(ptr.getValue());
        String canonname = res22.ai_canonname.trim();
        LIBC.freeaddrinfo(var3_5.getValue());
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getHostName() {
        void var1_1;
        byte[] hostnameBuffer = new byte[256];
        if (0 != LIBC.gethostname(hostnameBuffer, hostnameBuffer.length)) {
            return super.getHostName();
        }
        return Native.toString((byte[])var1_1);
    }

    @Override
    public final String getIpv4DefaultGateway() {
        return FreeBsdNetworkParams.searchGateway(ExecutingCommand.runNative("route -4 get default"));
    }

    @Override
    public final String getIpv6DefaultGateway() {
        return FreeBsdNetworkParams.searchGateway(ExecutingCommand.runNative("route -6 get default"));
    }
}

