/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.freebsd;

import com.sun.jna.Memory;
import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.NetStat;
import oshi.jna.platform.unix.CLibrary;
import oshi.software.common.AbstractInternetProtocolStats;
import oshi.software.os.InternetProtocolStats;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class FreeBsdInternetProtocolStats
extends AbstractInternetProtocolStats {
    private Supplier<Pair<Long, Long>> establishedv4v6 = Memoizer.memoize(NetStat::queryTcpnetstat, Memoizer.defaultExpiration());
    private Supplier<CLibrary.BsdTcpstat> tcpstat = Memoizer.memoize(FreeBsdInternetProtocolStats::queryTcpstat, Memoizer.defaultExpiration());
    private Supplier<CLibrary.BsdUdpstat> udpstat = Memoizer.memoize(FreeBsdInternetProtocolStats::queryUdpstat, Memoizer.defaultExpiration());

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        void var1_1;
        CLibrary.BsdTcpstat tcp = this.tcpstat.get();
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getA(), ParseUtil.unsignedIntToLong(tcp.tcps_connattempt), ParseUtil.unsignedIntToLong(tcp.tcps_accepts), ParseUtil.unsignedIntToLong(tcp.tcps_conndrops), ParseUtil.unsignedIntToLong(tcp.tcps_drops), ParseUtil.unsignedIntToLong(tcp.tcps_sndpack), ParseUtil.unsignedIntToLong(tcp.tcps_rcvpack), ParseUtil.unsignedIntToLong(tcp.tcps_sndrexmitpack), ParseUtil.unsignedIntToLong(tcp.tcps_rcvbadsum + tcp.tcps_rcvbadoff + tcp.tcps_rcvmemdrop + var1_1.tcps_rcvshort), 0L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        void var1_1;
        CLibrary.BsdUdpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(ParseUtil.unsignedIntToLong(stat.udps_opackets), ParseUtil.unsignedIntToLong(stat.udps_ipackets), ParseUtil.unsignedIntToLong(stat.udps_noportmcast), ParseUtil.unsignedIntToLong(stat.udps_hdrops + stat.udps_badsum + var1_1.udps_badlen));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        void var1_1;
        CLibrary.BsdUdpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(ParseUtil.unsignedIntToLong(stat.udps_snd6_swcsum), ParseUtil.unsignedIntToLong(var1_1.udps_rcv6_swcsum), 0L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    private static CLibrary.BsdTcpstat queryTcpstat() {
        void var0;
        CLibrary.BsdTcpstat ft = new CLibrary.BsdTcpstat();
        Memory m = BsdSysctlUtil.sysctl("net.inet.tcp.stats");
        if (m != null && m.size() >= 128L) {
            void var1_1;
            ft.tcps_connattempt = m.getInt(0L);
            ft.tcps_accepts = m.getInt(4L);
            ft.tcps_drops = m.getInt(12L);
            ft.tcps_conndrops = m.getInt(16L);
            ft.tcps_sndpack = m.getInt(64L);
            ft.tcps_sndrexmitpack = m.getInt(72L);
            ft.tcps_rcvpack = m.getInt(104L);
            ft.tcps_rcvbadsum = m.getInt(112L);
            ft.tcps_rcvbadoff = m.getInt(116L);
            ft.tcps_rcvmemdrop = m.getInt(120L);
            ft.tcps_rcvshort = var1_1.getInt(124L);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static CLibrary.BsdUdpstat queryUdpstat() {
        void var0;
        CLibrary.BsdUdpstat ut = new CLibrary.BsdUdpstat();
        Memory m = BsdSysctlUtil.sysctl("net.inet.udp.stats");
        if (m != null && m.size() >= 1644L) {
            void var1_1;
            ut.udps_ipackets = m.getInt(0L);
            ut.udps_hdrops = m.getInt(4L);
            ut.udps_badsum = m.getInt(8L);
            ut.udps_badlen = m.getInt(12L);
            ut.udps_opackets = m.getInt(36L);
            ut.udps_noportmcast = m.getInt(48L);
            ut.udps_rcv6_swcsum = m.getInt(64L);
            ut.udps_snd6_swcsum = var1_1.getInt(80L);
        }
        return var0;
    }
}

