/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.Memory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.NetStat;
import oshi.jna.platform.mac.SystemB;
import oshi.jna.platform.unix.CLibrary;
import oshi.software.common.AbstractInternetProtocolStats;
import oshi.software.os.InternetProtocolStats;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.SysctlUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class MacInternetProtocolStats
extends AbstractInternetProtocolStats {
    private boolean isElevated;
    private Supplier<Pair<Long, Long>> establishedv4v6 = Memoizer.memoize(NetStat::queryTcpnetstat, Memoizer.defaultExpiration());
    private Supplier<CLibrary.BsdTcpstat> tcpstat = Memoizer.memoize(MacInternetProtocolStats::queryTcpstat, Memoizer.defaultExpiration());
    private Supplier<CLibrary.BsdUdpstat> udpstat = Memoizer.memoize(MacInternetProtocolStats::queryUdpstat, Memoizer.defaultExpiration());
    private Supplier<CLibrary.BsdIpstat> ipstat = Memoizer.memoize(MacInternetProtocolStats::queryIpstat, Memoizer.defaultExpiration());
    private Supplier<CLibrary.BsdIp6stat> ip6stat = Memoizer.memoize(MacInternetProtocolStats::queryIp6stat, Memoizer.defaultExpiration());

    /*
     * WARNING - void declaration
     */
    public MacInternetProtocolStats(boolean elevated) {
        void var1_1;
        this.isElevated = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        void var3_3;
        void var2_2;
        void var1_1;
        CLibrary.BsdTcpstat tcp = this.tcpstat.get();
        if (this.isElevated) {
            return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getA(), ParseUtil.unsignedIntToLong(tcp.tcps_connattempt), ParseUtil.unsignedIntToLong(tcp.tcps_accepts), ParseUtil.unsignedIntToLong(tcp.tcps_conndrops), ParseUtil.unsignedIntToLong(tcp.tcps_drops), ParseUtil.unsignedIntToLong(tcp.tcps_sndpack), ParseUtil.unsignedIntToLong(tcp.tcps_rcvpack), ParseUtil.unsignedIntToLong(tcp.tcps_sndrexmitpack), ParseUtil.unsignedIntToLong(tcp.tcps_rcvbadsum + tcp.tcps_rcvbadoff + tcp.tcps_rcvmemdrop + tcp.tcps_rcvshort), 0L);
        }
        CLibrary.BsdIpstat ip = this.ipstat.get();
        CLibrary.BsdUdpstat udp = this.udpstat.get();
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getA(), ParseUtil.unsignedIntToLong(tcp.tcps_connattempt), ParseUtil.unsignedIntToLong(tcp.tcps_accepts), ParseUtil.unsignedIntToLong(tcp.tcps_conndrops), ParseUtil.unsignedIntToLong(tcp.tcps_drops), Math.max(0L, ParseUtil.unsignedIntToLong(ip.ips_delivered - udp.udps_opackets)), Math.max(0L, ParseUtil.unsignedIntToLong(ip.ips_total - udp.udps_ipackets)), ParseUtil.unsignedIntToLong(var1_1.tcps_sndrexmitpack), Math.max(0L, ParseUtil.unsignedIntToLong(ip.ips_badsum + ip.ips_tooshort + ip.ips_toosmall + ip.ips_badhlen + var2_2.ips_badlen - udp.udps_hdrops + udp.udps_badsum + var3_3.udps_badlen)), 0L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.TcpStats getTCPv6Stats() {
        void var2_2;
        void var1_1;
        CLibrary.BsdIp6stat ip6 = this.ip6stat.get();
        CLibrary.BsdUdpstat udp = this.udpstat.get();
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getB(), 0L, 0L, 0L, 0L, ip6.ip6s_localout - ParseUtil.unsignedIntToLong(udp.udps_snd6_swcsum), var1_1.ip6s_total - ParseUtil.unsignedIntToLong(var2_2.udps_rcv6_swcsum), 0L, 0L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        void var1_1;
        CLibrary.BsdUdpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(ParseUtil.unsignedIntToLong(stat.udps_opackets), ParseUtil.unsignedIntToLong(stat.udps_ipackets), ParseUtil.unsignedIntToLong(stat.udps_noportmcast), ParseUtil.unsignedIntToLong(stat.udps_hdrops + stat.udps_badsum + var1_1.udps_badlen));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        void var1_1;
        CLibrary.BsdUdpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(ParseUtil.unsignedIntToLong(stat.udps_snd6_swcsum), ParseUtil.unsignedIntToLong(var1_1.udps_rcv6_swcsum), 0L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<InternetProtocolStats.IPConnection> getConnections() {
        void var1_1;
        ArrayList<InternetProtocolStats.IPConnection> conns = new ArrayList<InternetProtocolStats.IPConnection>();
        int[] pids = new int[1024];
        int numberOfProcesses = SystemB.INSTANCE.proc_listpids(1, 0, pids, pids.length * com.sun.jna.platform.mac.SystemB.INT_SIZE) / com.sun.jna.platform.mac.SystemB.INT_SIZE;
        for (int i = 0; i < numberOfProcesses; ++i) {
            if (pids[i] <= 0) continue;
            for (Integer fd : MacInternetProtocolStats.queryFdList(pids[i])) {
                InternetProtocolStats.IPConnection ipc = MacInternetProtocolStats.queryIPConnection(pids[i], fd);
                if (ipc == null) continue;
                conns.add(ipc);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Integer> queryFdList(int pid) {
        void var1_1;
        ArrayList<Integer> fdList = new ArrayList<Integer>();
        int bufferSize = SystemB.INSTANCE.proc_pidinfo(pid, 1, 0L, null, 0);
        if (bufferSize > 0) {
            void var3_3;
            int n;
            SystemB.ProcFdInfo fdInfo = new SystemB.ProcFdInfo();
            int numStructs = bufferSize / fdInfo.size();
            SystemB.ProcFdInfo[] fdArray = (SystemB.ProcFdInfo[])fdInfo.toArray(numStructs);
            n = SystemB.INSTANCE.proc_pidinfo(pid, 1, 0L, fdArray[0], n);
            numStructs = n / var3_3.size();
            for (int i = 0; i < numStructs; ++i) {
                if (fdArray[i].proc_fdtype != 2) continue;
                fdList.add(fdArray[i].proc_fd);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static InternetProtocolStats.IPConnection queryIPConnection(int pid, int fd) {
        SystemB.SocketFdInfo si;
        SystemB.SocketFdInfo socketFdInfo = si = new SystemB.SocketFdInfo();
        int ret = SystemB.INSTANCE.proc_pidfdinfo(pid, fd, 3, socketFdInfo, socketFdInfo.size());
        if (si.size() == ret && si.psi.soi_family == 2 || si.psi.soi_family == 30) {
            int n;
            void var2_4;
            void var1_3;
            void var3_6;
            byte[] faddr;
            byte[] laddr;
            String type;
            InternetProtocolStats.TcpState state;
            SystemB.InSockInfo ini;
            if (si.psi.soi_kind == 2) {
                si.psi.soi_proto.setType("pri_tcp");
                si.psi.soi_proto.read();
                ini = si.psi.soi_proto.pri_tcp.tcpsi_ini;
                state = MacInternetProtocolStats.stateLookup(si.psi.soi_proto.pri_tcp.tcpsi_state);
                type = "tcp";
            } else if (si.psi.soi_kind == 1) {
                si.psi.soi_proto.setType("pri_in");
                si.psi.soi_proto.read();
                ini = si.psi.soi_proto.pri_in;
                state = InternetProtocolStats.TcpState.NONE;
                type = "udp";
            } else {
                return null;
            }
            if (ini.insi_vflag == 1) {
                laddr = ParseUtil.parseIntToIP(ini.insi_laddr[3]);
                faddr = ParseUtil.parseIntToIP(ini.insi_faddr[3]);
                type = type + "4";
            } else if (ini.insi_vflag == 2) {
                laddr = ParseUtil.parseIntArrayToIP(ini.insi_laddr);
                faddr = ParseUtil.parseIntArrayToIP(ini.insi_faddr);
                type = type + "6";
            } else {
                return null;
            }
            int lport = ParseUtil.bigEndian16ToLittleEndian(ini.insi_lport);
            int fport = ParseUtil.bigEndian16ToLittleEndian(ini.insi_fport);
            return new InternetProtocolStats.IPConnection((String)var3_6, laddr, lport, faddr, (int)var1_3, state, si.psi.soi_qlen, var2_4.psi.soi_incqlen, n);
        }
        return null;
    }

    private static InternetProtocolStats.TcpState stateLookup(int state) {
        switch (state) {
            case 0: {
                return InternetProtocolStats.TcpState.CLOSED;
            }
            case 1: {
                return InternetProtocolStats.TcpState.LISTEN;
            }
            case 2: {
                return InternetProtocolStats.TcpState.SYN_SENT;
            }
            case 3: {
                return InternetProtocolStats.TcpState.SYN_RECV;
            }
            case 4: {
                return InternetProtocolStats.TcpState.ESTABLISHED;
            }
            case 5: {
                return InternetProtocolStats.TcpState.CLOSE_WAIT;
            }
            case 6: {
                return InternetProtocolStats.TcpState.FIN_WAIT_1;
            }
            case 7: {
                return InternetProtocolStats.TcpState.CLOSING;
            }
            case 8: {
                return InternetProtocolStats.TcpState.LAST_ACK;
            }
            case 9: {
                return InternetProtocolStats.TcpState.FIN_WAIT_2;
            }
            case 10: {
                return InternetProtocolStats.TcpState.TIME_WAIT;
            }
        }
        return InternetProtocolStats.TcpState.UNKNOWN;
    }

    /*
     * WARNING - void declaration
     */
    private static CLibrary.BsdTcpstat queryTcpstat() {
        void var0;
        CLibrary.BsdTcpstat mt = new CLibrary.BsdTcpstat();
        Memory m = SysctlUtil.sysctl("net.inet.tcp.stats");
        if (m != null && m.size() >= 128L) {
            void var1_1;
            mt.tcps_connattempt = m.getInt(0L);
            mt.tcps_accepts = m.getInt(4L);
            mt.tcps_drops = m.getInt(12L);
            mt.tcps_conndrops = m.getInt(16L);
            mt.tcps_sndpack = m.getInt(64L);
            mt.tcps_sndrexmitpack = m.getInt(72L);
            mt.tcps_rcvpack = m.getInt(104L);
            mt.tcps_rcvbadsum = m.getInt(112L);
            mt.tcps_rcvbadoff = m.getInt(116L);
            mt.tcps_rcvmemdrop = m.getInt(120L);
            mt.tcps_rcvshort = var1_1.getInt(124L);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static CLibrary.BsdIpstat queryIpstat() {
        void var0;
        CLibrary.BsdIpstat mi = new CLibrary.BsdIpstat();
        Memory m = SysctlUtil.sysctl("net.inet.ip.stats");
        if (m != null && m.size() >= 60L) {
            void var1_1;
            mi.ips_total = m.getInt(0L);
            mi.ips_badsum = m.getInt(4L);
            mi.ips_tooshort = m.getInt(8L);
            mi.ips_toosmall = m.getInt(12L);
            mi.ips_badhlen = m.getInt(16L);
            mi.ips_badlen = m.getInt(20L);
            mi.ips_delivered = var1_1.getInt(56L);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static CLibrary.BsdIp6stat queryIp6stat() {
        void var0;
        CLibrary.BsdIp6stat mi6 = new CLibrary.BsdIp6stat();
        Memory m = SysctlUtil.sysctl("net.inet6.ip6.stats");
        if (m != null && m.size() >= 96L) {
            void var1_1;
            mi6.ip6s_total = m.getLong(0L);
            mi6.ip6s_localout = var1_1.getLong(88L);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static CLibrary.BsdUdpstat queryUdpstat() {
        void var0;
        CLibrary.BsdUdpstat ut = new CLibrary.BsdUdpstat();
        Memory m = SysctlUtil.sysctl("net.inet.udp.stats");
        if (m != null && m.size() >= 1644L) {
            void var1_1;
            ut.udps_ipackets = m.getInt(0L);
            ut.udps_hdrops = m.getInt(4L);
            ut.udps_badsum = m.getInt(8L);
            ut.udps_badlen = m.getInt(12L);
            ut.udps_opackets = m.getInt(36L);
            ut.udps_noportmcast = m.getInt(48L);
            ut.udps_rcv6_swcsum = m.getInt(64L);
            ut.udps_snd6_swcsum = var1_1.getInt(80L);
        }
        return var0;
    }
}

