/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import com.sun.jna.Platform;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.GlobalConfig;
import oshi.util.Memoizer;
import oshi.util.tuples.Pair;

public abstract class AbstractOperatingSystem
implements OperatingSystem {
    public static final String OSHI_OS_UNIX_WHOCOMMAND = "oshi.os.unix.whoCommand";
    protected static final boolean USE_WHO_COMMAND = GlobalConfig.get("oshi.os.unix.whoCommand", false);
    private final Supplier<String> manufacturer = Memoizer.memoize(this::queryManufacturer);
    private final Supplier<Pair<String, OperatingSystem.OSVersionInfo>> familyVersionInfo = Memoizer.memoize(this::queryFamilyVersionInfo);
    private final Supplier<Integer> bitness = Memoizer.memoize(this::queryPlatformBitness);

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    protected abstract String queryManufacturer();

    @Override
    public String getFamily() {
        return this.familyVersionInfo.get().getA();
    }

    @Override
    public OperatingSystem.OSVersionInfo getVersionInfo() {
        return this.familyVersionInfo.get().getB();
    }

    protected abstract Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo();

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    /*
     * WARNING - void declaration
     */
    private int queryPlatformBitness() {
        void var1_1;
        if (Platform.is64Bit()) {
            return 64;
        }
        int jvmBitness = System.getProperty("os.arch").indexOf("64") != -1 ? 64 : 32;
        return this.queryBitness((int)var1_1);
    }

    protected abstract int queryBitness(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> getProcesses(Predicate<OSProcess> filter, Comparator<OSProcess> sort, int limit) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.queryAllProcesses().stream().filter(filter == null ? OperatingSystem.ProcessFiltering.ALL_PROCESSES : var1_1).sorted((Comparator<OSProcess>)(sort == null ? OperatingSystem.ProcessSorting.NO_SORTING : var2_2)).limit(limit > 0 ? (long)var3_3 : Long.MAX_VALUE).collect(Collectors.toList());
    }

    protected abstract List<OSProcess> queryAllProcesses();

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> getChildProcesses(int parentPid, Predicate<OSProcess> filter, Comparator<OSProcess> sort, int limit) {
        void var3_3;
        void var1_1;
        void var2_2;
        List<OSProcess> list = this.queryChildProcesses(parentPid);
        OSProcess parent = list.stream().filter(p -> {
            int n;
            return p.getParentProcessID() == n;
        }).findAny().orElse(null);
        long parentStartTime = parent == null ? 0L : parent.getStartTime();
        return this.queryChildProcesses(parentPid).stream().filter(filter == null ? OperatingSystem.ProcessFiltering.ALL_PROCESSES : var2_2).filter(arg_0 -> AbstractOperatingSystem.lambda$getChildProcesses$1((int)var1_1, parentStartTime, arg_0)).sorted((Comparator<OSProcess>)(sort == null ? OperatingSystem.ProcessSorting.NO_SORTING : var3_3)).limit(limit > 0 ? (long)limit : Long.MAX_VALUE).collect(Collectors.toList());
    }

    protected abstract List<OSProcess> queryChildProcesses(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSProcess> getDescendantProcesses(int parentPid, Predicate<OSProcess> filter, Comparator<OSProcess> sort, int limit) {
        void var3_3;
        void var1_1;
        void var2_2;
        List<OSProcess> list = this.queryDescendantProcesses(parentPid);
        OSProcess parent = list.stream().filter(p -> {
            int n;
            return p.getParentProcessID() == n;
        }).findAny().orElse(null);
        long parentStartTime = parent == null ? 0L : parent.getStartTime();
        return this.queryDescendantProcesses(parentPid).stream().filter(filter == null ? OperatingSystem.ProcessFiltering.ALL_PROCESSES : var2_2).filter(arg_0 -> AbstractOperatingSystem.lambda$getDescendantProcesses$3((int)var1_1, parentStartTime, arg_0)).sorted((Comparator<OSProcess>)(sort == null ? OperatingSystem.ProcessSorting.NO_SORTING : var3_3)).limit(limit > 0 ? (long)limit : Long.MAX_VALUE).collect(Collectors.toList());
    }

    protected abstract List<OSProcess> queryDescendantProcesses(int var1);

    /*
     * WARNING - void declaration
     */
    protected static Set<Integer> getChildrenOrDescendants(Collection<OSProcess> allProcs, int parentPid, boolean allDescendants) {
        void var2_2;
        void var1_1;
        Map<Integer, Integer> map = allProcs.stream().collect(Collectors.toMap(OSProcess::getProcessID, OSProcess::getParentProcessID));
        return AbstractOperatingSystem.getChildrenOrDescendants(map, (int)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static Set<Integer> getChildrenOrDescendants(Map<Integer, Integer> parentPidMap, int parentPid, boolean allDescendants) {
        void var3_4;
        void var1_1;
        HashSet<Integer> descendantPids = new HashSet<Integer>();
        descendantPids.add(parentPid);
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        queue.add((int)var1_1);
        do {
            for (int pid : AbstractOperatingSystem.getChildren(parentPidMap, (Integer)queue.poll())) {
                if (descendantPids.contains(pid)) continue;
                descendantPids.add(pid);
                queue.add(pid);
            }
        } while (allDescendants && !queue.isEmpty());
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<Integer> getChildren(Map<Integer, Integer> parentPidMap, int parentPid) {
        void var1_1;
        return parentPidMap.entrySet().stream().filter(arg_0 -> AbstractOperatingSystem.lambda$getChildren$4((int)var1_1, arg_0)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getManufacturer()).append(' ').append(this.getFamily()).append(' ').append(this.getVersionInfo());
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getChildren$4(int parentPid, Map.Entry e) {
        int n;
        void var1_1;
        return ((Integer)e.getValue()).equals(parentPid) && !((Integer)var1_1.getKey()).equals(n);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getDescendantProcesses$3(int parentPid, long parentStartTime, OSProcess p) {
        void var1_1;
        void var3_2;
        int n;
        return p.getProcessID() != n && var3_2.getStartTime() >= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getChildProcesses$1(int parentPid, long parentStartTime, OSProcess p) {
        void var1_1;
        void var3_2;
        int n;
        return p.getProcessID() != n && var3_2.getStartTime() >= var1_1;
    }
}

