/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.wmi.MSAcpiThermalZoneTemperature;
import oshi.driver.windows.wmi.OhmHardware;
import oshi.driver.windows.wmi.OhmSensor;
import oshi.driver.windows.wmi.Win32Fan;
import oshi.driver.windows.wmi.Win32Processor;
import oshi.hardware.common.AbstractSensors;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

@ThreadSafe
final class WindowsSensors
extends AbstractSensors {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsSensors.class);
    private static final String COM_EXCEPTION_MSG = "COM exception: {}";

    WindowsSensors() {
    }

    @Override
    public final double queryCpuTemperature() {
        double d;
        double d2;
        double tempC = WindowsSensors.getTempFromOHM();
        if (d2 > 0.0) {
            return d;
        }
        d = WindowsSensors.getTempFromWMI();
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private static double getTempFromOHM() {
        WmiQueryHandler h = WmiQueryHandler.createInstance();
        boolean comInit = false;
        try {
            comInit = h.initCOM();
            WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> ohmHardware = OhmHardware.queryHwIdentifier(h, "Hardware", "CPU");
            if (ohmHardware.getResultCount() > 0) {
                WbemcliUtil.WmiResult<OhmSensor.ValueProperty> ohmSensors;
                LOG.debug("Found Temperature data in Open Hardware Monitor");
                String cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
                if (cpuIdentifier.length() > 0 && (ohmSensors = OhmSensor.querySensorValue(h, cpuIdentifier, "Temperature")).getResultCount() > 0) {
                    double sum = 0.0;
                    for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                        sum += (double)WmiUtil.getFloat(ohmSensors, OhmSensor.ValueProperty.VALUE, i);
                    }
                    double d = sum / (double)ohmSensors.getResultCount();
                    if (comInit) {
                        h.unInitCOM();
                    }
                    return d;
                }
            }
            if (comInit) {
                h.unInitCOM();
            }
        }
        catch (COMException e) {
            try {
                void var2_3;
                LOG.warn(COM_EXCEPTION_MSG, (Object)var2_3.getMessage());
                if (comInit) {
                    h.unInitCOM();
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                if (var1_1 != false) {
                    void var0;
                    var0.unInitCOM();
                }
                throw throwable;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private static double getTempFromWMI() {
        void var0;
        double tempC = 0.0;
        long tempK = 0L;
        WbemcliUtil.WmiResult<MSAcpiThermalZoneTemperature.TemperatureProperty> result = MSAcpiThermalZoneTemperature.queryCurrentTemperature();
        if (result.getResultCount() > 0) {
            LOG.debug("Found Temperature data in WMI");
            tempK = WmiUtil.getUint32asLong(result, MSAcpiThermalZoneTemperature.TemperatureProperty.CURRENTTEMPERATURE, 0);
        }
        if (tempK > 2732L) {
            tempC = (double)tempK / 10.0 - 273.15;
        } else if (tempK > 274L) {
            void var2_1;
            tempC = (double)var2_1 - 273.0;
        }
        if (tempC < 0.0) {
            return 0.0;
        }
        return (double)var0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int[] queryFanSpeeds() {
        int[] fanSpeeds = WindowsSensors.getFansFromOHM();
        if (fanSpeeds.length > 0) {
            return fanSpeeds;
        }
        fanSpeeds = WindowsSensors.getFansFromWMI();
        if (fanSpeeds.length > 0) {
            void var1_1;
            return var1_1;
        }
        return new int[0];
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getFansFromOHM() {
        WmiQueryHandler h = WmiQueryHandler.createInstance();
        boolean comInit = false;
        try {
            comInit = h.initCOM();
            WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> ohmHardware = OhmHardware.queryHwIdentifier(h, "Hardware", "CPU");
            if (ohmHardware.getResultCount() > 0) {
                WbemcliUtil.WmiResult<OhmSensor.ValueProperty> ohmSensors;
                LOG.debug("Found Fan data in Open Hardware Monitor");
                String cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
                if (cpuIdentifier.length() > 0 && (ohmSensors = OhmSensor.querySensorValue(h, cpuIdentifier, "Fan")).getResultCount() > 0) {
                    void var3_5;
                    int[] fanSpeeds = new int[ohmSensors.getResultCount()];
                    for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                        fanSpeeds[i] = (int)WmiUtil.getFloat(ohmSensors, OhmSensor.ValueProperty.VALUE, i);
                    }
                    void var4_7 = var3_5;
                    if (comInit) {
                        h.unInitCOM();
                    }
                    return var4_7;
                }
            }
            if (comInit) {
                h.unInitCOM();
            }
        }
        catch (COMException e) {
            try {
                void var2_3;
                LOG.warn(COM_EXCEPTION_MSG, (Object)var2_3.getMessage());
                if (comInit) {
                    h.unInitCOM();
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                if (var1_1 != false) {
                    void var0;
                    var0.unInitCOM();
                }
                throw throwable;
            }
        }
        return new int[0];
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getFansFromWMI() {
        WbemcliUtil.WmiResult<Win32Fan.SpeedProperty> fan = Win32Fan.querySpeed();
        if (fan.getResultCount() > 1) {
            void var1_1;
            LOG.debug("Found Fan data in WMI");
            int[] fanSpeeds = new int[fan.getResultCount()];
            for (int i = 0; i < fan.getResultCount(); ++i) {
                fanSpeeds[i] = (int)WmiUtil.getUint64(fan, Win32Fan.SpeedProperty.DESIREDSPEED, i);
            }
            return var1_1;
        }
        return new int[0];
    }

    @Override
    public final double queryCpuVoltage() {
        double d;
        double d2;
        double volts = WindowsSensors.getVoltsFromOHM();
        if (d2 > 0.0) {
            return d;
        }
        d = WindowsSensors.getVoltsFromWMI();
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private static double getVoltsFromOHM() {
        WmiQueryHandler h = WmiQueryHandler.createInstance();
        boolean comInit = false;
        try {
            comInit = h.initCOM();
            WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> ohmHardware = OhmHardware.queryHwIdentifier(h, "Sensor", "Voltage");
            if (ohmHardware.getResultCount() > 0) {
                void var3_5;
                WbemcliUtil.WmiResult<OhmSensor.ValueProperty> ohmSensors;
                LOG.debug("Found Voltage data in Open Hardware Monitor");
                String cpuIdentifier = null;
                for (int i = 0; i < ohmHardware.getResultCount(); ++i) {
                    String id = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, i);
                    if (!id.toLowerCase().contains("cpu")) continue;
                    cpuIdentifier = id;
                    break;
                }
                if (cpuIdentifier == null) {
                    cpuIdentifier = WmiUtil.getString(ohmHardware, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
                }
                if ((ohmSensors = OhmSensor.querySensorValue(h, (String)var3_5, "Voltage")).getResultCount() > 0) {
                    double d = WmiUtil.getFloat(ohmSensors, OhmSensor.ValueProperty.VALUE, 0);
                    if (comInit) {
                        h.unInitCOM();
                    }
                    return d;
                }
            }
            if (comInit) {
                h.unInitCOM();
            }
        }
        catch (COMException e) {
            try {
                void var2_3;
                LOG.warn(COM_EXCEPTION_MSG, (Object)var2_3.getMessage());
                if (comInit) {
                    h.unInitCOM();
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                if (var1_1 != false) {
                    void var0;
                    var0.unInitCOM();
                }
                throw throwable;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private static double getVoltsFromWMI() {
        WbemcliUtil.WmiResult<Win32Processor.VoltProperty> voltage = Win32Processor.queryVoltage();
        if (voltage.getResultCount() > 1) {
            LOG.debug("Found Voltage data in WMI");
            int decivolts = WmiUtil.getUint16(voltage, Win32Processor.VoltProperty.CURRENTVOLTAGE, 0);
            if (decivolts > 0) {
                if ((decivolts & 0x80) == 0) {
                    void var0;
                    decivolts = WmiUtil.getUint32(var0, Win32Processor.VoltProperty.VOLTAGECAPS, 0);
                    if ((decivolts & 1) > 0) {
                        return 5.0;
                    }
                    if ((decivolts & 2) > 0) {
                        return 3.3;
                    }
                    if ((decivolts & 4) > 0) {
                        return 2.9;
                    }
                } else {
                    void var1_1;
                    return (double)(var1_1 & 0x7F) / 10.0;
                }
            }
        }
        return 0.0;
    }
}

