/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.driver.windows.wmi.Win32Bios;
import oshi.driver.windows.wmi.Win32ComputerSystem;
import oshi.driver.windows.wmi.Win32ComputerSystemProduct;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.windows.WindowsBaseboard;
import oshi.hardware.platform.windows.WindowsFirmware;
import oshi.util.Memoizer;
import oshi.util.Util;
import oshi.util.platform.windows.WmiUtil;
import oshi.util.tuples.Pair;

@Immutable
final class WindowsComputerSystem
extends AbstractComputerSystem {
    private final Supplier<Pair<String, String>> manufacturerModel = Memoizer.memoize(WindowsComputerSystem::queryManufacturerModel);
    private final Supplier<Pair<String, String>> serialNumberUUID = Memoizer.memoize(WindowsComputerSystem::querySystemSerialNumberUUID);

    WindowsComputerSystem() {
    }

    @Override
    public final String getManufacturer() {
        return this.manufacturerModel.get().getA();
    }

    @Override
    public final String getModel() {
        return this.manufacturerModel.get().getB();
    }

    @Override
    public final String getSerialNumber() {
        return this.serialNumberUUID.get().getA();
    }

    @Override
    public final String getHardwareUUID() {
        return this.serialNumberUUID.get().getB();
    }

    @Override
    public final Firmware createFirmware() {
        return new WindowsFirmware();
    }

    @Override
    public final Baseboard createBaseboard() {
        return new WindowsBaseboard();
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<String, String> queryManufacturerModel() {
        void var1_1;
        void var0;
        String manufacturer = null;
        String model = null;
        WbemcliUtil.WmiResult<Win32ComputerSystem.ComputerSystemProperty> win32ComputerSystem = Win32ComputerSystem.queryComputerSystem();
        if (win32ComputerSystem.getResultCount() > 0) {
            void var2_2;
            manufacturer = WmiUtil.getString(win32ComputerSystem, Win32ComputerSystem.ComputerSystemProperty.MANUFACTURER, 0);
            model = WmiUtil.getString(var2_2, Win32ComputerSystem.ComputerSystemProperty.MODEL, 0);
        }
        return new Pair<String, String>((String)(Util.isBlank(manufacturer) ? "unknown" : var0), (String)(Util.isBlank(model) ? "unknown" : var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<String, String> querySystemSerialNumberUUID() {
        void var1_1;
        void var0;
        String serialNumber = null;
        String uuid = null;
        WbemcliUtil.WmiResult<Win32ComputerSystemProduct.ComputerSystemProductProperty> win32ComputerSystemProduct = Win32ComputerSystemProduct.queryIdentifyingNumberUUID();
        if (win32ComputerSystemProduct.getResultCount() > 0) {
            void var2_2;
            serialNumber = WmiUtil.getString(win32ComputerSystemProduct, Win32ComputerSystemProduct.ComputerSystemProductProperty.IDENTIFYINGNUMBER, 0);
            uuid = WmiUtil.getString(var2_2, Win32ComputerSystemProduct.ComputerSystemProductProperty.UUID, 0);
        }
        if (Util.isBlank(serialNumber)) {
            serialNumber = WindowsComputerSystem.querySerialFromBios();
        }
        if (Util.isBlank(serialNumber)) {
            serialNumber = "unknown";
        }
        if (Util.isBlank(uuid)) {
            uuid = "unknown";
        }
        return new Pair<void, void>(var0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String querySerialFromBios() {
        WbemcliUtil.WmiResult<Win32Bios.BiosSerialProperty> serialNum = Win32Bios.querySerialNumber();
        if (serialNum.getResultCount() > 0) {
            void var0;
            return WmiUtil.getString(var0, Win32Bios.BiosSerialProperty.SERIALNUMBER, 0);
        }
        return null;
    }
}

