/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.driver.windows.wmi.Win32BaseBoard;
import oshi.hardware.common.AbstractBaseboard;
import oshi.util.Memoizer;
import oshi.util.Util;
import oshi.util.platform.windows.WmiUtil;
import oshi.util.tuples.Quartet;

@Immutable
final class WindowsBaseboard
extends AbstractBaseboard {
    private final Supplier<Quartet<String, String, String, String>> manufModelVersSerial = Memoizer.memoize(WindowsBaseboard::queryManufModelVersSerial);

    WindowsBaseboard() {
    }

    @Override
    public final String getManufacturer() {
        return this.manufModelVersSerial.get().getA();
    }

    @Override
    public final String getModel() {
        return this.manufModelVersSerial.get().getB();
    }

    @Override
    public final String getVersion() {
        return this.manufModelVersSerial.get().getC();
    }

    @Override
    public final String getSerialNumber() {
        return this.manufModelVersSerial.get().getD();
    }

    /*
     * WARNING - void declaration
     */
    private static Quartet<String, String, String, String> queryManufModelVersSerial() {
        void var3_3;
        void var2_2;
        void var1_1;
        void var0;
        String manufacturer = null;
        String model = null;
        String version = null;
        String serialNumber = null;
        WbemcliUtil.WmiResult<Win32BaseBoard.BaseBoardProperty> win32BaseBoard = Win32BaseBoard.queryBaseboardInfo();
        if (win32BaseBoard.getResultCount() > 0) {
            manufacturer = WmiUtil.getString(win32BaseBoard, Win32BaseBoard.BaseBoardProperty.MANUFACTURER, 0);
            model = WmiUtil.getString(win32BaseBoard, Win32BaseBoard.BaseBoardProperty.MODEL, 0);
            version = WmiUtil.getString(win32BaseBoard, Win32BaseBoard.BaseBoardProperty.VERSION, 0);
            serialNumber = WmiUtil.getString(win32BaseBoard, Win32BaseBoard.BaseBoardProperty.SERIALNUMBER, 0);
        }
        return new Quartet<String, String, String, String>((String)(Util.isBlank(manufacturer) ? "unknown" : var0), (String)(Util.isBlank(model) ? "unknown" : var1_1), (String)(Util.isBlank(version) ? "unknown" : var2_2), (String)(Util.isBlank(serialNumber) ? "unknown" : var3_3));
    }
}

