/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.ArrayList;
import java.util.Iterator;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.common.AbstractSensors;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
final class SolarisSensors
extends AbstractSensors {
    SolarisSensors() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double queryCpuTemperature() {
        void var1_1;
        double maxTemp = 0.0;
        for (String line : ExecutingCommand.runNative("/usr/sbin/prtpicl -v -c temperature-sensor")) {
            int n;
            if (!line.trim().startsWith("Temperature:")) continue;
            int temp = ParseUtil.parseLastInt(line, 0);
            if (!((double)n > maxTemp)) continue;
            maxTemp = temp;
        }
        if (maxTemp > 1000.0) {
            maxTemp /= 1000.0;
        }
        return (double)var1_1;
    }

    @Override
    public final int[] queryFanSpeeds() {
        ArrayList<Integer> speedList = new ArrayList<Integer>();
        Iterator<String> iterator = ExecutingCommand.runNative("/usr/sbin/prtpicl -v -c fan").iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (!line.trim().startsWith("Speed:")) continue;
            speedList.add(ParseUtil.parseLastInt(line, 0));
        }
        int[] fans = new int[speedList.size()];
        for (int i = 0; i < speedList.size(); ++i) {
            fans[i] = (Integer)speedList.get(i);
        }
        return iterator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double queryCpuVoltage() {
        void var1_1;
        double voltage = 0.0;
        for (String line : ExecutingCommand.runNative("/usr/sbin/prtpicl -v -c voltage-sensor")) {
            if (!line.trim().startsWith("Voltage:")) continue;
            voltage = ParseUtil.parseDoubleOrDefault(line.replace("Voltage:", "").trim(), 0.0);
            break;
        }
        return (double)var1_1;
    }
}

