/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Display;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HWDiskStore;
import oshi.hardware.NetworkIF;
import oshi.hardware.PowerSource;
import oshi.hardware.Sensors;
import oshi.hardware.SoundCard;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractHardwareAbstractionLayer;
import oshi.hardware.platform.unix.UnixDisplay;
import oshi.hardware.platform.unix.solaris.SolarisCentralProcessor;
import oshi.hardware.platform.unix.solaris.SolarisComputerSystem;
import oshi.hardware.platform.unix.solaris.SolarisGlobalMemory;
import oshi.hardware.platform.unix.solaris.SolarisGraphicsCard;
import oshi.hardware.platform.unix.solaris.SolarisHWDiskStore;
import oshi.hardware.platform.unix.solaris.SolarisNetworkIF;
import oshi.hardware.platform.unix.solaris.SolarisPowerSource;
import oshi.hardware.platform.unix.solaris.SolarisSensors;
import oshi.hardware.platform.unix.solaris.SolarisSoundCard;
import oshi.hardware.platform.unix.solaris.SolarisUsbDevice;

@ThreadSafe
public final class SolarisHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    @Override
    public final ComputerSystem createComputerSystem() {
        return new SolarisComputerSystem();
    }

    @Override
    public final GlobalMemory createMemory() {
        return new SolarisGlobalMemory();
    }

    @Override
    public final CentralProcessor createProcessor() {
        return new SolarisCentralProcessor();
    }

    @Override
    public final Sensors createSensors() {
        return new SolarisSensors();
    }

    @Override
    public final List<PowerSource> getPowerSources() {
        return SolarisPowerSource.getPowerSources();
    }

    @Override
    public final List<HWDiskStore> getDiskStores() {
        return SolarisHWDiskStore.getDisks();
    }

    @Override
    public final List<Display> getDisplays() {
        return UnixDisplay.getDisplays();
    }

    @Override
    public final List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return SolarisNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public final List<UsbDevice> getUsbDevices(boolean tree) {
        return SolarisUsbDevice.getUsbDevices(tree);
    }

    @Override
    public final List<SoundCard> getSoundCards() {
        return SolarisSoundCard.getSoundCards();
    }

    @Override
    public final List<GraphicsCard> getGraphicsCards() {
        return SolarisGraphicsCard.getGraphicsCards();
    }
}

