/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.unix.UnixBaseboard;
import oshi.hardware.platform.unix.solaris.SolarisFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;

@Immutable
final class SolarisComputerSystem
extends AbstractComputerSystem {
    private final Supplier<SmbiosStrings> smbiosStrings = Memoizer.memoize(SolarisComputerSystem::readSmbios);

    SolarisComputerSystem() {
    }

    @Override
    public final String getManufacturer() {
        return this.smbiosStrings.get().manufacturer;
    }

    @Override
    public final String getModel() {
        return this.smbiosStrings.get().model;
    }

    @Override
    public final String getSerialNumber() {
        return this.smbiosStrings.get().serialNumber;
    }

    @Override
    public final String getHardwareUUID() {
        return this.smbiosStrings.get().uuid;
    }

    @Override
    public final Firmware createFirmware() {
        return new SolarisFirmware(this.smbiosStrings.get().biosVendor, this.smbiosStrings.get().biosVersion, this.smbiosStrings.get().biosDate);
    }

    @Override
    public final Baseboard createBaseboard() {
        return new UnixBaseboard(this.smbiosStrings.get().boardManufacturer, this.smbiosStrings.get().boardModel, this.smbiosStrings.get().boardSerialNumber, this.smbiosStrings.get().boardVersion);
    }

    /*
     * WARNING - void declaration
     */
    private static SmbiosStrings readSmbios() {
        void var3_3;
        void var2_2;
        void var1_1;
        void var0;
        String biosVendor = null;
        String biosVersion = null;
        String biosDate = null;
        String manufacturer = null;
        String model = null;
        String serialNumber = null;
        String uuid = null;
        String boardManufacturer = null;
        String boardModel = null;
        String boardVersion = null;
        String boardSerialNumber = null;
        int smbTypeId = -1;
        for (String checkLine : ExecutingCommand.runNative("smbios")) {
            if (checkLine.contains("SMB_TYPE_") && (smbTypeId = SolarisComputerSystem.getSmbType(checkLine)) == Integer.MAX_VALUE) break;
            switch (smbTypeId) {
                case 0: {
                    if (checkLine.contains("Vendor:")) {
                        biosVendor = checkLine.split("Vendor:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("VersionString:")) {
                        biosVersion = checkLine.split("VersionString:")[1].trim();
                        break;
                    }
                    if (!checkLine.contains("Release Date:")) break;
                    biosDate = checkLine.split("Release Date:")[1].trim();
                    break;
                }
                case 1: {
                    if (checkLine.contains("Manufacturer:")) {
                        manufacturer = checkLine.split("Manufacturer:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Product:")) {
                        model = checkLine.split("Product:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Serial Number:")) {
                        serialNumber = checkLine.split("Serial Number:")[1].trim();
                        break;
                    }
                    if (!checkLine.contains("UUID:")) break;
                    uuid = checkLine.split("UUID:")[1].trim();
                    break;
                }
                case 2: {
                    if (checkLine.contains("Manufacturer:")) {
                        boardManufacturer = checkLine.split("Manufacturer:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Product:")) {
                        boardModel = checkLine.split("Product:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Version:")) {
                        boardVersion = checkLine.split("Version:")[1].trim();
                        break;
                    }
                    if (!checkLine.contains("Serial Number:")) break;
                    boardSerialNumber = checkLine.split("Serial Number:")[1].trim();
                }
            }
        }
        if (Util.isBlank(serialNumber)) {
            serialNumber = SolarisComputerSystem.readSerialNumber();
        }
        return new SmbiosStrings((String)var0, (String)var1_1, (String)var2_2, (String)var3_3, model, serialNumber, uuid, boardManufacturer, boardModel, boardVersion, boardSerialNumber);
    }

    private static int getSmbType(String checkLine) {
        String string;
        if (checkLine.contains("SMB_TYPE_BIOS")) {
            return 0;
        }
        if (checkLine.contains("SMB_TYPE_SYSTEM")) {
            return 1;
        }
        if (string.contains("SMB_TYPE_BASEBOARD")) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private static String readSerialNumber() {
        void var0;
        String serialNumber = ExecutingCommand.getFirstAnswer("sneep");
        if (serialNumber.isEmpty()) {
            String marker = "chassis-sn:";
            for (String checkLine : ExecutingCommand.runNative("prtconf -pv")) {
                void var3_3;
                if (!checkLine.contains(marker)) continue;
                serialNumber = ParseUtil.getSingleQuoteStringValue((String)var3_3);
                break;
            }
        }
        return var0;
    }

    private static final class SmbiosStrings {
        private final String biosVendor;
        private final String biosVersion;
        private final String biosDate;
        private final String manufacturer;
        private final String model;
        private final String serialNumber;
        private final String uuid;
        private final String boardManufacturer;
        private final String boardModel;
        private final String boardVersion;
        private final String boardSerialNumber;

        /*
         * WARNING - void declaration
         */
        private SmbiosStrings(String biosVendor, String biosVersion, String biosDate, String manufacturer, String model, String serialNumber, String uuid, String boardManufacturer, String boardModel, String boardVersion, String boardSerialNumber) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.biosVendor = Util.isBlank(biosVendor) ? "unknown" : var1_1;
            this.biosVersion = Util.isBlank(biosVersion) ? "unknown" : var2_2;
            this.biosDate = Util.isBlank(biosDate) ? "unknown" : var3_3;
            this.manufacturer = Util.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.model = Util.isBlank(model) ? "unknown" : model;
            this.serialNumber = Util.isBlank(serialNumber) ? "unknown" : serialNumber;
            this.uuid = Util.isBlank(uuid) ? "unknown" : uuid;
            this.boardManufacturer = Util.isBlank(boardManufacturer) ? "unknown" : boardManufacturer;
            this.boardModel = Util.isBlank(boardModel) ? "unknown" : boardModel;
            this.boardVersion = Util.isBlank(boardVersion) ? "unknown" : boardVersion;
            this.boardSerialNumber = Util.isBlank(boardSerialNumber) ? "unknown" : boardSerialNumber;
        }
    }
}

