/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.openbsd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.SoundCard;
import oshi.hardware.common.AbstractSoundCard;
import oshi.util.ExecutingCommand;

@Immutable
final class OpenBsdSoundCard
extends AbstractSoundCard {
    private static final Pattern AUDIO_AT = Pattern.compile("audio\\d+ at (.+)");
    private static final Pattern PCI_AT = Pattern.compile("(.+) at pci\\d+ dev \\d+ function \\d+ \"(.*)\" (rev .+):.*");

    /*
     * WARNING - void declaration
     */
    OpenBsdSoundCard(String kernelVersion, String name, String codec) {
        super((String)var1_1, (String)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<SoundCard> getSoundCards() {
        void var0;
        Object dmesg = ExecutingCommand.runNative("dmesg");
        HashSet<String> names = new HashSet<String>();
        Iterator<String> iterator = dmesg.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            Matcher m = AUDIO_AT.matcher(line);
            if (!m.matches()) continue;
            names.add(m.group(1));
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashMap<String, String> codecMap = new HashMap<String, String>();
        HashMap<String, String> versionMap = new HashMap<String, String>();
        String key = "";
        dmesg = dmesg.iterator();
        while (dmesg.hasNext()) {
            String line = (String)dmesg.next();
            Matcher m22 = PCI_AT.matcher(line);
            if (m22.matches() && names.contains(m22.group(1))) {
                key = m22.group(1);
                nameMap.put(key, m22.group(2));
                versionMap.put(key, m22.group(3));
                continue;
            }
            if (key.isEmpty()) continue;
            int m22 = line.indexOf("codec");
            if (m22 >= 0) {
                int idx = line.indexOf(58);
                codecMap.put(key, line.substring(idx + 1).trim());
            }
            key = "";
        }
        ArrayList<OpenBsdSoundCard> soundCards = new ArrayList<OpenBsdSoundCard>();
        for (Map.Entry entry : iterator.entrySet()) {
            soundCards.add(new OpenBsdSoundCard((String)versionMap.get(entry.getKey()), (String)entry.getValue(), (String)codecMap.get(entry.getKey())));
        }
        return var0;
    }
}

