/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.openbsd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.GraphicsCard;
import oshi.hardware.common.AbstractGraphicsCard;
import oshi.util.ExecutingCommand;

@Immutable
final class OpenBsdGraphicsCard
extends AbstractGraphicsCard {
    private static final String PCI_CLASS_DISPLAY = "Class: 03 Display";
    private static final Pattern PCI_DUMP_HEADER = Pattern.compile(" \\d+:\\d+:\\d+: (.+)");

    /*
     * WARNING - void declaration
     */
    OpenBsdGraphicsCard(String name, String deviceId, String vendor, String versionInfo, long vram) {
        super((String)var1_1, (String)var2_2, (String)var3_3, versionInfo, vram);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<GraphicsCard> getGraphicsCards() {
        void var0;
        Iterator iterator;
        ArrayList<OpenBsdGraphicsCard> cardList = new ArrayList<OpenBsdGraphicsCard>();
        List<String> devices = ExecutingCommand.runNative("pcidump -v");
        if (devices.isEmpty()) {
            return Collections.emptyList();
        }
        String name = "";
        String vendorId = "";
        String productId = "";
        boolean classCodeFound = false;
        String versionInfo = "";
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            int idx;
            String line = (String)iterator.next();
            Matcher m = PCI_DUMP_HEADER.matcher(line);
            if (m.matches()) {
                if (classCodeFound) {
                    cardList.add(new OpenBsdGraphicsCard(name.isEmpty() ? "unknown" : name, productId.isEmpty() ? "0x0000" : productId, vendorId.isEmpty() ? "0x0000" : vendorId, versionInfo.isEmpty() ? "unknown" : versionInfo, 0L));
                }
                name = m.group(1);
                vendorId = "";
                productId = "";
                classCodeFound = false;
                versionInfo = "";
                continue;
            }
            if (!classCodeFound) {
                int idx2 = line.indexOf("Vendor ID: ");
                if (idx2 >= 0 && line.length() >= idx2 + 15) {
                    vendorId = "0x" + line.substring(idx2 + 11, idx2 + 15);
                }
                if ((idx2 = line.indexOf("Product ID: ")) >= 0 && line.length() >= idx2 + 16) {
                    productId = "0x" + line.substring(idx2 + 12, idx2 + 16);
                }
                if (!line.contains(PCI_CLASS_DISPLAY)) continue;
                classCodeFound = true;
                continue;
            }
            if (!versionInfo.isEmpty() || (idx = line.indexOf("Revision: ")) < 0) continue;
            versionInfo = line.substring(idx);
        }
        if (classCodeFound) {
            void var3_3;
            void var2_2;
            cardList.add(new OpenBsdGraphicsCard((String)(name.isEmpty() ? "unknown" : var2_2), productId.isEmpty() ? "0x0000" : productId, (String)(vendorId.isEmpty() ? "0x0000" : var3_3), versionInfo.isEmpty() ? "unknown" : versionInfo, 0L));
        }
        return var0;
    }
}

