/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.openbsd;

import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;
import oshi.util.tuples.Triplet;

@Immutable
public class OpenBsdFirmware
extends AbstractFirmware {
    private final Supplier<Triplet<String, String, String>> manufVersRelease = Memoizer.memoize(OpenBsdFirmware::readDmesg);

    @Override
    public String getManufacturer() {
        return this.manufVersRelease.get().getA();
    }

    @Override
    public String getVersion() {
        return this.manufVersRelease.get().getB();
    }

    @Override
    public String getReleaseDate() {
        return this.manufVersRelease.get().getC();
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<String, String, String> readDmesg() {
        void var2_2;
        void var0;
        void var1_1;
        String version = null;
        String vendor = null;
        String releaseDate = "";
        Object object = ExecutingCommand.runNative("dmesg");
        object = object.iterator();
        while (object.hasNext()) {
            String line = (String)object.next();
            if (!line.startsWith("bios0: vendor")) continue;
            version = ParseUtil.getStringBetween(line, '\"');
            releaseDate = ParseUtil.parseMmDdYyyyToYyyyMmDD(ParseUtil.parseLastString(line));
            vendor = line.split("vendor")[1].trim();
        }
        return new Triplet<String, String, String>((String)(Util.isBlank(vendor) ? "unknown" : var1_1), (String)(Util.isBlank(version) ? "unknown" : var0), (String)(Util.isBlank(releaseDate) ? "unknown" : var2_2));
    }
}

