/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.common.AbstractVirtualMemory;
import oshi.hardware.platform.unix.freebsd.FreeBsdGlobalMemory;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

@ThreadSafe
final class FreeBsdVirtualMemory
extends AbstractVirtualMemory {
    private final FreeBsdGlobalMemory global;
    private final Supplier<Long> used = Memoizer.memoize(FreeBsdVirtualMemory::querySwapUsed, Memoizer.defaultExpiration());
    private final Supplier<Long> total = Memoizer.memoize(FreeBsdVirtualMemory::querySwapTotal, Memoizer.defaultExpiration());
    private final Supplier<Long> pagesIn = Memoizer.memoize(FreeBsdVirtualMemory::queryPagesIn, Memoizer.defaultExpiration());
    private final Supplier<Long> pagesOut = Memoizer.memoize(FreeBsdVirtualMemory::queryPagesOut, Memoizer.defaultExpiration());

    /*
     * WARNING - void declaration
     */
    FreeBsdVirtualMemory(FreeBsdGlobalMemory freeBsdGlobalMemory) {
        void var1_1;
        this.global = var1_1;
    }

    @Override
    public final long getSwapUsed() {
        return this.used.get();
    }

    @Override
    public final long getSwapTotal() {
        return this.total.get();
    }

    @Override
    public final long getVirtualMax() {
        return this.global.getTotal() + this.getSwapTotal();
    }

    @Override
    public final long getVirtualInUse() {
        return this.global.getTotal() - this.global.getAvailable() + this.getSwapUsed();
    }

    @Override
    public final long getSwapPagesIn() {
        return this.pagesIn.get();
    }

    @Override
    public final long getSwapPagesOut() {
        return this.pagesOut.get();
    }

    /*
     * WARNING - void declaration
     */
    private static long querySwapUsed() {
        void var0;
        String swapInfo = ExecutingCommand.getAnswerAt("swapinfo -k", 1);
        String[] split = ParseUtil.whitespaces.split(swapInfo);
        if (split.length < 5) {
            return 0L;
        }
        return ParseUtil.parseLongOrDefault((String)var0[2], 0L) << 10;
    }

    private static long querySwapTotal() {
        return BsdSysctlUtil.sysctl("vm.swap_total", 0L);
    }

    private static long queryPagesIn() {
        return BsdSysctlUtil.sysctl("vm.stats.vm.v_swappgsin", 0L);
    }

    private static long queryPagesOut() {
        return BsdSysctlUtil.sysctl("vm.stats.vm.v_swappgsout", 0L);
    }
}

