/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.SoundCard;
import oshi.hardware.common.AbstractSoundCard;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@Immutable
final class FreeBsdSoundCard
extends AbstractSoundCard {
    private static final String LSHAL = "lshal";

    /*
     * WARNING - void declaration
     */
    FreeBsdSoundCard(String kernelVersion, String name, String codec) {
        super((String)var1_1, (String)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<SoundCard> getSoundCards() {
        HashMap<String, String> vendorMap = new HashMap<String, String>();
        HashMap<String, String> productMap = new HashMap<String, String>();
        vendorMap.clear();
        productMap.clear();
        ArrayList<String> sounds = new ArrayList<String>();
        String key = "";
        for (String string : ExecutingCommand.runNative(LSHAL)) {
            String object = string.trim();
            if (object.startsWith("udi =")) {
                key = ParseUtil.getSingleQuoteStringValue(object);
                continue;
            }
            if (key.isEmpty() || object.isEmpty()) continue;
            if (object.contains("freebsd.driver =") && "pcm".equals(ParseUtil.getSingleQuoteStringValue(object))) {
                sounds.add(key);
                continue;
            }
            if (object.contains("info.product")) {
                productMap.put(key, ParseUtil.getStringBetween(object, '\''));
                continue;
            }
            if (!object.contains("info.vendor")) continue;
            vendorMap.put(key, ParseUtil.getStringBetween(object, '\''));
        }
        ArrayList<SoundCard> soundCards = new ArrayList<SoundCard>();
        for (String s : sounds) {
            void var2_2;
            soundCards.add(new FreeBsdSoundCard((String)productMap.get(s), (String)vendorMap.get(s) + " " + (String)productMap.get(s), (String)productMap.get(var2_2)));
        }
        return soundCards;
    }
}

