/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;
import oshi.util.tuples.Triplet;

@Immutable
final class FreeBsdFirmware
extends AbstractFirmware {
    private final Supplier<Triplet<String, String, String>> manufVersRelease = Memoizer.memoize(FreeBsdFirmware::readDmiDecode);

    FreeBsdFirmware() {
    }

    @Override
    public final String getManufacturer() {
        return this.manufVersRelease.get().getA();
    }

    @Override
    public final String getVersion() {
        return this.manufVersRelease.get().getB();
    }

    @Override
    public final String getReleaseDate() {
        return this.manufVersRelease.get().getC();
    }

    /*
     * WARNING - void declaration
     */
    private static Triplet<String, String, String> readDmiDecode() {
        void var2_2;
        void var1_1;
        void var0;
        String manufacturer = null;
        String version = null;
        String releaseDate = "";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t bios")) {
            if (checkLine.contains("Vendor:")) {
                manufacturer = checkLine.split("Vendor:")[1].trim();
                continue;
            }
            if (checkLine.contains("Version:")) {
                version = checkLine.split("Version:")[1].trim();
                continue;
            }
            if (!checkLine.contains("Release Date:")) continue;
            releaseDate = checkLine.split("Release Date:")[1].trim();
        }
        releaseDate = ParseUtil.parseMmDdYyyyToYyyyMmDD(releaseDate);
        return new Triplet<String, String, String>((String)(Util.isBlank(manufacturer) ? "unknown" : var0), (String)(Util.isBlank(version) ? "unknown" : var1_1), (String)(Util.isBlank(releaseDate) ? "unknown" : var2_2));
    }
}

