/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.aix;

import java.util.List;
import java.util.function.Supplier;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.unix.aix.AixBaseboard;
import oshi.hardware.platform.unix.aix.AixFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;

@Immutable
final class AixComputerSystem
extends AbstractComputerSystem {
    private final Supplier<LsattrStrings> lsattrStrings = Memoizer.memoize(AixComputerSystem::readLsattr);
    private final Supplier<List<String>> lscfg;

    /*
     * WARNING - void declaration
     */
    AixComputerSystem(Supplier<List<String>> lscfg) {
        void var1_1;
        this.lscfg = var1_1;
    }

    @Override
    public final String getManufacturer() {
        return this.lsattrStrings.get().manufacturer;
    }

    @Override
    public final String getModel() {
        return this.lsattrStrings.get().model;
    }

    @Override
    public final String getSerialNumber() {
        return this.lsattrStrings.get().serialNumber;
    }

    @Override
    public final String getHardwareUUID() {
        return this.lsattrStrings.get().uuid;
    }

    @Override
    public final Firmware createFirmware() {
        return new AixFirmware(this.lsattrStrings.get().biosVendor, this.lsattrStrings.get().biosPlatformVersion, this.lsattrStrings.get().biosVersion);
    }

    @Override
    public final Baseboard createBaseboard() {
        return new AixBaseboard(this.lscfg);
    }

    /*
     * WARNING - void declaration
     */
    private static LsattrStrings readLsattr() {
        void var3_3;
        void var1_1;
        void var2_2;
        void var0;
        String fwVendor = "IBM";
        String fwVersion = null;
        String fwPlatformVersion = null;
        String manufacturer = fwVendor;
        String model = null;
        String serialNumber = null;
        String uuid = null;
        for (String checkLine : ExecutingCommand.runNative("lsattr -El sys0")) {
            void comma2;
            if (checkLine.startsWith("fwversion")) {
                fwVersion = checkLine.split("fwversion")[1].trim();
                int comma2 = fwVersion.indexOf(44);
                if (comma2 > 0 && fwVersion.length() > comma2) {
                    fwVendor = fwVersion.substring(0, comma2);
                    fwVersion = fwVersion.substring(comma2 + 1);
                }
                fwVersion = ParseUtil.whitespaces.split(fwVersion)[0];
                continue;
            }
            if (comma2.startsWith("modelname")) {
                model = comma2.split("modelname")[1].trim();
                int comma3 = model.indexOf(44);
                if (comma3 > 0 && model.length() > comma3) {
                    manufacturer = model.substring(0, comma3);
                    model = model.substring(comma3 + 1);
                }
                model = ParseUtil.whitespaces.split(model)[0];
                continue;
            }
            if (comma2.startsWith("systemid")) {
                serialNumber = comma2.split("systemid")[1].trim();
                serialNumber = ParseUtil.whitespaces.split(serialNumber)[0];
                continue;
            }
            if (!comma2.startsWith("os_uuid")) continue;
            uuid = comma2.split("os_uuid")[1].trim();
            uuid = ParseUtil.whitespaces.split(uuid)[0];
        }
        for (String checkLine : ExecutingCommand.runNative("lsmcode -c")) {
            if (!checkLine.startsWith("Platform Firmware level is")) continue;
            fwPlatformVersion = checkLine.split("Platform Firmware level is")[1].trim();
            break;
        }
        return new LsattrStrings((String)var0, (String)var2_2, (String)var1_1, (String)var3_3, model, serialNumber, uuid);
    }

    private static final class LsattrStrings {
        private final String biosVendor;
        private final String biosPlatformVersion;
        private final String biosVersion;
        private final String manufacturer;
        private final String model;
        private final String serialNumber;
        private final String uuid;

        /*
         * WARNING - void declaration
         */
        private LsattrStrings(String biosVendor, String biosPlatformVersion, String biosVersion, String manufacturer, String model, String serialNumber, String uuid) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.biosVendor = Util.isBlank(biosVendor) ? "unknown" : var1_1;
            this.biosPlatformVersion = Util.isBlank(biosPlatformVersion) ? "unknown" : var2_2;
            this.biosVersion = Util.isBlank(biosVersion) ? "unknown" : var3_3;
            this.manufacturer = Util.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.model = Util.isBlank(model) ? "unknown" : model;
            this.serialNumber = Util.isBlank(serialNumber) ? "unknown" : serialNumber;
            this.uuid = Util.isBlank(uuid) ? "unknown" : uuid;
        }
    }
}

