/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.aix;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.aix.Lssrad;
import oshi.driver.unix.aix.perfstat.PerfstatConfig;
import oshi.driver.unix.aix.perfstat.PerfstatCpu;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
final class AixCentralProcessor
extends AbstractCentralProcessor {
    private final Supplier<Perfstat.perfstat_cpu_total_t> cpuTotal = Memoizer.memoize(PerfstatCpu::queryCpuTotal, Memoizer.defaultExpiration());
    private final Supplier<Perfstat.perfstat_cpu_t[]> cpuProc = Memoizer.memoize(PerfstatCpu::queryCpu, Memoizer.defaultExpiration());
    private static final int SBITS = AixCentralProcessor.querySbits();
    private Perfstat.perfstat_partition_config_t config;
    private static final long USER_HZ = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf CLK_TCK"), 100L);

    AixCentralProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final CentralProcessor.ProcessorIdentifier queryProcessorId() {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        String cpuVendor = "unknown";
        String cpuName = "";
        String cpuFamily = "";
        boolean cpu64bit = false;
        Object object = ExecutingCommand.runNative("prtconf").iterator();
        while (object.hasNext()) {
            String checkLine = object.next();
            if (checkLine.startsWith("Processor Type:")) {
                cpuName = checkLine.split("Processor Type:")[1].trim();
                if (cpuName.startsWith("P")) {
                    cpuVendor = "IBM";
                    continue;
                }
                if (!cpuName.startsWith("I")) continue;
                cpuVendor = "Intel";
                continue;
            }
            if (checkLine.startsWith("Processor Version:")) {
                cpuFamily = checkLine.split("Processor Version:")[1].trim();
                continue;
            }
            if (!checkLine.startsWith("CPU Type:")) continue;
            cpu64bit = checkLine.split("CPU Type:")[1].contains("64");
        }
        String cpuModel = "";
        String cpuStepping = "";
        String machineId = Native.toString((byte[])this.config.machineID);
        if (machineId.isEmpty()) {
            machineId = ExecutingCommand.getFirstAnswer("uname -m");
        }
        if (machineId.length() > 10) {
            int m = machineId.length() - 4;
            int s = machineId.length() - 2;
            object = machineId.substring(m, s);
            string = machineId.substring(s);
        }
        return new CentralProcessor.ProcessorIdentifier((String)var1_1, (String)var2_2, (String)var3_3, (String)object, string, machineId, cpu64bit, (long)(this.config.processorMHz * 1000000.0));
    }

    @Override
    protected final List<CentralProcessor.LogicalProcessor> initProcessorCounts() {
        int lcpus;
        this.config = PerfstatConfig.queryConfig();
        int physProcs = (int)this.config.numProcessors.max;
        if (physProcs <= 0) {
            physProcs = 1;
        }
        if ((lcpus = this.config.lcpus) <= 0) {
            lcpus = 1;
        }
        Map<Integer, Pair<Integer, Integer>> nodePkgMap = Lssrad.queryNodesPackages();
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        for (int proc = 0; proc < lcpus; ++proc) {
            Pair<Integer, Integer> nodePkg = nodePkgMap.get(proc);
            int n = proc;
            logProcs.add(new CentralProcessor.LogicalProcessor(n, n / physProcs, nodePkg == null ? 0 : nodePkg.getB(), nodePkg == null ? 0 : nodePkg.getA()));
        }
        return logProcs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[] querySystemCpuLoadTicks() {
        void var2_2;
        void var1_1;
        Perfstat.perfstat_cpu_total_t perfstat = this.cpuTotal.get();
        long[] lArray = new long[CentralProcessor.TickType.values().length];
        long[] ticks = lArray;
        lArray[CentralProcessor.TickType.USER.ordinal()] = perfstat.user * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.SYSTEM.ordinal()] = perfstat.sys * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.IDLE.ordinal()] = perfstat.idle * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.IOWAIT.ordinal()] = perfstat.wait * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.IRQ.ordinal()] = perfstat.devintrs * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.SOFTIRQ.ordinal()] = perfstat.softintrs * 1000L / USER_HZ;
        ticks[CentralProcessor.TickType.STEAL.ordinal()] = (perfstat.idle_stolen_purr + var1_1.busy_stolen_purr) * 1000L / USER_HZ;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[] queryCurrentFreq() {
        void var1_1;
        long[] freqs = new long[this.getLogicalProcessorCount()];
        Arrays.fill(freqs, -1L);
        String freqMarker = "runs at";
        int idx = 0;
        for (String checkLine : ExecutingCommand.runNative("pmcycles -m")) {
            if (!checkLine.contains(freqMarker)) continue;
            freqs[idx++] = ParseUtil.parseHertz(checkLine.split(freqMarker)[1].trim());
            if (idx < freqs.length) continue;
        }
        return var1_1;
    }

    @Override
    protected final long queryMaxFreq() {
        Perfstat.perfstat_cpu_total_t perfstat_cpu_total_t2 = this.cpuTotal.get();
        return perfstat_cpu_total_t2.processorHZ;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double[] getSystemLoadAverage(int nelem) {
        void var2_2;
        if (nelem <= 0 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        long[] loadavg = this.cpuTotal.get().loadavg;
        for (int i = 0; i < nelem; ++i) {
            average[i] = (double)loadavg[i] / (double)(1L << SBITS);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long[][] queryProcessorCpuLoadTicks() {
        void var2_2;
        Perfstat.perfstat_cpu_t[] cpu = this.cpuProc.get();
        long[][] ticks = new long[cpu.length][CentralProcessor.TickType.values().length];
        for (int i = 0; i < cpu.length; ++i) {
            ticks[i] = new long[CentralProcessor.TickType.values().length];
            ticks[i][CentralProcessor.TickType.USER.ordinal()] = cpu[i].user * 1000L / USER_HZ;
            ticks[i][CentralProcessor.TickType.SYSTEM.ordinal()] = cpu[i].sys * 1000L / USER_HZ;
            ticks[i][CentralProcessor.TickType.IDLE.ordinal()] = cpu[i].idle * 1000L / USER_HZ;
            ticks[i][CentralProcessor.TickType.IOWAIT.ordinal()] = cpu[i].wait * 1000L / USER_HZ;
            ticks[i][CentralProcessor.TickType.IRQ.ordinal()] = cpu[i].devintrs * 1000L / USER_HZ;
            ticks[i][CentralProcessor.TickType.SOFTIRQ.ordinal()] = cpu[i].softintrs * 1000L / USER_HZ;
            ticks[i][CentralProcessor.TickType.STEAL.ordinal()] = (cpu[i].idle_stolen_purr + cpu[i].busy_stolen_purr) * 1000L / USER_HZ;
        }
        return var2_2;
    }

    @Override
    public final long queryContextSwitches() {
        return this.cpuTotal.get().pswitch;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long queryInterrupts() {
        void var1_1;
        Perfstat.perfstat_cpu_total_t cpu = this.cpuTotal.get();
        return cpu.devintrs + var1_1.softintrs;
    }

    /*
     * WARNING - void declaration
     */
    private static int querySbits() {
        for (String s : FileUtil.readFile("/usr/include/sys/proc.h")) {
            void var1_1;
            if (!s.contains("SBITS") || !s.contains("#define")) continue;
            return ParseUtil.parseLastInt((String)var1_1, 16);
        }
        return 16;
    }
}

